/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import rumblejp.common.beans.BattleResult;
import rumblejp.common.beans.RobotResult;
import rumblejp.common.beans.RobotScore;

public class MeleeScore
extends RobotScore
implements Serializable {
    private int[] divisionResult;
    private int[] roundResult;
    private int totalScore;
    private int attackScore;
    private int ramScore;
    private int finalScore;
    private int surviveScore;
    private double meleeScore;

    public MeleeScore() {
        this(10);
    }

    public MeleeScore(int grouping) {
        this.divisionResult = new int[grouping];
        this.roundResult = new int[3];
    }

    public void clear() {
        int i = 0;
        while (i < this.divisionResult.length) {
            this.divisionResult[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.roundResult.length) {
            this.roundResult[i2] = 0;
            ++i2;
        }
        this.totalScore = 0;
        this.attackScore = 0;
        this.ramScore = 0;
        this.finalScore = 0;
        this.surviveScore = 0;
        this.meleeScore = 0.0;
    }

    public void createScore(int targetId, Collection result) {
        this.clear();
        if (result == null || result.size() == 0) {
            return;
        }
        int totalRobots = 0;
        Iterator i = result.iterator();
        while (i.hasNext()) {
            BattleResult battleResult = (BattleResult)i.next();
            RobotResult[] robotResults = battleResult.getRobotResults();
            int robotCount = robotResults.length - 1;
            int j = 0;
            while (j < robotResults.length) {
                if (robotResults[j].getRobotId() == targetId) {
                    RobotResult my = robotResults[j];
                    int n = j;
                    this.divisionResult[n] = this.divisionResult[n] + 1;
                    this.roundResult[0] = this.roundResult[0] + my.getFirsts();
                    this.roundResult[1] = this.roundResult[1] + my.getSeconds();
                    this.roundResult[2] = this.roundResult[2] + my.getThirds();
                    this.totalScore += my.getScore() / robotCount;
                    this.attackScore += my.getBulletDamage() / robotCount;
                    this.ramScore += my.getRamDamage() / robotCount;
                    this.finalScore += (my.getBulletDamageBonus() + my.getRamDamageBonus()) / robotCount;
                    this.surviveScore += my.getSurvival() / robotCount;
                    this.meleeScore = this.meleeScore * (double)totalRobots + (double)(robotCount - j);
                    this.meleeScore /= (double)(totalRobots += robotCount);
                }
                ++j;
            }
        }
        this.profile();
    }

    public int getTotalRounds() {
        int totalRounds = 0;
        int i = 0;
        while (i < this.divisionResult.length) {
            totalRounds += this.divisionResult[i];
            ++i;
        }
        return totalRounds;
    }

    private void profile() {
        int totalRounds = this.getTotalRounds();
        if (totalRounds > 0) {
            this.totalScore = 200 * this.totalScore / totalRounds / 180;
            this.attackScore = 200 * this.attackScore / totalRounds / 100;
            this.ramScore = 200 * this.ramScore / totalRounds / 10;
            this.finalScore = 200 * this.finalScore / totalRounds / 10;
            this.surviveScore = 200 * this.surviveScore / totalRounds / 50;
            this.meleeScore = 200.0 * this.meleeScore;
        }
        this.totalScore = this.limit(this.totalScore);
        this.attackScore = this.limit(this.attackScore);
        this.ramScore = this.limit(this.ramScore);
        this.finalScore = this.limit(this.finalScore);
        this.surviveScore = this.limit(this.surviveScore);
        this.meleeScore = this.limit((int)this.meleeScore);
    }

    public int[] getDivisionResult() {
        return this.divisionResult;
    }

    public int[] getRoundResult() {
        return this.roundResult;
    }

    public int getTotalScore() {
        return this.totalScore;
    }

    public int getAttackScore() {
        return this.attackScore;
    }

    public int getRamScore() {
        return this.ramScore;
    }

    public int getFinalScore() {
        return this.finalScore;
    }

    public int getSurviveScore() {
        return this.surviveScore;
    }

    public int getMeleeScore() {
        return (int)this.meleeScore;
    }

    public void setDivisionResult(int[] divisionResult) {
        this.divisionResult = divisionResult;
    }

    public void setRoundResult(int[] roundResult) {
        this.roundResult = roundResult;
    }

    public void setTotalScore(int totalScore) {
        this.totalScore = totalScore;
    }

    public void setAttackScore(int attackScore) {
        this.attackScore = attackScore;
    }

    public void setRamScore(int ramScore) {
        this.ramScore = ramScore;
    }

    public void setFinalScore(int finalScore) {
        this.finalScore = finalScore;
    }

    public void setSurviveScore(int surviveScore) {
        this.surviveScore = surviveScore;
    }

    public void setMeleeScore(int meleeScore) {
        this.meleeScore = meleeScore;
    }

    public String getDivisionResultString() {
        return this.toString(this.divisionResult);
    }

    public String getRoundResultString() {
        return this.toString(this.roundResult);
    }
}

