/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.beans;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import rumblejp.common.beans.LeagueCondition;
import rumblejp.common.beans.Robot;
import rumblejp.common.beans.RobotVersion;
import rumblejp.common.beans.SeasonRobot;

public class RobotSummary
implements Serializable {
    private String currentVersion;
    private int userId;
    private Date registDate;
    private Date updateDate;
    private String description;
    private String name;
    private RobotVersion[] versions = null;
    private int leagueId;
    private int season;
    private int robotVersionId;
    private int rank;
    private int previousRank;
    private int totalScore;
    private int survival;
    private int lastSurvivor;
    private int bulletDmg;
    private int bulletDmgBonus;
    private int ramDmg;
    private int ramDmgBonus;
    private int firsts;
    private int seconds;
    private int thirds;
    private String version;
    private int robotId;
    private String className;
    private int rankShift;
    private int latestCompletedSeason;
    private LeagueCondition condition;
    private SeasonRobot[] robotsInSameDivision;
    private long startDate;
    private long finishDate;

    public RobotSummary(Robot robot, SeasonRobot srobot, int latestCompletedSeason) {
        this.currentVersion = robot.getCurrentVersion();
        this.userId = robot.getUserId();
        this.registDate = robot.getRegistDate();
        this.updateDate = robot.getUpdateDate();
        this.description = robot.getDescription();
        this.name = robot.getName();
        this.versions = robot.getVersions();
        this.leagueId = srobot.getLeagueId();
        this.season = srobot.getSeason();
        this.robotVersionId = srobot.getRobotVersionId();
        this.rank = srobot.getRank();
        this.previousRank = srobot.getPreviousRank();
        this.totalScore = srobot.getTotalScore();
        this.survival = srobot.getSurvival();
        this.lastSurvivor = srobot.getLastSurvivor();
        this.bulletDmg = srobot.getBulletDmg();
        this.bulletDmgBonus = srobot.getBulletDmgBonus();
        this.ramDmg = srobot.getRamDmg();
        this.ramDmgBonus = srobot.getRamDmgBonus();
        this.firsts = srobot.getFirsts();
        this.seconds = srobot.getSeconds();
        this.thirds = srobot.getThirds();
        this.version = srobot.getVersion();
        this.robotId = robot.getRobotId();
        this.className = robot.getClassName();
        this.rankShift = this.previousRank - this.rank;
        this.latestCompletedSeason = latestCompletedSeason;
    }

    public Map getSeasonId() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("leagueId", String.valueOf(this.leagueId));
        map.put("season", String.valueOf(this.latestCompletedSeason));
        map.put("focusRobotId", String.valueOf(this.robotId));
        return map;
    }

    public int getBulletDmg() {
        return this.bulletDmg;
    }

    public int getBulletDmgBonus() {
        return this.bulletDmgBonus;
    }

    public String getClassName() {
        return this.className;
    }

    public int getFirsts() {
        return this.firsts;
    }

    public int getLastSurvivor() {
        return this.lastSurvivor;
    }

    public int getLeagueId() {
        return this.leagueId;
    }

    public int getRamDmg() {
        return this.ramDmg;
    }

    public int getRamDmgBonus() {
        return this.ramDmgBonus;
    }

    public int getRank() {
        return this.rank;
    }

    public int getRobotId() {
        return this.robotId;
    }

    public int getRobotVersionId() {
        return this.robotVersionId;
    }

    public int getSeason() {
        return this.season;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getSurvival() {
        return this.survival;
    }

    public int getThirds() {
        return this.thirds;
    }

    public int getTotalScore() {
        return this.totalScore;
    }

    public void setBulletDmg(int bulletDmg) {
        this.bulletDmg = bulletDmg;
    }

    public void setBulletDmgBonus(int bulletDmgBonus) {
        this.bulletDmgBonus = bulletDmgBonus;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setFirsts(int firsts) {
        this.firsts = firsts;
    }

    public void setLastSurvivor(int lastSurvivor) {
        this.lastSurvivor = lastSurvivor;
    }

    public void setLeagueId(int leagueId) {
        this.leagueId = leagueId;
    }

    public void setRamDmg(int ramDmg) {
        this.ramDmg = ramDmg;
    }

    public void setRamDmgBonus(int ramDmgBonus) {
        this.ramDmgBonus = ramDmgBonus;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void setRobotId(int robotId) {
        this.robotId = robotId;
    }

    public void setRobotVersionId(int robotVersionId) {
        this.robotVersionId = robotVersionId;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public void setSurvival(int survival) {
        this.survival = survival;
    }

    public void setThirds(int tierds) {
        this.thirds = tierds;
    }

    public void setTotalScore(int totalScore) {
        this.totalScore = totalScore;
    }

    public int getPreviousRank() {
        return this.previousRank;
    }

    public void setPreviousRank(int previousRank) {
        this.previousRank = previousRank;
    }

    public int getShift() {
        if (this.previousRank == 0) {
            return 0;
        }
        return this.previousRank - this.rank;
    }

    public int getAbsShift() {
        return Math.abs(this.getShift());
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public Date getRegistDate() {
        return this.registDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RobotVersion[] getVersions() {
        return this.versions;
    }

    public void setVersions(RobotVersion[] versions) {
        this.versions = versions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRankShift() {
        return this.rankShift;
    }

    public void setRankShift(int rankShift) {
        this.rankShift = rankShift;
    }

    public int getLatestCompletedSeason() {
        return this.latestCompletedSeason;
    }

    public void setLatestCompletedSeason(int latestCompletedSeason) {
        this.latestCompletedSeason = latestCompletedSeason;
    }

    public long getFinishDate() {
        return this.finishDate;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public void setFinishDate(long finishDate) {
        this.finishDate = finishDate;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public LeagueCondition getCondition() {
        return this.condition;
    }

    public void setCondition(LeagueCondition condition) {
        this.condition = condition;
    }

    public void setRobotsInSameDivision(SeasonRobot[] robotsInSameDivision) {
        this.robotsInSameDivision = robotsInSameDivision;
    }

    public SeasonRobot[] getRobotsInSameDivision() {
        return this.robotsInSameDivision;
    }

    public static class UpdateDateComparator
    implements Comparator {
        public int compare(Object olhs, Object orhs) {
            RobotSummary lhs = (RobotSummary)olhs;
            RobotSummary rhs = (RobotSummary)orhs;
            int comp = lhs.getUpdateDate().compareTo(rhs.getUpdateDate());
            if (comp != 0) {
                return -comp;
            }
            return new NameComparator().compare(lhs, rhs);
        }
    }

    public static class RegistDateComparator
    implements Comparator {
        public int compare(Object olhs, Object orhs) {
            RobotSummary lhs = (RobotSummary)olhs;
            RobotSummary rhs = (RobotSummary)orhs;
            int comp = lhs.getRegistDate().compareTo(rhs.getRegistDate());
            if (comp != 0) {
                return -comp;
            }
            return new NameComparator().compare(lhs, rhs);
        }
    }

    public static class RankComparator
    implements Comparator {
        public int compare(Object olhs, Object orhs) {
            RobotSummary lhs = (RobotSummary)olhs;
            RobotSummary rhs = (RobotSummary)orhs;
            int comp = lhs.getRank() - rhs.getRank();
            if (comp != 0) {
                return comp;
            }
            return new NameComparator().compare(lhs, rhs);
        }
    }

    public static class NameComparator
    implements Comparator {
        public int compare(Object olhs, Object orhs) {
            RobotSummary lhs = (RobotSummary)olhs;
            RobotSummary rhs = (RobotSummary)orhs;
            return lhs.getName().compareTo(rhs.getName());
        }
    }
}

