/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.beans;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class RobotVersion
implements Serializable {
    public static final int TYPE_ROBOT = 1;
    public static final int TYPE_ADVANCED = 2;
    public static final int TYPE_TEAM = 3;
    public static final int TYPE_DROID = 16;
    public static final int TYPE_IO = 256;
    public static final String[] TYPE_NAME = new String[]{"\u4e0d\u660e", "Robot", "AdvancedRobot", "TeamRobot"};
    private int robotVersionId = -1;
    private int robotId = -1;
    private String version = null;
    private int download = -1;
    private Date registDate = null;
    private String jarFile = null;
    private String url = null;
    private String description = null;
    private String className = null;
    private int robotType = 0;

    public RobotVersion() {
    }

    public RobotVersion(ResultSet rs) throws SQLException {
        this.robotVersionId = rs.getInt("robot_version_id");
        this.robotId = rs.getInt("robot_id");
        this.version = rs.getString("version");
        this.download = rs.getInt("download");
        this.registDate = new Date(rs.getTimestamp("regist_date").getTime());
        this.jarFile = rs.getString("jar_file");
        this.url = rs.getString("url");
        this.description = rs.getString("description");
        this.className = rs.getString("class_name");
    }

    public String getDescription() {
        return this.description;
    }

    public int getDownload() {
        return this.download;
    }

    public String getJarFile() {
        return this.jarFile;
    }

    public Date getRegistDate() {
        return this.registDate;
    }

    public int getRobotId() {
        return this.robotId;
    }

    public int getRobotVersionId() {
        return this.robotVersionId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDownload(int download) {
        this.download = download;
    }

    public void setJarFile(String jarFile) {
        this.jarFile = jarFile;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }

    public void setRobotId(int robotId) {
        this.robotId = robotId;
    }

    public void setRobotVersionId(int robotVersionId) {
        this.robotVersionId = robotVersionId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public int getRobotType() {
        return this.robotType;
    }

    public void setRobotType(int robotType) {
        this.robotType = robotType;
    }

    public String getBaseType() {
        int baseType = this.robotType & 3;
        String tmp = TYPE_NAME[baseType];
        if ((this.robotType & 0x10) != 0) {
            tmp = tmp + " - Droid";
        }
        return tmp;
    }

    public int getIoType() {
        if ((this.robotType & 3) == 0) {
            return 0;
        }
        if ((this.robotType & 2) == 0) {
            return 1;
        }
        if ((this.robotType & 0x100) != 0) {
            return 2;
        }
        return 1;
    }
}

