/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.distribute;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Policy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import robocode.RobocodeFileOutputStream;
import robocode.battle.Battle;
import robocode.battle.BattleProperties;
import robocode.control.BattleSpecification;
import robocode.control.RobocodeListener;
import robocode.control.RobotResults;
import robocode.manager.BattleManager;
import robocode.manager.RobocodeManager;
import robocode.manager.ThreadManager;
import robocode.peer.ContestantPeer;
import robocode.peer.ContestantPeerVector;
import robocode.peer.ContestantStatistics;
import robocode.peer.RobotPeer;
import robocode.peer.TeamPeer;
import robocode.repository.FileSpecification;
import robocode.repository.FileSpecificationVector;
import robocode.repository.Repository;
import robocode.security.RobocodeSecurityManager;
import robocode.security.RobocodeSecurityPolicy;
import robocode.security.SecureInputStream;
import robocode.security.SecurePrintStream;
import robocode.util.Constants;
import rumblejp.common.Env;
import rumblejp.common.PropertyException;
import rumblejp.distribute.BattleStatusListener;
import rumblejp.distribute.remote.BattleResult;
import rumblejp.distribute.remote.BattleSpec;
import rumblejp.distribute.remote.RobotResult;
import rumblejp.distribute.remote.RobotSpec;

public class AugmentedRobocodeEngine
implements BattleStatusListener {
    private static Logger logger = Logger.getLogger((Class)(class$rumblejp$distribute$AugmentedRobocodeEngine == null ? (class$rumblejp$distribute$AugmentedRobocodeEngine = AugmentedRobocodeEngine.class$("rumblejp.distribute.AugmentedRobocodeEngine")) : class$rumblejp$distribute$AugmentedRobocodeEngine));
    private File rootDir;
    private RobocodeManager manager = null;
    private SecurityManager secManager = null;
    private Map robots = new HashMap();
    private RobotResult[] results = null;
    static /* synthetic */ Class class$rumblejp$distribute$AugmentedRobocodeEngine;

    public AugmentedRobocodeEngine(File rootDir) throws IOException, ClassNotFoundException, PropertyException {
        this.rootDir = rootDir;
        this.updateRobots();
    }

    public synchronized void battleAborted(BattleProperties spec) {
        this.results = null;
        this.notifyAll();
    }

    public synchronized void battleComplete(BattleProperties spec, RobotResult[] results) {
        this.results = results;
        logger.info((Object)"Battle completed.");
        this.notifyAll();
    }

    public void battleMessage(String msg) {
    }

    /*
     * WARNING - void declaration
     */
    private void updateRobots() throws IOException, ClassNotFoundException, PropertyException {
        int len;
        logger.info((Object)"Checking new robot.");
        String str = Env.getString("robotdownload.url") + "?hostname=" + Env.getString("hostname") + "&password=" + Env.getString("password");
        URL url = new URL(str);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setIfModifiedSince(this.getLastRobotDate());
        con.setUseCaches(false);
        con.connect();
        if (con.getResponseCode() == 304) {
            logger.info((Object)"Any new robots does'not exist.");
            if (this.manager == null) {
                this.createRobocodeEngine();
            }
            return;
        }
        this.shutdownRobocodeEngine();
        File robotpack = new File(this.rootDir, "robotpack.zip");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(robotpack));
        BufferedInputStream in = new BufferedInputStream(con.getInputStream());
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) != -1) {
            void var8_8;
            out.write(buf, 0, (int)var8_8);
        }
        in.close();
        out.flush();
        out.close();
        logger.info((Object)"Downloaded Robotpack.");
        int count = 0;
        File robotsDir = new File(this.rootDir, "robots");
        ZipFile zip = new ZipFile(robotpack);
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            BufferedInputStream robotin = new BufferedInputStream(zip.getInputStream(entry));
            File robotFile = new File(robotsDir, entry.getName());
            BufferedOutputStream robotout = new BufferedOutputStream(new FileOutputStream(robotFile));
            while ((len = robotin.read(buf)) != -1) {
                robotout.write(buf, 0, len);
            }
            robotin.close();
            robotout.close();
            logger.info((Object)("Downloaded " + robotFile.getName()));
            ++count;
        }
        zip.close();
        logger.info((Object)("Downloaded " + count + " robots."));
        this.createRobocodeEngine();
    }

    private void initSecurity() throws IOException, ClassNotFoundException {
        Constants.setWorkingDirectory((File)this.rootDir);
        Thread.currentThread().setName("Application Thread");
        RobocodeSecurityPolicy securityPolicy = new RobocodeSecurityPolicy(Policy.getPolicy());
        Policy.setPolicy((Policy)securityPolicy);
        System.setSecurityManager((SecurityManager)new RobocodeSecurityManager(Thread.currentThread(), this.manager.getThreadManager(), true));
        RobocodeFileOutputStream.setThreadManager((ThreadManager)this.manager.getThreadManager());
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg != null) {
            ((RobocodeSecurityManager)System.getSecurityManager()).addSafeThreadGroup(tg);
            tg = tg.getParent();
        }
        SecurePrintStream sysout = new SecurePrintStream((OutputStream)System.out, true, "System.out");
        SecurePrintStream syserr = new SecurePrintStream((OutputStream)System.err, true, "System.err");
        SecureInputStream sysin = new SecureInputStream(System.in, "System.in");
        System.setOut((PrintStream)sysout);
        if (!System.getProperty("debug", "false").equals("true")) {
            System.setErr((PrintStream)syserr);
        }
        System.setIn((InputStream)sysin);
    }

    private void createRobocodeEngine() throws IOException, ClassNotFoundException {
        if (this.manager != null) {
            this.shutdownRobocodeEngine();
        }
        this.manager = new AdvancedRobocodeManager(false, this);
        this.initSecurity();
        this.manager.getWindowManager().getRobocodeFrame().setVisible(false);
        this.robots.clear();
        FileSpecification[] specs = this.getLocalRobots();
        logger.info((Object)("RobotSpecs:" + specs.length));
        int i = 0;
        while (i < specs.length) {
            logger.info((Object)specs[i].getJarFile().getName());
            this.robots.put(specs[i].getJarFile().getName(), specs[i]);
            ++i;
        }
        this.secManager = System.getSecurityManager();
        System.setSecurityManager(null);
    }

    private void shutdownRobocodeEngine() {
        if (this.manager != null) {
            this.manager.getWindowManager().getRobocodeFrame().dispose();
        }
        this.manager = null;
        this.secManager = null;
    }

    protected FileSpecification[] getLocalRobots() {
        Repository robotRepository = this.manager.getRobotRepositoryManager().getRobotRepository();
        FileSpecificationVector v = robotRepository.getRobotSpecificationsVector(false, false, true, false, false, false);
        FileSpecification[] robotSpecs = new FileSpecification[v.size()];
        int i = 0;
        while (i < robotSpecs.length) {
            robotSpecs[i] = v.elementAt(i);
            ++i;
        }
        return robotSpecs;
    }

    protected FileSpecification[] getLocalRepository() {
        Repository robotRepository = this.manager.getRobotRepositoryManager().getRobotRepository();
        FileSpecificationVector v = robotRepository.getRobotSpecificationsVector(false, false, false, false, false, false);
        FileSpecification[] robotSpecs = new FileSpecification[v.size()];
        int i = 0;
        while (i < robotSpecs.length) {
            robotSpecs[i] = v.elementAt(i);
            ++i;
        }
        return robotSpecs;
    }

    private long getLastRobotDate() throws IOException {
        File robotpack = new File(this.rootDir, "robotpack.zip");
        if (!robotpack.exists()) {
            return 0L;
        }
        ZipFile zip = new ZipFile(robotpack);
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        long lastModified = 0L;
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (lastModified >= entry.getTime()) continue;
            lastModified = entry.getTime();
        }
        zip.close();
        return lastModified;
    }

    public synchronized BattleResult runBattle(int rounds, int fieldHeight, int fieldWidth, double coolingRate, int inactivityTime, BattleSpec battleSpec) throws Exception {
        RobotSpec[] robotSpecs = battleSpec.getRobotSpecs();
        this.updateRobots();
        AdvancedBattleProperties battle = new AdvancedBattleProperties();
        battle.setNumRounds(rounds);
        battle.setBattlefieldHeight(fieldHeight);
        battle.setBattlefieldWidth(fieldWidth);
        battle.setGunCoolingRate(coolingRate);
        battle.setInactivityTime(inactivityTime);
        logger.info((Object)"Starting new battle.");
        int i = 0;
        while (i < robotSpecs.length) {
            logger.info((Object)("  Robot[" + i + "] " + robotSpecs[i].getJarFile()));
            FileSpecification battleRobots = (FileSpecification)this.robots.get(robotSpecs[i].getJarFile());
            if (battleRobots == null) {
                throw new RuntimeException("Cannot find robot " + robotSpecs[i].getJarFile());
            }
            battle.addBattleRobot(battleRobots, robotSpecs[i]);
            ++i;
        }
        System.setSecurityManager(this.secManager);
        this.manager.getBattleManager().startNewBattle((BattleProperties)battle, false);
        logger.info((Object)"Robocode engine is running.");
        this.wait();
        System.setSecurityManager(null);
        if (this.results != null) {
            int i2 = 0;
            while (i2 < this.results.length) {
                RobotSpec robot = null;
                int j = 0;
                while (j < robotSpecs.length) {
                    if (robotSpecs[j].getRobotId() == this.results[i2].getRobotId()) {
                        robot = robotSpecs[j];
                        break;
                    }
                    ++j;
                }
                if (robot == null) {
                    logger.error((Object)("Cannot find robot[robotId:" + this.results[i2].getRobotId() + "]."));
                } else {
                    logger.info((Object)("  TotalScore:" + this.results[i2].getScore() + " " + robot.getRobotClassName() + " [robotId:" + robot.getRobotId() + "]"));
                }
                ++i2;
            }
        }
        BattleResult battleResult = new BattleResult();
        battleResult.setBattleSpec(battleSpec);
        battleResult.setRobotResults(this.results);
        return battleResult;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class AdvancedRobocodeManager
    extends RobocodeManager {
        private BattleStatusListener battleStatusListener;
        private AdvancedBattleManager advancedBattleManager;

        public AdvancedRobocodeManager(boolean slave, BattleStatusListener listener) {
            super(slave, null);
            this.setListener(new DummyAdapter());
            this.battleStatusListener = listener;
        }

        public BattleManager getBattleManager() {
            if (this.advancedBattleManager == null) {
                this.advancedBattleManager = new AdvancedBattleManager(this);
            }
            return this.advancedBattleManager;
        }

        class AdvancedBattleManager
        extends BattleManager {
            public AdvancedBattleManager(RobocodeManager manager) {
                super(manager);
            }

            public void sendResultsToListener(Battle battle, RobocodeListener listener) {
                if (AdvancedRobocodeManager.this.battleStatusListener == null) {
                    return;
                }
                ContestantPeerVector orderedContestants = (ContestantPeerVector)battle.getContestants().clone();
                orderedContestants.sort();
                AdvancedBattleProperties prop = (AdvancedBattleProperties)this.getBattleProperties();
                RobotResult[] results = new RobotResult[orderedContestants.size()];
                int i = 0;
                while (i < results.length) {
                    ContestantPeer cp = orderedContestants.elementAt(i);
                    if (!(cp instanceof RobotPeer)) {
                        if (cp instanceof TeamPeer) {
                            throw new RuntimeException("TeamPeer is not supported yet.");
                        }
                        throw new RuntimeException("Unknown Peer.");
                    }
                    results[i] = this.createRobotResult((RobotPeer)cp, prop);
                    ++i;
                }
                AdvancedRobocodeManager.this.battleStatusListener.battleComplete(prop, results);
            }

            protected RobotResult createRobotResult(RobotPeer peer, AdvancedBattleProperties prop) {
                RobotResult result = new RobotResult();
                RobotSpec rs = prop.getBattleRobot((FileSpecification)peer.getRobotClassManager().getRobotSpecification());
                if (rs == null) {
                    throw new RuntimeException("Failed to get robot id.");
                }
                result.setRobotId(rs.getRobotId());
                ContestantStatistics cs = peer.getStatistics();
                result.setScore((int)cs.getTotalScore());
                result.setSurvival((int)cs.getTotalSurvivalScore());
                result.setLastSurvivorBonus((int)cs.getTotalWinnerScore());
                result.setBulletDamage((int)cs.getTotalBulletDamageScore());
                result.setBulletDamageBonus((int)cs.getTotalKilledEnemyBulletScore());
                result.setRamDamage((int)cs.getTotalRammingDamageScore());
                result.setRamDamageBonus((int)cs.getTotalKilledEnemyRammingScore());
                result.setFirsts(cs.getTotalFirsts());
                result.setSeconds(cs.getTotalSeconds());
                result.setThirds(cs.getTotalThirds());
                return result;
            }
        }

        class DummyAdapter
        implements RobocodeListener {
            DummyAdapter() {
            }

            public void battleComplete(BattleSpecification battlespecification, RobotResults[] arobotresults) {
                throw new RuntimeException("RobocodeListner.battleComplete should not be invoked.");
            }

            public void battleAborted(BattleSpecification battlespecification) {
                if (AdvancedRobocodeManager.this.battleStatusListener != null) {
                    AdvancedRobocodeManager.this.battleStatusListener.battleAborted(AdvancedRobocodeManager.this.getBattleManager().getBattleProperties());
                }
            }

            public void battleMessage(String s) {
                if (AdvancedRobocodeManager.this.battleStatusListener != null) {
                    AdvancedRobocodeManager.this.battleStatusListener.battleMessage(s);
                }
            }
        }
    }

    class AdvancedBattleProperties
    extends BattleProperties {
        private Map battleRobotMap = new HashMap();
        private String members = "";

        public void addBattleRobot(FileSpecification robot, RobotSpec battleRobot) {
            this.battleRobotMap.put(robot, battleRobot);
            this.members = this.members.equals("") ? robot.getFullClassNameWithVersion() : this.members + "," + robot.getFullClassNameWithVersion();
            super.setSelectedRobots(this.members);
        }

        public RobotSpec getBattleRobot(FileSpecification robot) {
            return (RobotSpec)this.battleRobotMap.get(robot);
        }
    }
}

