/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.distribute;

import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import rumblejp.common.Env;
import rumblejp.distribute.AugmentedRobocodeEngine;
import rumblejp.distribute.remote.BattleResult;
import rumblejp.distribute.remote.BattleResultSet;
import rumblejp.distribute.remote.BattleSpec;
import rumblejp.distribute.remote.BattleSpecSet;
import rumblejp.distribute.remote.Battles;
import rumblejp.distribute.remote.BattlesServiceLocator;

public class Server {
    private static Logger logger = Logger.getLogger((Class)(class$rumblejp$distribute$Server == null ? (class$rumblejp$distribute$Server = Server.class$("rumblejp.distribute.Server")) : class$rumblejp$distribute$Server));
    private String hostname;
    private String password;
    static /* synthetic */ Class class$rumblejp$distribute$Server;

    public static void main(String[] args) throws Exception {
        Server app = new Server();
        if (args.length == 0) {
            app.run(-1);
        } else {
            app.run(Integer.parseInt(args[0]));
        }
    }

    public void run(int times) throws Exception {
        DOMConfigurator.configure((String)"log4j.xml");
        this.hostname = Env.getString("hostname");
        this.password = Env.getString("password");
        File rootDir = new File(".");
        AugmentedRobocodeEngine engine = new AugmentedRobocodeEngine(rootDir);
        URL endpoint = new URL(Env.getString("endpoint.battles"));
        BattlesServiceLocator service = new BattlesServiceLocator();
        Battles battles = service.getBattles(endpoint);
        logger.info((Object)"Distribute server started.");
        logger.info((Object)"Check new battle.");
        BattleSpecSet set = battles.getNewBattle(this.hostname, this.password);
        int t = 0;
        while (true) {
            if (set != null) {
                logger.info((Object)("Accepted new division[leagueId:" + set.getLeagueId() + " season:" + set.getSeason() + " division:" + set.getDivision() + "], " + set.getBattles().length + " battles."));
                BattleResultSet resultSet = new BattleResultSet();
                resultSet.setLeagueId(set.getLeagueId());
                resultSet.setSeason(set.getSeason());
                resultSet.setDivision(set.getDivision());
                resultSet.setConfirmString(set.getConfirmString());
                resultSet.setTerminated(false);
                long comBegin = System.currentTimeMillis();
                long end = 0L;
                LinkedList<BattleResult> results = new LinkedList<BattleResult>();
                BattleSpec[] specs = set.getBattles();
                int i = 0;
                while (i < specs.length) {
                    long begin = System.currentTimeMillis();
                    BattleResult result = engine.runBattle(set.getRounds(), set.getFieldHeight(), set.getFieldWidth(), set.getCoolingRate(), set.getInactivityTime(), specs[i]);
                    end = System.currentTimeMillis();
                    result.setTotalTime((int)(end - begin));
                    results.add(result);
                    if (times != -1 && ++t >= times) {
                        logger.info((Object)("Complete " + times + " battles(specified limit)."));
                        logger.info((Object)"Server is sending executed battle result. And server will be terminated.");
                        resultSet.setTerminated(true);
                        resultSet.setResults(results.toArray(new BattleResult[results.size()]));
                        battles.setResults(this.hostname, this.password, resultSet);
                        return;
                    }
                    if (comBegin + 600000L < end) {
                        logger.info((Object)"Passed over 10 minites from last access.");
                        logger.info((Object)"Server is sending executed battle result.");
                        resultSet.setResults(results.toArray(new BattleResult[results.size()]));
                        battles.setResults(this.hostname, this.password, resultSet);
                        comBegin = System.currentTimeMillis();
                        results.clear();
                    }
                    ++i;
                }
                if (results.isEmpty()) continue;
                resultSet.setResults(results.toArray(new BattleResult[results.size()]));
                if (times == -1 || t < times) {
                    logger.info((Object)"Server is sending result and checking new battle.");
                    set = battles.setResultsAndGetNextBattle(this.hostname, this.password, resultSet);
                    continue;
                }
                logger.info((Object)"Server is sending result. And server will be terminated.");
                battles.setResults(this.hostname, this.password, resultSet);
                return;
            }
            logger.info((Object)"Battle doesn't exist. Server will sleep.");
            Thread.sleep(600000L);
            set = battles.getNewBattle(this.hostname, this.password);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

