package robocode;

/**
 * A prebuilt condition you can use that indicates your gun has finished rotating.
 * @see robocode.Condition
 */
public class GunTurnCompleteCondition extends Condition {
	private AdvancedRobot robot = null;
/**
 * Creates a new GunTurnCompleteCondition with default priority.
 */
public GunTurnCompleteCondition(AdvancedRobot r) {
	super();
	this.robot = r;
}
/**
 * Creates a new GunTurnCompleteCondition with the specified priority.
 */
public GunTurnCompleteCondition(AdvancedRobot r, int priority) {
	super();
	this.robot = r;
	this.priority = priority;
}
/**
 * Tests if the gun has stopped turning.
 */
public boolean test() {
	return (robot.getGunTurnRemaining() == 0);
}
}
