package robocode;

/**
 * A prebuilt condition you can use that indicates your robot has finished moving.
 * @see robocode.Condition
 */
public class MoveCompleteCondition extends Condition {
	private AdvancedRobot robot = null;
/**
 * Creates a new MoveCompleteCondition with default priority.
 */
public MoveCompleteCondition(AdvancedRobot r) {
	super();
	this.robot = r;
}
/**
 * Creates a new MoveCompleteCondition with the specified priority.
 */
public MoveCompleteCondition(AdvancedRobot r, int priority) {
	super();
	this.robot = r;
	this.priority = priority;
}
/**
 * Tests if the robot has stopped moving.
 */
public boolean test() {
	return (robot.getDistanceRemaining() == 0);
}
}
