package robocode;

/**
 * A prebuilt condition you can use that indicates your robot has finished rotating.
 * @see robocode.Condition
 */
public class TurnCompleteCondition extends Condition {
	private AdvancedRobot robot = null;
/**
 * Creates a new TurnCompleteCondition with default priority.
 */
public TurnCompleteCondition(AdvancedRobot r) {
	super();
	this.robot = r;
}
/**
 * Creates a new TurnCompleteCondition with the specified priority.
 */
public TurnCompleteCondition(AdvancedRobot r, int priority) {
	super();
	this.robot = r;
	this.priority = priority;
}
/**
 * Tests if the robot has finished turning.
 */
public boolean test() {
	return (robot.getTurnRemaining() == 0);
}
}
