#
# bitclust/parseutils.rb
#
# Copyright (c) 2006-2007 Minero Aoki
#
# This program is free software.
# You can distribute/modify this program under the Ruby License.
#

require 'bitclust/exception'

class String   # reopen
  attr_accessor :location
end

module BitClust

  # Provides line-wise access to a file with :file and :line.
  # Used by Preprocessor
  class LineStream
    def initialize(f)
      @f = f
    end

    def gets
      line = @f.gets
      return nil unless line
      if @f.respond_to?(:path)
        path = @f.path
      else
        path = nil
      end
      line.location = Location.new(path, @f.lineno)
      line
    end
  end

  # Encapsulates :file and :line.
  # Used by LineStream(above)
  class Location
    def initialize(file, line)
      @file = file
      @line = line
    end

    attr_reader :file
    attr_reader :line

    def to_s
      "#{@file}:#{@line}"
    end

    def inspect
      "\#<#{self.class} #{@file}:#{@line}>"
    end
  end

  # Utilities for parsing 
  module ParseUtils
    def parse_error(msg, line)
      raise ParseError, "#{line.location}: #{msg}: #{line.inspect}"
    end
  end

end
