;Samurai Graph installer script for Win32

!define SG_PRODUCT       "Samurai Graph"
!define SG_VER_MAJOR     "1"
!define SG_VER_MINOR     "0"
!define SG_VER_MICRO     "0"
!define SG_URL           "http://samurai-graph.sourceforge.jp/"
!define SG_PUBLISHER     "RIKEN BSI Neuroinformatics Laboratory"
!define SG_PUBLISHER_URL "http://www.ni.brain.riken.jp/"

!define SG_NAME    "${SG_PRODUCT} ${SG_VERSION}"
!define SG_VERSION "${SG_VER_MAJOR}.${SG_VER_MINOR}.${SG_VER_MICRO}"
!define SG_REGKEY  "Software\${SG_PRODUCT}"
!define SG_UNINST_REGKEY  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_NAME}"

!define SG_PROPERTY_EXT_REGKEY         ".sgp"
!define SG_PROPERTY_EXT_BACKUP_REGKEY  "backup_val"
!define SG_PROPERTY_REGKEY             "SamuraiGraphPropertyFile"
!define SG_PROPERTY_LABEL              "Samurai Graph Property File"
!define SG_PROPERTY_ICONFILE           "samurai-graph-property.ico"

!define SG_ARCHIVE_EXT_REGKEY          ".sga"
!define SG_ARCHIVE_EXT_BACKUP_REGKEY   "backup_val"
!define SG_ARCHIVE_REGKEY              "SamuraiGraphArchiveFile"
!define SG_ARCHIVE_LABEL               "Samurai Graph Archive File"
!define SG_ARCHIVE_ICONFILE            "samurai-graph-archive.ico"

;!define SG_SELECT_COMPONENTS  "YES"

!include "MUI.nsh"

;--------------------------------
;General

  ;Name and file
  Name "${SG_NAME}"
  OutFile "samurai-graph-win32-${SG_VERSION}.exe"

  ;Default installation folder
  InstallDir "$PROGRAMFILES\${SG_PRODUCT}"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKLM "${SG_REGKEY}" ""

  ;------------------------------
  ;Interface Configuration

  ; Installer and uninstaller icon file
  !define MUI_ICON   "resources\setup.ico"
  !define MUI_UNICON "resources\remove.ico"
  ; welcome page bitmap
  !define MUI_WELCOMEFINISHPAGE_BITMAP "resources\welcome.bmp"
  !define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP "resources\unwelcome.bmp"
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP_NOSTRETCH

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
!ifdef SG_SELECT_COMPONENTS
  !insertmacro MUI_PAGE_COMPONENTS
!endif
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING
  
;--------------------------------
;Languages
  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "Japanese"
  !include "languages\english.nsh"
  !include "languages\japanese.nsh"


;-------------------------
;Installer Sections

Function .onInit

   ; If it is failed to extract the installation directory from command lines,
   ; find the keyword "/D=", extract the installation directory, and set it
   ; to the variable $INSTDIR.

   Push $R0
   Push $R1
   Push $R2
   Push $R3  ; length of commad line

   StrCpy $R2 0
   StrLen $R3 $CMDLINE

   loop:
     StrCpy $R0 $CMDLINE 3 $R2
     StrCpy $R1 "/D="
     StrCmp $R0 $R1 get
     StrCmp $R2 $R3 end
     IntOp $R2 $R2 + 1
     Goto loop

   get:
     IntOp $R2 $R2 + 3
     IntOp $R1 $R3 - $R2
     IntOp $R1 $R1 - 1
     StrCpy $R0 $CMDLINE $R1 $R2
     StrCpy $INSTDIR $R0

   end:

   Pop $R3
   Pop $R2
   Pop $R1
   Pop $R0
FunctionEnd

Section "Samura Graph" SecCopyUI
  call CheckJava
  call CheckVersion

  WriteRegStr HKLM "${SG_REGKEY}" "" $INSTDIR
  WriteRegDWORD HKLM "${SG_REGKEY}" "VersionMajor"   "${SG_VER_MAJOR}"
  WriteRegDWORD HKLM "${SG_REGKEY}" "VersionMinor"   "${SG_VER_MINOR}"
  WriteRegDWORD HKLM "${SG_REGKEY}" "VersionMicro"   "${SG_VER_MICRO}"

  ;Install Files
  SetOutPath "$INSTDIR"
;  File ..\..\SamuraiGraph.exe
  File ..\..\dist\COPYING.txt
  File ..\..\dist\LICENSE.txt
  File resources\samurai-graph.ico
  File resources\${SG_PROPERTY_ICONFILE}
  File resources\${SG_ARCHIVE_ICONFILE}
  File ..\..\dist\samurai-graph.jar
;  File ..\..\dist\samurai-graph-client.jar

  SetOutPath "$INSTDIR\lib"
  File ..\..\helper\lib\upgrade-helper.jar

  SetOutPath "$INSTDIR\lib\vectorgraphics"
  File ..\..\dist\lib\vectorgraphics\freehep-base.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphics2d.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-cgm.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-emf.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-gif.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-java.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-pdf.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-ppm.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-ps.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-svg.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-swf.jar

  SetOutPath "$INSTDIR\doc\vectorgraphics"
  File ..\..\dist\doc\vectorgraphics\LGPL.txt
  File ..\..\dist\doc\vectorgraphics\LICENSE.txt
  File ..\..\dist\doc\vectorgraphics\SAMURAIGRAPH-ChangeLog.txt
  File ..\..\dist\doc\vectorgraphics\ReleaseNotes-1.2.2.html

  SetOutPath "$INSTDIR\examples"
  File ..\..\examples\data\ReadMe.txt
  File ..\..\examples\data\Example1.txt
  File ..\..\examples\data\Example2.txt
  File ..\..\examples\data\Example3.txt
  File ..\..\examples\data\Example4.txt
  File ..\..\examples\data\Example5.txt
  File ..\..\examples\data\Example6.txt
  File ..\..\examples\data\Example7.txt
  File ..\..\examples\data\Example8.txt
  File ..\..\examples\data\Example9.txt
  File ..\..\examples\data\Example10.txt
  File ..\..\examples\data\Example11.txt
  File ..\..\examples\data\Example12.txt
  File ..\..\examples\data\Example13.txt
  File ..\..\examples\data\Property1.sgp
  File ..\..\examples\data\Property2.sgp
  File ..\..\examples\data\Property3.sgp
  File ..\..\examples\data\Property4.sgp
  File ..\..\examples\data\Property5.sgp
  File ..\..\examples\data\Property6.sgp
  File ..\..\examples\data\Property7.sgp

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd

;--------------------------------
; Section for Create shortcut on Desktop

Section "Desktop Shortcut" DesktopIcon
  Push $R0
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
;  CreateShortCut  "$DESKTOP\${SG_NAME}.lnk" "$INSTDIR\SamuraiGraph.exe"
  CreateShortCut  "$DESKTOP\${SG_NAME}.lnk" "$R0" '-Xmx128M -jar "$INSTDIR\samurai-graph.jar"' "$INSTDIR\samurai-graph.ico" 0
  Pop $R0
SectionEnd

;--------------------------------
; Section for Create shortcut on Start Menu

Section "Start Menu Shortcuts" StartMenu
  Push $R0
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
  CreateDirectory "$SMPROGRAMS\${SG_NAME}"
;  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT}.lnk" "$INSTDIR\SamuraiGraph.exe"
  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT}.lnk" "$R0" '-Xmx128M -jar "$INSTDIR\samurai-graph.jar"' "$INSTDIR\samurai-graph.ico" 0
  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT} Examples Directory.lnk" "$INSTDIR\examples"
  WriteINIStr "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT} Site.url" "InternetShortcut" "URL" "${SG_URL}"
  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\Uninstall.lnk" "$INSTDIR\Uninstall.exe" "" "$INSTDIR\Uninstall.exe" 0
  Pop $R0
SectionEnd

;--------------------------------
; Section for Write Registry
Section -post
  Call RegistKeys
SectionEnd


!ifdef SG_SELECT_COMPONENTS
;--------------------------------
;Descriptions
  ;Assign language strings to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
  !insertmacro MUI_DESCRIPTION_TEXT ${DesktopIcon} $(DESC_DesktopIcon)
  !insertmacro MUI_DESCRIPTION_TEXT ${StartMenu} $(DESC_StartMenu)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END
!endif

;-------------------------
;Uninstaller Section

Section "Uninstall"
  ;If Samurai Graph windows exist, close them.
  Call un.CloseProgram

  ;Uninstall Files
;  Delete "$INSTDIR\SamuraiGraph.exe"
  Delete "$INSTDIR\COPYING.txt"
  Delete "$INSTDIR\LICENSE.txt"
  Delete "$INSTDIR\samurai-graph.ico"
  Delete "$INSTDIR\samurai-graph.jar"
;  Delete "$INSTDIR\samurai-graph-client.jar"

  Delete "$INSTDIR\lib\upgrade-helper.jar"

  Delete "$INSTDIR\lib\vectorgraphics\freehep-base.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphics2d.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-cgm.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-emf.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-gif.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-java.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-pdf.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-ppm.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-ps.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-svg.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-swf.jar"

  Delete "$INSTDIR\doc\vectorgraphics\LGPL.txt"
  Delete "$INSTDIR\doc\vectorgraphics\LICENSE.txt"
  Delete "$INSTDIR\doc\vectorgraphics\SAMURAIGRAPH-ChangeLog.txt"
  Delete "$INSTDIR\doc\vectorgraphics\ReleaseNotes-1.2.2.html"

  Delete "$INSTDIR\examples\ReadMe.txt"
  Delete "$INSTDIR\examples\Example1.txt"
  Delete "$INSTDIR\examples\Example2.txt"
  Delete "$INSTDIR\examples\Example3.txt"
  Delete "$INSTDIR\examples\Example4.txt"
  Delete "$INSTDIR\examples\Example5.txt"
  Delete "$INSTDIR\examples\Example6.txt"
  Delete "$INSTDIR\examples\Example7.txt"
  Delete "$INSTDIR\examples\Example8.txt"
  Delete "$INSTDIR\examples\Example9.txt"
  Delete "$INSTDIR\examples\Example10.txt"
  Delete "$INSTDIR\examples\Example11.txt"
  Delete "$INSTDIR\examples\Example12.txt"
  Delete "$INSTDIR\examples\Example13.txt"
  Delete "$INSTDIR\examples\Property1.sgp"
  Delete "$INSTDIR\examples\Property2.sgp"
  Delete "$INSTDIR\examples\Property3.sgp"
  Delete "$INSTDIR\examples\Property4.sgp"
  Delete "$INSTDIR\examples\Property5.sgp"
  Delete "$INSTDIR\examples\Property6.sgp"
  Delete "$INSTDIR\examples\Property7.sgp"

  Delete "$INSTDIR\Uninstall.exe"

  ; desktop
  Delete "$DESKTOP\${SG_PRODUCT} ${SG_VERSION}.lnk"

  ; start menu
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT}.lnk"
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT} Examples Directory.lnk"
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT} Site.url"
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\Uninstall.lnk"
  RMDir  "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}"

  RMDir "$INSTDIR\lib\vectorgraphics"
  RMDir "$INSTDIR\lib"
  RMDir "$INSTDIR\doc\vectorgraphics"
  RMDir "$INSTDIR\doc"
  RMDir "$INSTDIR\examples\data"
  RMDir "$INSTDIR\examples"
  RMDir /r "$INSTDIR"

  ; delete registry
  Call un.RegistKeys

SectionEnd

;; ----------------- function utilities ---------------------

!include "WinMessages.nsh"

Function CheckVersion
  ;Check an old version
  Push $R0
  Push $R1
  Push $R2
  Push $R3
  ReadRegStr $R0 HKLM "${SG_REGKEY}" ""
  StrCmp $R0 "" NoOldVer
  ReadRegDWORD $R1 HKLM "${SG_REGKEY}" "VersionMajor"
  ReadRegDWORD $R2 HKLM "${SG_REGKEY}" "VersionMinor"
  ReadRegDWORD $R3 HKLM "${SG_REGKEY}" "VersionMicro"
  IntCmp $R1 ${SG_VER_MAJOR} IsSameMajorVer MessageOldVer MessageNewVer
IsSameMajorVer:
  IntCmp $R2 ${SG_VER_MINOR} IsSameMinorVer MessageOldVer MessageNewVer
IsSameMinorVer:
  IntCmp $R3 ${SG_VER_MICRO} MessageSameVer MessageOldVer MessageNewVer
MessageOldVer:
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_TOPMOST $(DESC_OverwriteOldVer) IDYES DoUnInstPrevInst
  goto DoAbortInst
MessageNewVer:
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_TOPMOST $(DESC_OverwriteNewVer) IDYES DoUnInstPrevInst
  goto DoAbortInst
MessageSameVer:
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_TOPMOST $(DESC_OverwriteSameVer) IDYES DoUnInstPrevInst
DoAbortInst:
  DetailPrint "The installation was canceled.."
  Abort
DoUnInstPrevInst:
  ExecWait '"$R0\Uninstall.exe" /S'
  Sleep 500
NoOldVer:
  Pop $R3
  Pop $R2
  Pop $R1
  Pop $R0
FunctionEnd


;;
;; regist registry keys
;;
Function RegistKeys
  Push $R0
  ; Write to Registry Uninstall information
  WriteRegExpandStr HKLM "${SG_UNINST_REGKEY}" "UninstallString" '"$INSTDIR\Uninstall.exe"'
  WriteRegExpandStr HKLM "${SG_UNINST_REGKEY}" "InstallLocation" "$INSTDIR"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "DisplayName" "${SG_NAME}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "DisplayIcon" "$INSTDIR\samurai-graph.ico,0"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "DisplayVersion" "${SG_VERSION}"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "VersionMajor"   "${SG_VER_MAJOR}"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "VersionMinor"   "${SG_VER_MINOR}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "Publisher"      "${SG_PUBLISHER}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "URLInfoAbout"   "${SG_PUBLISHER_URL}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "HelpLink"       "${SG_URL}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "URLUpdateInfo"  "${SG_URL}"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "NoModify" "1"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "NoRepair" "1"

  ; Write to Registry Samurai Graph Property File Icon
  WriteRegStr HKCR "${SG_PROPERTY_REGKEY}" "" "${SG_PROPERTY_LABEL}"
  WriteRegStr HKCR "${SG_PROPERTY_REGKEY}\DefaultIcon" "" "$INSTDIR\${SG_PROPERTY_ICONFILE},0"
  ReadRegStr $R0 HKCR "${SG_PROPERTY_EXT_REGKEY}" ""
  StrCmp $R0 "" 0 DoWriteArc
  StrCmp $R0 "${SG_PROPERTY_LABEL}" 0 DoWriteProp
  WriteRegStr HKCR "${SG_PROPERTY_EXT_REGKEY}" "${SG_PROPERTY_EXT_BACKUP_REGKEY}" $R0
DoWriteProp:
  WriteRegStr HKCR "${SG_PROPERTY_EXT_REGKEY}" "" "${SG_PROPERTY_REGKEY}"

  ; Write to Registry Samurai Graph Property File Association 
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
;  WriteRegStr HKCR "${SG_PROPERTY_REGKEY}\shell\open\command" "" '"$INSTDIR\SamuraiGraph.exe" -prop "%1"'
  WriteRegStr HKCR "${SG_PROPERTY_REGKEY}\shell\open\command" "" '$R0 -Xmx128M -jar "$INSTDIR\samurai-graph.jar" -prop "%1"'


  ; Write to Registry Samurai Graph Archive File Icon
  WriteRegStr HKCR "${SG_ARCHIVE_REGKEY}" "" "${SG_ARCHIVE_LABEL}"
  WriteRegStr HKCR "${SG_ARCHIVE_REGKEY}\DefaultIcon" "" "$INSTDIR\${SG_ARCHIVE_ICONFILE},0"
  ReadRegStr $R0 HKCR "${SG_ARCHIVE_EXT_REGKEY}" ""
  StrCmp $R0 "" 0 DoWriteArc
  StrCmp $R0 "${SG_ARCHIVE_LABEL}" 0 DoWriteArc
  WriteRegStr HKCR "${SG_ARCHIVE_EXT_REGKEY}" "${SG_ARCHIVE_EXT_BACKUP_REGKEY}" $R0
DoWriteArc:
  WriteRegStr HKCR "${SG_ARCHIVE_EXT_REGKEY}" "" "${SG_ARCHIVE_REGKEY}"

  ; Write to Registry Samurai Graph Archive File Association 
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
;  WriteRegStr HKCR "${SG_ARCHIVE_REGKEY}\shell\open\command" "" '"$INSTDIR\SamuraiGraph.exe" -dataset "%1"'
  WriteRegStr HKCR "${SG_ARCHIVE_REGKEY}\shell\open\command" "" '$R0 -Xmx128M -jar "$INSTDIR\samurai-graph.jar" -dataset "%1"'

  Pop $R0
FunctionEnd

;;
;; close running samurai graph application.
;;
Function un.CloseProgram
  Push $R0
  loop:
    FindWindow $R0 "jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow"
    IntCmp $R0 0 done
    SendMessage $R0 ${WM_CLOSE} 0 0
    Sleep 300
    Goto loop
  done:
  Pop $R0
FunctionEnd

;;
;; delete registry keys
;;
Function un.RegistKeys
  Push $R0
  ; delete regkeys for uninstall information 
  DeleteRegValue HKLM "${SG_REGKEY}" "VersionMajor"
  DeleteRegValue HKLM "${SG_REGKEY}" "VersionMinor"
  DeleteRegValue HKLM "${SG_REGKEY}" "VersionMicro"
  DeleteRegKey /ifempty HKLM "${SG_REGKEY}"
  DeleteRegKey HKLM "${SG_UNINST_REGKEY}"

  ; delete regkeys for property file
  DeleteRegKey HKCR "${SG_PROPERTY_EXT_REGKEY}"
  ReadRegStr $R0 HKCR "${SG_PROPERTY_EXT_REGKEY}" ""
  StrCmp $R0 "${SG_PROPERTY_LABEL}" 0 NoOwnProp
  ReadRegStr $R0 HKCR "${SG_PROPERTY_EXT_REGKEY}" "${SG_PROPERTY_EXT_BACKUP_REGKEY}"
  StrCmp $R0 "" 0 RestoreBackupProp
  DeleteRegKey HKCR "${SG_PROPERTY_EXT_REGKEY}"
  Goto NoOwnProp
RestoreBackupProp:
  WriteRegStr HKCR "${SG_PROPERTY_EXT_REGKEY}" "" $R0
  DeleteRegValue HKCR "${SG_PROPERTY_EXT_REGKEY}" "${SG_PROPERTY_EXT_BACKUP_REGKEY}"
NoOwnProp:

  ; delete regkeys for archive file
  DeleteRegKey HKCR "${SG_ARCHIVE_EXT_REGKEY}"
  ReadRegStr $R0 HKCR "${SG_ARCHIVE_EXT_REGKEY}" ""
  StrCmp $R0 "${SG_ARCHIVE_LABEL}" 0 NoOwnArc
  ReadRegStr $R0 HKCR "${SG_ARCHIVE_EXT_REGKEY}" "${SG_ARCHIVE_EXT_BACKUP_REGKEY}"
  StrCmp $R0 "" 0 RestoreBackupArc
  DeleteRegKey HKCR "${SG_ARCHIVE_EXT_REGKEY}"
  Goto NoOwnArc
RestoreBackupArc:
  WriteRegStr HKCR "${SG_ARCHIVE_EXT_REGKEY}" "" $R0
  DeleteRegValue HKCR "${SG_ARCHIVE_EXT_REGKEY}" "${SG_ARCHIVE_EXT_BACKUP_REGKEY}"
NoOwnArc:

  Pop $R0
FunctionEnd


;;
;; Check Java installed
;;
Function CheckJava
  Push $R0
; Check JRE installed
  Call GetJRE
  Pop $R0
  StrCmp $R0 "" JreNotFound
  goto JreFound
JreNotFound:
  ExecShell "open" $(DESC_JavaUrl)
  MessageBox MB_OK|MB_ICONSTOP|MB_TOPMOST $(DESC_JreNotFound)
  DetailPrint "The installation was canceled.."
  Abort
JreFound:
  Pop $R0
FunctionEnd


;;
;;  Find JRE (javaw.exe)
;;
Function GetJRE
;  1 - in .\jre directory (JRE Installed with application)
;  2 - in JAVA_HOME environment variable
;  3 - in the Java Runtime Environment registry
;  4 - in JDK_HOME environment variable
;  5 - in the Java Development Kit registry
;  6 - hungup..

  Push $R0
  Push $R1

; JreCheck1:
  ClearErrors
  StrCpy $R0 "$EXEDIR\jre\bin\javaw.exe"
  IfFileExists $R0 JreFound

; JreCheck2:
  ClearErrors
  StrCpy $R0 ""
  ReadEnvStr $R0 "JAVA_HOME"
  IfErrors JreCheck3
  StrCpy $R0 "$R0\bin\javaw.exe"
  IfFileExists $R0 JreFound

 JreCheck3:
  ClearErrors
  ReadRegStr $R1 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment" "CurrentVersion"
  ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment\$R1" "JavaHome"
  IfErrors JreCheck4
  StrCpy $R0 "$R0\bin\javaw.exe"
  IfFileExists $R0 JreFound

 JreCheck4:
  ClearErrors
  StrCpy $R0 ""
  ReadEnvStr $R0 "JDK_HOME"
  IfErrors JreCheck5
  StrCpy $R0 "$R0\bin\javaw.exe"
  IfFileExists $R0 JreFound

 JreCheck5:
  ClearErrors
  ReadRegStr $R1 HKLM "SOFTWARE\JavaSoft\Java Development Kit" "CurrentVersion"
  ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Development Kit\$R1" "JavaHome"
  IfErrors JreCheck6
  StrCpy $R0 "$R0\jre\bin\javaw.exe"
  IfFileExists $R0 JreFound

 JreCheck6:
  StrCpy $R0 ""

 JreFound:
  Pop $R1
  Exch $R0
FunctionEnd
