
package jp.riken.brain.ni.samuraigraph.application;

import java.io.PrintWriter;
import java.net.Socket;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;


public class SGClient implements SGIApplicationCommandConstants
{

	public static void main(String[] args)
	{

		try
		{

			if( readCommandLine( args ) == false )
			{
				return;
			}


			Socket socket = new Socket( "localhost", SGDrawingServer.PORT_NUMBER );
			socket.setSoTimeout(10000);


			PrintWriter out = new PrintWriter( socket.getOutputStream() );


			for( int ii=0; ii<args.length; ii++ )
			{
				out.println(args[ii]);
			}

			out.close();

			socket.close();

		}
		catch( Exception e )
		{
			e.printStackTrace();
			System.exit(200);
		}

	}



	/**
	 * 
	 */
	private static boolean readCommandLine( String[] args )
	{

		// check
		if( args==null )
		{
			return false;
		}
		if( args.length==0 )
		{
			return false;
		}

		// the first argument is the command name
		String command = args[0];
		if( command==null )
		{
			return false;
		}
		if( command.equals( COM_DRAW_GRAPH ) )
		{
			if( !onAddData( args ) )
			{
				return false;
			}
		}
		else if( command.equals( COM_LOAD_PROPERTY ) )
		{
			if( !onReadProperty( args ) )
			{
				return false;
			}
		}

		return true;
	}



	/**
	 * 
	 */
	private static boolean onAddData( String[] args )
	{
		if( args.length < 2 )
		{
			return false;
		}
		if( args[1] == null )
		{
			return false;
		}

//System.out.println("before:"+args[1]);
		args[1] = SGUtility.getCanonicalPath( args[1] );
//System.out.println("after:"+args[1]);
//System.out.println();

		if( args[1] == null )
		{
			return false;
		}

		return true;
	}



	/**
	 * 
	 */
	private static boolean onReadProperty( String[] args )
	{

		if( args.length < 3 )
		{
			return false;
		}
		if( args[1] == null )
		{
			return false;
		}
		args[1] = SGUtility.getCanonicalPath( args[1] );
		if( args[1] == null )
		{
			return false;
		}


		if( args[2] == null )
		{
			return false;
		}
		args[2] = SGUtility.getCanonicalPath( args[2] );
		if( args[2] == null )
		{
			return false;
		}

		return true;
	}




}

