/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.Constant;
import com.sanpudo.formula.FormulaEvaluatorException;
import com.sanpudo.formula.FunctionImplementation;
import com.sanpudo.formula.Lex;
import com.sanpudo.formula.RoundPoint;
import com.sanpudo.formula.Rounding;
import com.sanpudo.formula.SystemFunctions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Hashtable;
import java.util.Vector;

class Environments
implements Cloneable {
    static Hashtable<String, String> predefine = new Hashtable();
    Hashtable<String, String> userDefine = new Hashtable();
    static SystemFunctions systemFunctions;
    Vector<FunctionImplementation> userFunctions = new Vector();
    Rounding rounding = new Rounding(RoundPoint.FINAL, 10, RoundingMode.HALF_UP);

    static {
        predefine.put("PI", new BigDecimal(Math.PI).toString());
        predefine.put("E", new BigDecimal(Math.E).toString());
        systemFunctions = new SystemFunctions();
    }

    protected Environments() {
    }

    public Environments clone() {
        Environments cloned = new Environments();
        cloned.userDefine = (Hashtable)this.userDefine.clone();
        cloned.userFunctions = (Vector)this.userFunctions.clone();
        this.rounding = new Rounding(this.rounding.roundPoint, this.rounding.scale, this.rounding.rMode);
        return cloned;
    }

    void setScale(int scale) {
        this.rounding = new Rounding(this.rounding.roundPoint, scale, this.rounding.rMode);
    }

    void setRounding(int scale, RoundingMode rMode) {
        this.rounding = new Rounding(this.rounding.roundPoint, scale, rMode);
    }

    void setRounding(RoundPoint roundPoint, int scale, RoundingMode rMode) throws FormulaEvaluatorException {
        if (rMode == RoundingMode.UNNECESSARY) {
            throw new FormulaEvaluatorException("Unnecassary is not alllowed as rouding", "UNNECESSARY", 0);
        }
        this.rounding = new Rounding(roundPoint, scale, rMode);
    }

    void defineUserConstant(String name, String value, boolean allowParam, boolean override) throws FormulaEvaluatorException {
        if (!Constant.isValidName(name, allowParam)) {
            throw new FormulaEvaluatorException("Invalid constant name", name, 0);
        }
        if (!override && predefine.containsKey(name)) {
            throw new FormulaEvaluatorException("Name conflicts to pre-defined constants", name, 0);
        }
        this.userDefine.put(name, value);
    }

    void defineUserConstant(String name, String value) throws FormulaEvaluatorException {
        this.defineUserConstant(name, value, false, false);
    }

    boolean isConstant(String name) {
        return predefine.containsKey(name) || this.userDefine.containsKey(name);
    }

    void defineUserFunction(FunctionImplementation func) throws FormulaEvaluatorException {
        String[] names = func.names();
        int i = 0;
        while (i < names.length) {
            if (!Lex.isValidFuncName(names[i])) {
                System.out.println(names[i]);
                throw new FormulaEvaluatorException("Invalid function name", names[i], 0);
            }
            if (systemFunctions.supports(names[i])) {
                throw new FormulaEvaluatorException("Name conflicts to pre-defined function", names[i], 0);
            }
            ++i;
        }
        this.userFunctions.add(0, func);
    }

    void loadUserFunction(String className) throws FormulaEvaluatorException {
        FunctionImplementation func = null;
        try {
            Class<?> c = ClassLoader.getSystemClassLoader().loadClass(className);
            Object o = c.newInstance();
            if (!(o instanceof FunctionImplementation)) {
                throw new FormulaEvaluatorException("Class incompatible to user function", className, 0);
            }
            func = (FunctionImplementation)o;
            this.defineUserFunction(func);
        }
        catch (Exception e) {
            throw new FormulaEvaluatorException("Class loading / creating instance failed", (Throwable)e, className, 0);
        }
    }

    boolean isFunction(String name) {
        return this.functions(name) != null;
    }

    FunctionImplementation functions(String name) {
        if (systemFunctions.supports(name)) {
            return systemFunctions;
        }
        for (FunctionImplementation fun : this.userFunctions) {
            if (!fun.supports(name)) continue;
            return fun;
        }
        return null;
    }
}

