/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.Constant;
import com.sanpudo.formula.Container;
import com.sanpudo.formula.Delimiter;
import com.sanpudo.formula.DirectValue;
import com.sanpudo.formula.FormulaEvaluatorException;
import com.sanpudo.formula.Function;
import com.sanpudo.formula.LPar;
import com.sanpudo.formula.Operator;
import com.sanpudo.formula.RPar;
import com.sanpudo.formula.Rounding;
import com.sanpudo.formula.Value;
import java.math.BigDecimal;

abstract class Token {
    Token parent;
    String formula;
    int location;

    Token(String formula, int location) {
        this.formula = formula;
        this.location = location;
        this.parent = null;
    }

    boolean isValue() {
        return this instanceof Value;
    }

    boolean isNonValue() {
        return this.isOperator() || this.isRPar() || this.isDelimiter();
    }

    boolean isDirectValue() {
        return this instanceof DirectValue;
    }

    boolean isConstant() {
        return this instanceof Constant;
    }

    boolean isLPar() {
        return this instanceof LPar;
    }

    boolean isRPar() {
        return this instanceof RPar;
    }

    boolean isOperator() {
        return this instanceof Operator;
    }

    boolean isFunction() {
        return this instanceof Function;
    }

    boolean isContainer() {
        return this instanceof Container;
    }

    boolean isDelimiter() {
        return this instanceof Delimiter;
    }

    Token root() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.root();
    }

    Container recentOpenContainer() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.isContainer() && ((Container)this.parent).isOpen()) {
            return (Container)this.parent;
        }
        return this.parent.recentOpenContainer();
    }

    Function recentOpenFunc() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.isFunction() && ((Function)this.parent).isOpen()) {
            return (Function)this.parent;
        }
        return this.parent.recentOpenFunc();
    }

    Token getF1(Operator op) {
        if (this.parent == null) {
            return this;
        }
        if (this.parent.isContainer() && ((Container)this.parent).isOpen()) {
            return this;
        }
        if (this.parent.isOperator() && op.stronger((Operator)this.parent)) {
            return this;
        }
        return this.parent.getF1(op);
    }

    abstract boolean isComplete();

    abstract String imcompleteMessage();

    abstract String strToken();

    abstract String normalized();

    abstract double value() throws FormulaEvaluatorException;

    abstract BigDecimal value(Rounding var1) throws FormulaEvaluatorException;
}

