package com.sanpudo.formula;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * BigDecimalの端数処理。
 * 
 * @author Sanpudo.
 */
class Rounding {

	/** 端数処理時点。 */
	RoundPoint roundPoint;

	/** 小数点以下桁数。 */
	int scale;

	/** 端数処理。 */
	RoundingMode rMode;

	/** コンストラクタ。 */
	Rounding(RoundPoint roundPoint, int scale, RoundingMode rMode) {
		this.roundPoint = roundPoint;
		this.scale = scale;
		this.rMode = rMode;
	}

	/** 評価ごとに端数処理するかどうか。 */
	boolean isEveryRounding() {
		return roundPoint == RoundPoint.EVERYTIME;
	}

	/** 途中端数処理。 */
	BigDecimal everyRound(BigDecimal bd) {
		if (isEveryRounding()) {
			return round(bd);
		} else {
			return bd;
		}
	}

	/** 端数処理の実行。 */
	BigDecimal round(BigDecimal bd) {
		return bd.setScale(this.scale, this.rMode);
	}

}
