#include "saphire.h"
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <libgen.h>
#include <dirent.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <oniguruma.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>

#include "config.h"
#include "saphire_extra.h"

#if defined(HAVE_CURSES_H)
#include <curses.h>
#elif defined(HAVE_NCURSES_H)
#include <ncurses.h>
#elif defined(HAVE_NCURSES_NCURSES_H)
#include <ncurses/ncurses.h>
#endif

#include <limits.h>

#if !defined(HAVE_ONIGUCHAR)
#define OnigUChar unsigned char
#endif

typedef struct {
    string_obj* mName;

    struct stat mStat;                // stat()のキャッシュ
} sFile;

sFile* sFile_new(char* name, struct stat* stat_)
{
    sFile* self = MALLOC(sizeof(sFile));

    self->mName = STRING_NEW(name);
    self->mStat = *stat_;

    return self;
}

static BOOL sort_name(void* left, void* right)
{
    sFile* l = (sFile*) left;
    sFile* r = (sFile*) right;

    char* lfname = string_c_str(l->mName);
    char* rfname = string_c_str(r->mName);

    if(strcmp(lfname, ".") == 0) return TRUE;
    if(strcmp(lfname, "..") == 0) {
        if(strcmp(rfname, ".") == 0) return FALSE;

        return TRUE;          
    }
    if(strcmp(rfname, ".") == 0) return FALSE;
    if(strcmp(rfname, "..") == 0) return FALSE;

    if(!S_ISDIR(l->mStat.st_mode) && !S_ISDIR(r->mStat.st_mode)
        || S_ISDIR(l->mStat.st_mode) && S_ISDIR(r->mStat.st_mode) )
    {
        return strcasecmp(lfname, rfname) < 0;
    }

    if(S_ISDIR(l->mStat.st_mode))
        return TRUE;
    else
        return FALSE;
}









//////////////////////////////////////////////////////////////////////
// static variable
//////////////////////////////////////////////////////////////////////
static vector_obj* files = NULL;

//////////////////////////////////////////////////////////////////////
// readline
//////////////////////////////////////////////////////////////////////
static BOOL name_sort(void* left, void* right)
{
    string_obj* l = (string_obj*)left;
    string_obj* r = (string_obj*) right;

    char* lfname = string_c_str(l);
    char* rfname = string_c_str(r);

    if(strcmp(lfname, ".") == 0) return TRUE;
    if(strcmp(lfname, "..") == 0) {
        if(strcmp(rfname, ".") == 0) return FALSE;

        return TRUE;          
    }
    if(strcmp(rfname, ".") == 0) return FALSE;
    if(strcmp(rfname, "..") == 0) return FALSE;

    return strcasecmp(lfname, rfname) < 0;
}


static string_obj* gEditingDir;
static BOOL read_one_argument(char* p, string_obj* buf)
{
    /// 単語の区切り記号かどうかのテーブル 127以下なら
    static unsigned char table[] = { 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 
        1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0 
    };

    BOOL squote = FALSE;
    BOOL dquote = FALSE;
    while(*p && (p - rl_line_buffer < rl_point)) {
        /// 空文字
        if(!squote && !dquote && *p == '"' && *(p+1) == '"') {
            p+=2;
            string_put(buf, "");
        }
        else if(!dquote && !squote && *p == '\'' && *(p+1) == '\'') {
            p+=2;
            string_put(buf, "");
        }
        else if(*p == '\\' && *(p+1) == 't') {
            string_push_back2(buf, '\t');

            p+=2;
        }
        else if(*p == '\\' && *(p+1) == 'n') {
            string_push_back2(buf, '\n');

            p+=2;
        }
        else if(*p == '\\' && *(p+1) == 'r') {
            string_push_back2(buf, '\r');

            p+=2;
        }
        else if(!squote && !dquote && *p == '\\') {
            p++;

            if(*p != 0) {
                string_push_back2(buf, *p);
                p++;
            }
            else {
                break;
            }
        }
        else if(!dquote && *p == '\'') {
            p++;
            squote = !squote;
        }
        else if(!squote && *p == '"') {
            dquote = !dquote;
            p++;
        }
        else if(squote || dquote) {
            if(*p == 0) {
                break;
            }
            else {
                string_push_back2(buf, *p);

                p++;
            }
        }
        else if(((unsigned char)*p) > 127) {
            string_push_back2(buf, *p);
            p++;
        }
        else if(table[*p]) {
            string_put(buf, "");
            p++;
        }
        else {
            string_push_back2(buf, *p);
            p++;
        }
    }
}

void parentname2(char* result, int result_size, char* path)
{
    char* p;

    if(*path == 0) {
        xstrncpy(result, "", result_size);
        return;
    }
    
    if(strcmp(path, "/") == 0) {
        xstrncpy(result, "/", result_size);
        return;
    }

    for(p=path + strlen(path)-1; p != path-1; p--) {
        if(*p == '/') {
            memcpy(result, path, p-path);
            result[p-path] = '/';
            result[p-path+1] = 0;
            
            return;
        }
    }

    xstrncpy(result, "", result_size);
}


#if defined(HAVE_MIGEMO_H)
#include <migemo.h>

migemo* gMigemo;
static regex_t* gReg;

void migemo_init()
{
    char buf[PATH_MAX];
    char migemodir[PATH_MAX];
    gMigemo = migemo_open(NULL);

    snprintf(migemodir, PATH_MAX, "%s", SYSTEM_MIGEMODIR);

    if(gKanjiCode == kUtf8) {
        snprintf(buf, PATH_MAX, "%s/utf-8/migemo-dict", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_MIGEMO, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/utf-8/roma2hira.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_ROMA2HIRA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/utf-8/hira2kata.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HIRA2KATA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/utf-8/han2zen.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HAN2ZEN, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
    }
    else if(gKanjiCode == kEucjp) {
        snprintf(buf, PATH_MAX, "%s/euc-jp/migemo-dict", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_MIGEMO, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/euc-jp/roma2hira.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_ROMA2HIRA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/euc-jp/hira2kata.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HIRA2KATA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/euc-jp/han2zen.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HAN2ZEN, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
    }
    else {
        snprintf(buf, PATH_MAX, "%s/cp932/migemo-dict", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_MIGEMO, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/cp932/roma2hira.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_ROMA2HIRA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/cp932/hira2kata.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HIRA2KATA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/cp932/han2zen.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HAN2ZEN, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
    }
}

void migemo_final()
{
    onig_end();
    migemo_close(gMigemo);
    if(gReg) onig_free(gReg);
    gReg = NULL;
}

/// 先頭から同じ文字列があるかどうか調べる。
/// 0 == 同じ文字は0文字
/// 1 == 同じ文字は1文字
/// 文字列はmbsとしてみる
int str_headsame(char* str1, char* str2)
{
    char* p1 = str1;
    char* p2 = str2;

    while(*p1 && *p2 && *p1 == *p2) {
        p1++;
        p2++;
    }

    return p1 - str1;
}


char* readline_file_completion_migemo_match(char* text, char* file)
{
    int same_point = str_headsame(text, file);

    OnigUChar * p;
    if(same_point == 0) {
        p = migemo_query(gMigemo, text);
    }
    /// text側がfileの部分なら判定するまでも無くマッチ ///
    else if(same_point == strlen(text)) {
        char tmp[PATH_MAX];
        xstrncpy(tmp, file, PATH_MAX);
        return strdup(tmp);
    }
    else {
        p = migemo_query(gMigemo, text+same_point);
    }


    if(p == NULL) {
        return NULL;
    }

    static regex_t* reg;

    int r;
    OnigErrorInfo err_info;

    char* p2 = MALLOC(strlen(p)*2);

    char* _p = p;
    char* _p2 = p2;

    while(*_p) {
        if(*_p == '+') {
            *_p2++ = '\\';
            *_p2++ = *_p++;
        }
        else {
            *_p2++ = *_p++;
        }
    }
    *_p2 = 0;

    if(gKanjiCode == kUtf8) {
        r = onig_new(&reg, p2, p2 + strlen((char*)p2), ONIG_OPTION_DEFAULT, ONIG_ENCODING_UTF8, ONIG_SYNTAX_DEFAULT,  &err_info);
    }
    else if(gKanjiCode == kEucjp) {
        r = onig_new(&reg, p2, p2 + strlen((char*)p2), ONIG_OPTION_DEFAULT, ONIG_ENCODING_EUC_JP, ONIG_SYNTAX_DEFAULT, &err_info);
    }
    else if(gKanjiCode == kSjis) {
        r = onig_new(&reg, p2, p2 + strlen((char*)p2), ONIG_OPTION_DEFAULT, ONIG_ENCODING_SJIS, ONIG_SYNTAX_DEFAULT, &err_info);
    }

    migemo_release(gMigemo, (unsigned char*) p);

    if(r != ONIG_NORMAL) {
        return NULL;
    }

    OnigRegion* region = onig_region_new();
    
    OnigUChar* file2;
    if(same_point == 0) {
        file2 = (OnigUChar*)file;
    }
    else {
        file2 = (OnigUChar*)file + same_point;
    }

    int r2 = onig_search(reg, file2, file2 + strlen((char*)file2), file2, file2 + strlen((char*)file2), region, ONIG_OPTION_NONE);

    onig_region_free(region, 1);

    onig_free(reg);

    if(r2 == 0) {
        char tmp[PATH_MAX];
        xstrncpy(tmp, file, PATH_MAX);
        return strdup(tmp);
    }

    return NULL;
}


char* readline_file_completion_migemo(const char* text, int rstat)
{
    /// クォートを除外 ///
    char* text2 = MALLOC(strlen(text) +1);
    char* _p = (char*)text;
    char* _p2 = text2;

    while(*_p) {
        if(*_p == '\\') {
            _p++;
        }
        else {
            *_p2++ = *_p++;
        }
    }
    *_p2 = 0;

    static int index, wordlen;

    /// 初期化 ///
    if(rstat == 0) {
        wordlen = strlen(text2);
        index = 0;

        // ディレクトリのパートを得る
        string_put(gEditingDir, "");
        read_one_argument(rl_line_buffer, gEditingDir);
        char* tmp = MALLOC(string_length(gEditingDir) + 1);
        parentname2(tmp, string_length(gEditingDir) + 1, string_c_str(gEditingDir));
        string_put(gEditingDir, tmp);

        /// チルダから始まっている場合 ///
        if(string_c_str(gEditingDir)[0] == '~') {
            char* p = string_c_str(gEditingDir);
            p++;
            string_obj* user = STRING_NEW("");
            while(*p && *p != '/') {
                string_push_back2(user, *p);
                p++;
            }

            /// ユーザー名からホームディレクトリに展開
            string_obj* gEditingDir2 = STRING_NEW("");

            if(string_length(user) == 0) {
                char* home = getenv("HOME");
                if(home) {
                    string_put(gEditingDir2, home);
                }
                else {
                    struct passwd* pw = getpwuid(getuid());
                    if(pw) {
                        string_put(gEditingDir2, pw->pw_dir);
                    }
                    else {
                        string_put(gEditingDir2, "~");
                    }
                }
            }
            else {
                struct passwd* pw = getpwnam(string_c_str(user));
                if(pw) {
                    string_put(gEditingDir2, pw->pw_dir);
                }
                else {
                    string_put(gEditingDir2, "~");
                    string_push_back(gEditingDir2, string_c_str(user));
                }
            }

            string_push_back(gEditingDir2, p);

            string_put(gEditingDir, string_c_str(gEditingDir2));
        }

        /// 補完候補を初期化 ///
        if(files == NULL) {
            files = VECTOR_NEW(50);
        }
        else {
            vector_clear(files);
        }

        /// 補完候補をディレクトリから読み込み ///
        if(strcmp(string_c_str(gEditingDir), "") != 0) {
            DIR* dir = opendir(string_c_str(gEditingDir));

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        xstrncpy(buf, string_c_str(gEditingDir), PATH_MAX);
                        xstrncat(buf, entry->d_name, PATH_MAX-1);
                        stat(buf, &_stat);

#if defined(__DARWIN__)
                        {
                        char* src = entry->d_name;
                        int des_size = strlen(src)*2;
                        char* des = MALLOC(des_size);
                        if(is_all_ascii(src)) {
                            xstrncpy(des, src, des_size);
                        }
                        else {
                            /// コンバート ///
                            if(kanji_convert(src, des, des_size, kUtf8Mac, kUtf8) < 0) {
                                xstrncpy(des, src, des_size);
                            }
                        }
                        xstrncpy(buf, des, PATH_MAX);
                        }
#else
                        xstrncpy(buf, entry->d_name, PATH_MAX);
#endif

                        if(S_ISDIR(_stat.st_mode)) {
                            xstrncat(buf, "/", PATH_MAX-1);
                        }

                        vector_add(files, STRING_NEW(buf));
                    }
                }

                closedir(dir);

                (void)vector_sort(files,name_sort);
            }
        }
        else {
            DIR* dir = opendir(".");

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        xstrncpy(buf, "./", PATH_MAX);
                        xstrncat(buf, entry->d_name, PATH_MAX-1);
                        stat(buf, &_stat);

#if defined(__DARWIN__)
                        {
                        char* src = entry->d_name;
                        int des_size = strlen(src)*2;
                        char* des = MALLOC(des_size);
                        if(is_all_ascii(src)) {
                            xstrncpy(des, src, des_size);
                        }
                        else {
                            /// コンバート ///
                            if(kanji_convert(src, des, des_size, kUtf8Mac, kUtf8) < 0) {
                                xstrncpy(des, src, des_size);
                            }
                        }
                        xstrncpy(buf, des, PATH_MAX);
                        }
#else
                        xstrncpy(buf, entry->d_name, PATH_MAX);
#endif
                        if(S_ISDIR(_stat.st_mode)) {
                            xstrncat(buf, "/", PATH_MAX-1);
                        }
                        vector_add(files, STRING_NEW(buf));
                    }
                }

                closedir(dir);

                (void)vector_sort(files, name_sort);
            }
        }
    }

    while(index < vector_size(files)) {
        char* file = string_c_str(vector_item(files, index));
        index++;

        /// ファイル名の入力がない補完は判定しなくても全てマッチ ///
        if(strcmp(text2, "") == 0) {
            char path[PATH_MAX];
            xstrncpy(path, file, PATH_MAX);

            char* ret = strdup(path);

            struct stat stat_;
            xstrncpy(path, string_c_str(gEditingDir), PATH_MAX);
            xstrncat(path, file, PATH_MAX);
            if(stat(path, &stat_) == 0) {
                if(S_ISDIR(stat_.st_mode)) {
                    rl_completion_append_character= 0;
                }
                else {
                    rl_completion_append_character= ' ';
                }
            }
            else {
                rl_completion_append_character= ' ';
            }

            return ret;
        }

        /// アスキー文字同士の補完 ///
        else if(is_all_ascii((char*)text2) && is_all_ascii(file)) {
            if(!strncmp(text2, file, wordlen)) {
                char path[PATH_MAX];
                xstrncpy(path, file, PATH_MAX);

                string_obj* tmp2 = STRING_NEW("");
                saphire_get_quoted_fname(path, tmp2);
                char* ret = strdup(string_c_str(tmp2));

                xstrncpy(path, string_c_str(gEditingDir), PATH_MAX);
                xstrncat(path, file, PATH_MAX);
                struct stat stat_;
                if(stat(path, &stat_) == 0) {
                    if(S_ISDIR(stat_.st_mode)) {
                        rl_completion_append_character= 0;
                    }
                    else {
                        rl_completion_append_character= ' ';
                    }
                }
                else {
                    rl_completion_append_character= ' ';
                }

                return ret; 
            }
        }
        /// migemo 補完 ///
        else {
            char* ret = readline_file_completion_migemo_match((char*)text2 , file);
            if(ret) {
                struct stat stat_;
                char path[PATH_MAX];
                xstrncpy(path, string_c_str(gEditingDir), PATH_MAX);
                xstrncat(path, file, PATH_MAX);
                if(stat(path, &stat_) == 0) {
                    if(S_ISDIR(stat_.st_mode)) {
                        rl_completion_append_character= 0;
                    }
                    else {
                        rl_completion_append_character= ' ';
                    }
                }
                else {
                    rl_completion_append_character= ' ';
                }

                string_obj* tmp = STRING_NEW("");
                saphire_get_quoted_fname(ret, tmp);
                free(ret);

                return strdup(string_c_str(tmp));
            }
        }
    }

    if(index == 0 && vector_size(files) == 0) {
        index ++;
        rl_completion_append_character= 0;
        return strdup("");
    }


    return NULL;
}
#endif

char* readline_program_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        wordlen = strlen(text);
        index = 0;
    }

    while(index < vector_size(gSaphireProgCompletions)) {
        char* program = string_c_str(vector_item(gSaphireProgCompletions, index));
        index++;

        if(!strncmp(text, program, wordlen)) {
            int l = strlen(program);
            if(l >= 2 && program[l-2] == '-' && program[l-1] == '>') {
                rl_completion_append_character= 0;
            }
            else {
                rl_completion_append_character= ' ';
            }
            return strdup(program);
        }
    }

    return NULL;
}

static vector_obj* gMethodCompletions;

char* readline_method_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        wordlen = strlen(text);
        index = 0;
    }

    while(index < vector_size(gMethodCompletions)) {
        char* method = string_c_str(vector_item(gMethodCompletions, index));
        index++;

        if(!strncmp(text, method, wordlen)) {
            return strdup(method);
        }
    }

    return NULL;
}

char* readline_file_completion(const char* text, int rstat)
{
    /// クォートを除外 ///
    char* text2 = MALLOC(strlen(text) +1);
    char* _p = (char*)text;
    char* _p2 = text2;

    while(*_p) {
        if(*_p == '\\') {
            _p++;
        }
        else {
            *_p2++ = *_p++;
        }
    }
    *_p2 = 0;

    static int index, wordlen;

    /// 初期化 ///
    if(rstat == 0) {
        wordlen = strlen(text2);
        index = 0;

        // ディレクトリのパートを得る
        string_put(gEditingDir, "");
        read_one_argument(rl_line_buffer, gEditingDir);
        char* tmp = MALLOC(string_length(gEditingDir) + 1);
        parentname2(tmp, string_length(gEditingDir) + 1, string_c_str(gEditingDir));
        string_put(gEditingDir, tmp);

        /// チルダから始まっている場合 ///
        if(string_c_str(gEditingDir)[0] == '~') {
            char* p = string_c_str(gEditingDir);
            p++;
            string_obj* user = STRING_NEW("");
            while(*p && *p != '/') {
                string_push_back2(user, *p);
                p++;
            }

            /// ユーザー名からホームディレクトリに展開
            string_obj* gEditingDir2 = STRING_NEW("");

            if(string_length(user) == 0) {
                char* home = getenv("HOME");
                if(home) {
                    string_put(gEditingDir2, home);
                }
                else {
                    struct passwd* pw = getpwuid(getuid());
                    if(pw) {
                        string_put(gEditingDir2, pw->pw_dir);
                    }
                    else {
                        string_put(gEditingDir2, "~");
                    }
                }
            }
            else {
                struct passwd* pw = getpwnam(string_c_str(user));
                if(pw) {
                    string_put(gEditingDir2, pw->pw_dir);
                }
                else {
                    string_put(gEditingDir2, "~");
                    string_push_back(gEditingDir2, string_c_str(user));
                }
            }

            string_push_back(gEditingDir2, p);

            string_put(gEditingDir, string_c_str(gEditingDir2));
        }

        /// 補完候補を初期化 ///
        if(files == NULL) {
            files = VECTOR_NEW(50);
        }
        else {
            vector_clear(files);
        }

        /// 補完候補をディレクトリから読み込み ///
        if(strcmp(string_c_str(gEditingDir), "") != 0) {
            DIR* dir = opendir(string_c_str(gEditingDir));

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        xstrncpy(buf, string_c_str(gEditingDir), PATH_MAX);
                        xstrncat(buf, entry->d_name, PATH_MAX);
                        stat(buf, &_stat);

#if defined(__DARWIN__)
                        {
                        char* src = entry->d_name;
                        int des_size = strlen(src)*2;
                        char* des = MALLOC(des_size);
                        if(is_all_ascii(src)) {
                            xstrncpy(des, src, des_size);
                        }
                        else {
                            /// コンバート ///
                            if(kanji_convert(src, des, des_size, kUtf8Mac, kUtf8) < 0) {
                                xstrncpy(des, src, des_size);
                            }
                        }
                        xstrncpy(buf, des, PATH_MAX);
                        }
#else
                        xstrncpy(buf, entry->d_name, PATH_MAX);
#endif
                        if(S_ISDIR(_stat.st_mode)) {
                            xstrncat(buf, "/", PATH_MAX);
                        }

                        vector_add(files, STRING_NEW(buf));
                    }
                }

                closedir(dir);

                (void)vector_sort(files,name_sort);
            }
        }
        else {
            DIR* dir = opendir(".");

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        xstrncpy(buf, "./", PATH_MAX);
                        xstrncat(buf, entry->d_name, PATH_MAX);
                        stat(buf, &_stat);

#if defined(__DARWIN__)
                        {
                        char* src = entry->d_name;
                        int des_size = strlen(src)*2;
                        char* des = MALLOC(des_size);
                        if(is_all_ascii(src)) {
                            xstrncpy(des, src, des_size);
                        }
                        else {
                            /// コンバート ///
                            if(kanji_convert(src, des, des_size, kUtf8Mac, kUtf8) < 0) {
                                xstrncpy(des, src, des_size);
                            }
                        }
                        xstrncpy(buf, des, PATH_MAX);
                        }
#else
                        xstrncpy(buf, entry->d_name, PATH_MAX);
#endif
                        if(S_ISDIR(_stat.st_mode)) {
                            xstrncat(buf, "/", PATH_MAX);
                        }
                        vector_add(files, STRING_NEW(buf));
                    }
                }

                closedir(dir);

                (void)vector_sort(files, name_sort);
            }
        }
    }

    while(index < vector_size(files)) {
        char* file = string_c_str(vector_item(files, index));
        index++;

        /// ファイル名の入力がない補完は判定しなくても全てマッチ ///
        if(strcmp(text2, "") == 0) {
            char path[PATH_MAX];
            xstrncpy(path, file, PATH_MAX);

            char* ret = strdup(path);

            struct stat stat_;
            xstrncpy(path, string_c_str(gEditingDir),  PATH_MAX);
            xstrncat(path, file, PATH_MAX);
            if(stat(path, &stat_) == 0) {
                if(S_ISDIR(stat_.st_mode)) {
                    rl_completion_append_character= 0;
                }
                else {
                    rl_completion_append_character= ' ';
                }
            }
            else {
                rl_completion_append_character= ' ';
            }

            return ret;
        }

        /// アスキー文字同士の補完 ///
//        else if(is_all_ascii((char*)text2) && is_all_ascii(file)) {
        else {
            if(!strncmp(text2, file, wordlen)) {
                char path[PATH_MAX];
                xstrncpy(path, file, PATH_MAX);

                string_obj* tmp2 = STRING_NEW("");
                saphire_get_quoted_fname(path, tmp2);
                char* ret = strdup(string_c_str(tmp2));

                xstrncpy(path, string_c_str(gEditingDir), PATH_MAX);
                xstrncat(path, file, PATH_MAX);
                struct stat stat_;
                if(stat(path, &stat_) == 0) {
                    if(S_ISDIR(stat_.st_mode)) {
                        rl_completion_append_character= 0;
                    }
                    else {
                        rl_completion_append_character= ' ';
                    }
                }
                else {
                    rl_completion_append_character= ' ';
                }

                return ret; 
            }
        }
    }

    if(index == 0 && vector_size(files) == 0) {
        index ++;
        rl_completion_append_character= 0;
        return strdup("");
    }

    return NULL;
}

char** readline_on_complete(const char* text, int start, int end)
{
    BOOL program = TRUE;
    BOOL user = FALSE;
    BOOL method = FALSE;

    string_obj* buf = STRING_NEW("");

    char* p = rl_line_buffer;

    while(*p == ' ' || *p == '\t' || *p == '\n') {
        p++;
    }

    BOOL squote = FALSE;
    BOOL dquote = FALSE;
    while(p < rl_line_buffer + end) {
        // クォート
        if(*p == '\\' && *(p+1) == 't') {
            p+=2;
            user = FALSE;

            string_put(buf, "");
        }
        else if(*p == '\\' && *(p+1) == 'n') {
            p+=2;
            user = FALSE;

            string_put(buf, "");
        }
        else if(*p == '\\' && *(p+1) == 'r') {
            p+=2;
            user = FALSE;

            string_put(buf, "");
        }
        else if(*p == '\\') {
            p+=2;
            user = FALSE;

            string_put(buf, "");
        }

        // シングルクォート
        else if(!dquote && *p == '\'') {
            p++;
            squote = !squote;
            user = FALSE;

            string_put(buf, "");
        }
        // ダブルクォート
        else if(!squote && *p == '"') {
            p++;
            dquote = !dquote;
            user = FALSE;

            string_put(buf, "");
        }
        // 環境変数 $$()
        else if(!squote && *p == '$' && *(p+1) == '$' && *(p+2) == '(') {
            p+=3;

            program = TRUE;

            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }
        // 環境変数 $()
        else if(!squote && *p == '$' && *(p+1) == '(') {
            p+=2;

            program = TRUE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }
        else if(!dquote && !squote && *p == ')') {
            p++;
            program = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }

        // 環境変数 $$
        else if(!squote && *p == '$' && *(p+1) == '$') {
            p+=2;
            user = FALSE;

            string_put(buf, "");
        }
        // 環境変数 $
        else if(!squote && *p == '$') {
            p++;
            user = FALSE;

            string_put(buf, "");
        }

        // 環境変数 @
        else if(!squote && *p == '@' && *(p+1) == '@') {
            p+=2;
            user = FALSE;

            string_put(buf, "");
        }
        // 環境変数 @@
        else if(!squote && *p == '@') {
            p++;
            user = FALSE;

            string_put(buf, "");
        }
        /// シングルクォート、ダブルクォート中 ///
        else if(squote || dquote) {
            p++;

            string_put(buf, "");
        }
        else if(*p == '~') {
            p++;
            user = TRUE;

            string_put(buf, "");
        }
        /// グロブ ///
        else if(*p == '*' || *p == '?' || *p =='[' && (*(p+1) != ' ' && *(p+1) != '\t' && *(p+1) == '\n')) 
        {
            p++;
            user = FALSE;

            string_put(buf, "");
        }
        else if(*p == '-' && *(p+1) == '>') {
            p+=2;
            if(program) { 
                sObject* object = saphire_get_object(string_c_str(buf));

                if(object) {
                    gMethodCompletions = saphire_methods_names(object);
                    method = TRUE; 
                    program = FALSE;  
                }
                string_put(buf, "");
            }

            user = FALSE;
        }
        else if(*p == '<' && program) {
            p++;

            program = FALSE;
            user = FALSE;

            string_put(buf, "");
        }
        /// 単語の区切り /////////////////////////////////////////////////
    
        /// 空白 ///
        else if(*p == ' ' || *p == '\t') {
            while(*p == ' ' || *p == '\t') {
                p++;
            }

            program = FALSE;
            method = FALSE;
            user = FALSE;

            string_put(buf, "");
        }
        /// ブロック
        else if(*p == '{') {
            p++;
            program = TRUE;
            method = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }
        
        /// コマンドの区切り ///////////////////////////////////////////
        
        /// パイプ ///
        else if(*p == '|' && *(p+1) == '~') {
            p+=2;

            program = TRUE;
            method = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }
        
        /// パイプ ///
        else if(*p == '|' && *(p+1) != '|') {
            p++;

            program = TRUE;
            method = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }
        
        /// 文(statment)の区切り系 ///////////////////////////////////
    
        /// アンドアンド ///
        else if(*p == '&' && *(p+1) == '&') {
            p+=2;

            program = TRUE;
            method = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }
        /// オアオア ///
        else if(*p == '|' && *(p+1) == '|') {
            p+=2;

            program = TRUE;
            method = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }
        /// バックグラウンド ///
        else if(*p == '&' && *(p+1) != '&') {
            p++;

            program = TRUE;
            method = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }
        /// セミコロン ///
        else if(*p == ';') {
            p++;

            program = TRUE;
            method = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }
        /// 改行 ///
        else if(*p == '\n') {
            p++;

            program = TRUE;
            method = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;

            string_put(buf, "");
        }
        /// コメント ///
        else if(*p == '#') {
            p++;

            while(*p) {
                if(*p == '\n') {
                    p++;
                    program = TRUE;
                    break;
                }
                else {
                    p++;
                }
            }
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            user = FALSE;
            method = FALSE;

            string_put(buf, "");
        }
        else if(*p == '/') {
            user = FALSE;
            program = FALSE;
            method = FALSE;
            p++;

            string_put(buf, "");
        }
        /// 終了 ///
        else if(*p == 0) {
            break;
        }
        
        /// 構文 ////////////////////////////////////////////////////////

        /// サブシェル ///
        else if(*p == '(') {
            p++;
            program = TRUE;
            method = FALSE;
            user = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }

            string_put(buf, "");
        }
        else {
            string_push_back2(buf, *p);
            p++;
        }
    }

    if(user) {
        rl_completion_append_character= 0;
        return rl_completion_matches(text, rl_username_completion_function);
    }
    else if(program) {
        rl_completion_append_character= ' ';
        return rl_completion_matches(text, readline_program_completion);
    }
    else if(method) {
        rl_completion_append_character= ' ';
        return rl_completion_matches(text, readline_method_completion);
    }
#if defined(HAVE_MIGEMO_H)
    else {
        return rl_completion_matches(text, readline_file_completion_migemo);
    }
#else
    else {
        return rl_completion_matches(text, readline_file_completion);
    }
#endif

    return NULL;
}
// pathの最後は/をつける
static BOOL readline_select_file_read(vector_obj* v, char* path)
{
    DIR* dir = opendir(path);
    if(dir == NULL) {
        return FALSE;
    }
    
    struct dirent* entry;
    while(entry = readdir(dir)) {
        char fpath[PATH_MAX];
        xstrncpy(fpath, path, PATH_MAX);
        xstrncat(fpath, entry->d_name, PATH_MAX);

        struct stat stat_;
        memset(&stat_, 0, sizeof(struct stat));
        if(stat(fpath, &stat_) < 0) {
            continue;
        }

        sFile* file = sFile_new(entry->d_name, &stat_);

        vector_add(v, file);
    }
    
    closedir(dir);

    /// ソート ///
    vector_sort(v, sort_name);

    return TRUE;
}

static void str_cut2(enum eKanjiCode code, char* mbs, int termsize, char* dest_mbs, int dest_byte)
{
    if(code == kUtf8) {
        int i;
        int n;

        wchar_t* wcs 
            = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*MB_CUR_MAX);
        wchar_t* tmp 
            = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*MB_CUR_MAX);

        if(mbstowcs(wcs, mbs, (termsize+1)*MB_CUR_MAX) == -1) {
            mbstowcs(wcs, "?????", (termsize+1)*MB_CUR_MAX);
        }

        i = 0;
        while(1) {
            if(i < wcslen(wcs)) {
                tmp[i] = wcs[i];
                tmp[i+1] = 0;
            }
            else {
                tmp[i] = ' ';
                tmp[i+1] = 0;
            }

            n = wcswidth(tmp, wcslen(tmp));
            if(n < 0) {
                xstrncpy(dest_mbs, "?????", dest_byte);

                return;
            }
            else {
                if(n > termsize) {
                    tmp[i] = 0;

                    if(wcswidth(tmp, wcslen(tmp)) != termsize) {
                        tmp[i] = ' ';
                        tmp[i+1] = 0;
                    }
                    break;
                }
            }

            i++;
        }

        wcstombs(dest_mbs, tmp, dest_byte);
    }
    else {
        int n;
        BOOL tmpend = FALSE;
        BOOL kanji = FALSE;
        for(n=0; n<termsize && n<dest_byte-1; n++) {
            if(kanji)
                kanji = FALSE;
            else if(!tmpend && is_kanji(code, mbs[n])) {
                kanji = TRUE;
            }

            if(!tmpend && mbs[n] == 0) tmpend = TRUE;
                        
            if(tmpend)
                dest_mbs[n] = ' ';
            else
                dest_mbs[n] = mbs[n];
        }
        
        if(kanji) dest_mbs[n-1] = ' ';
        dest_mbs[n] = 0;
    }
}


static int readline_select_file(int count, int key)
{
    msave_ttysettings();       // 端末の設定の保存
    msave_screen();
    minitscr();

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    vector_obj* v = VECTOR_NEW(10);
    char cwd_path[PATH_MAX];
    mygetcwd(cwd_path, PATH_MAX);
    xstrncat(cwd_path, "/", PATH_MAX);

    char current_dir[PATH_MAX];
    xstrncpy(current_dir, cwd_path, PATH_MAX);
    readline_select_file_read(v, current_dir);

    vector_obj* mark_files = VECTOR_NEW(10);

    if(vector_size(v) > 0) {
        int cursor = 0;
        while(1) {
            /// 描写 ///
            mclear();
            mmvprintw(0,0,"%s", current_dir);

            int page = cursor/((maxy-1)*4);
            int n = page*4*(maxy-1);
            while(n < page*4*(maxy-1)+(maxy-1)*4 && n < vector_size(v)) {
                sFile* file = vector_item(v, n);

                int attrs = 0;
                if(n == cursor) {
                    attrs |= kCAReverse;
                }
                if(S_ISDIR(file->mStat.st_mode)) {
                    attrs |= kCACyan;
                    attrs |= kCABold;
                }
                if(attrs) mattron(attrs);

                char file2[PATH_MAX];
                str_cut2(kUtf8, string_c_str(file->mName)
                        , maxx/4-2, file2, PATH_MAX);

                int y = (n-page*4*(maxy-1)) / 4 + 1;
                int x = ((n-page*4*(maxy-1)) % 4)*maxx/4;

                char full_path[PATH_MAX];
                xstrncpy(full_path, current_dir, PATH_MAX);
                xstrncat(full_path, string_c_str(file->mName), PATH_MAX);

                BOOL marked = FALSE;
                int i;
                for(i=0; i<vector_size(mark_files); i++) {
                    string_obj* mark_file = vector_item(mark_files, i);

                    if(strcmp(string_c_str(mark_file), full_path) == 0) {
                        marked = TRUE;
                        break;
                    }
                }

                if(marked) 
                    mmvprintw(y, x, "*%s", file2);
                else
                    mmvprintw(y, x, " %s", file2);

                if(attrs) {
                    mattroff();
                }

                n++;
            }
            mrefresh();

            /// インプット ///
            int meta;
            int key = mgetch(&meta);

            if(key == 14 || key == KEY_DOWN) {
                cursor+=4;
            }
            else if(key == 16 || key == KEY_UP) {
                cursor-=4;
            }
            else if(key == 6 || key == KEY_RIGHT) {
                cursor++;
            }
            else if(key == 2 || key == KEY_LEFT) {
                cursor--;
            }
            else if(key == 4 || key == KEY_NPAGE) {
                cursor += (maxy-1)*4;
            }
            else if(key == 21 || key == KEY_PPAGE) {
                cursor -= (maxy-1)*4;
            }
            else if(key == 12) {
                mclear();
                mrefresh();
            }
            else if(key == ' ') {
                sFile* cursor_file = vector_item(v, cursor);

                string_obj* cursor_mfile = NULL;

                char cursor_path[PATH_MAX];
                xstrncpy(cursor_path, current_dir, PATH_MAX);
                xstrncat(cursor_path, string_c_str(cursor_file->mName), PATH_MAX);

                int i;
                for(i=0; i<vector_size(mark_files); i++) {
                    string_obj* mfile = vector_item(mark_files, i);

                    if(strcmp(string_c_str(mfile), cursor_path) == 0) {
                        cursor_mfile = mfile;
                        break;
                    }
                }

                if(!cursor_mfile) {
                    vector_add(mark_files, STRING_NEW(cursor_path));
                }
                else {
                    vector_erase(mark_files
                        , vector_index(mark_files, cursor_mfile));
                }

                cursor++;
            }
            else if(key == '\\') {
                xstrncpy(current_dir, "/", PATH_MAX);

                vector_clear(v);

                readline_select_file_read(v, current_dir);
                cursor = 0;
            }
            else if(key == '\t' || key == 'w') {
                if(vector_size(mark_files) == 0) {
                    sFile* cursor_file = vector_item(v, cursor);

                    /// 現在のカレントディレクトリのパスなら
                    /// ディレクトリ名を取る
                    char cursor_path[PATH_MAX];
                    xstrncpy(cursor_path, current_dir, PATH_MAX);
                    xstrncat(cursor_path, string_c_str(cursor_file->mName), PATH_MAX);

                    /// カレントのファイル、子ディレクトリのファイルなら
                    /// 相対ディレクトリ
                    if(memcmp(cursor_path
                            , cwd_path, strlen(cwd_path)) == 0 )
                    {
                        char cursor_path2[PATH_MAX];
                        memcpy(cursor_path2
                            , cursor_path+strlen(cwd_path)
                            , strlen(cursor_path) - strlen(cwd_path)+1);

                        rl_insert_text(cursor_path2);
                    }
                    else {
                        rl_insert_text(cursor_path);
                    }
                }
                else {
                    int j;
                    for(j=0; j<vector_size(mark_files); j++) {
                        char full_path[PATH_MAX];
                        xstrncpy(full_path
                            , string_c_str(vector_item(mark_files, j))
                            , PATH_MAX);

                        if(strstr(full_path, cwd_path) == full_path) {
                            char full_path2[PATH_MAX];
                            memcpy(full_path2
                                , full_path + strlen(cwd_path) 
                                , strlen(full_path) - strlen(cwd_path));
                            full_path2[strlen(full_path) - strlen(cwd_path)] = 0;

                            rl_insert_text(full_path2);

                            if(j<vector_size(mark_files)-1) 
                                rl_insert_text(" ");
                        }
                        else {
                            rl_insert_text(full_path);

                            if(j<vector_size(mark_files)-1) 
                                rl_insert_text(" ");
                        }
                    }
                }
                break;
            }
            else if(key == 'q' || key == 3 | key == 27 || key == 7) {
                break;
            }
            else if(key == 10 || key == 13) {
                sFile* cursor_file = vector_item(v, cursor);

                if(strcmp(string_c_str(cursor_file->mName), ".") != 0
                    && S_ISDIR(cursor_file->mStat.st_mode)) 
                {
                    char path2[PATH_MAX];
                    if(correct_path(current_dir
                            , string_c_str(cursor_file->mName), path2, PATH_MAX)) 
                    {
                        xstrncpy(current_dir, path2, PATH_MAX);
                        if(current_dir[strlen(current_dir)-1] != '/') {
                            xstrncat(current_dir, "/", PATH_MAX);
                        }

                        vector_clear(v);

                        readline_select_file_read(v, current_dir);
                        cursor = 0;
                    }
                }
            }
            else if(key == 8 || key == KEY_BACKSPACE) {    // CTRL-H
                char parent_path[PATH_MAX];
                parentname(parent_path, PATH_MAX, current_dir);
                xstrncpy(current_dir, parent_path, PATH_MAX);

                vector_clear(v);

                readline_select_file_read(v, current_dir);
                cursor = 0;
            }

            /// 修正 ///
            if(cursor < 0) {
                cursor = 0;
            }
            if(cursor >= vector_size(v)) {
                cursor = vector_size(v)-1;
            }
        }
    }

//mclear();
//mrefresh();
    mendwin();
    mrestore_screen();
    mrestore_ttysettings();    // 端末の設定の復帰

    return 0;
}

static int skip_quoted(const char *s, int i, char q)
{
   while(s[i] && s[i]!=q)
   {
      if(s[i]=='\\' && s[i+1])
	 i++;
      i++;
   }
   if(s[i])
      i++;
   return i;
}

int lftp_char_is_quoted(const char *string,int eindex)
{
  int i, pass_next;

  for (i = pass_next = 0; i <= eindex; i++)
    {
      if (pass_next)
        {
          pass_next = 0;
          if (i >= eindex)
            return 1;
          continue;
        }
      else if (string[i] == '"' || string[i] == '\'')
        {
	  char quote = string[i];
          i = skip_quoted (string, ++i, quote);
          if (i > eindex)
            return 1;
          i--;  /* the skip functions increment past the closing quote. */
        }
      else if (string[i] == '\\')
        {
          pass_next = 1;
          continue;
        }
    }
  return (0);
}

void readline_init()
{
    rl_attempted_completion_function = readline_on_complete;
    rl_completer_quote_characters = "\"'";
    rl_completer_word_break_characters = " \t\n\"'|{}!&;()<>=%/";
    rl_filename_quote_characters = " \\\t\n\"|$*?[]<>{}&;#()'%~";
    rl_completion_append_character= ' ';
    rl_char_is_quoted_p = (rl_linebuf_func_t*)lftp_char_is_quoted;

#if defined(HAVE_MIGEMO_H)
    migemo_init();
#endif

    gEditingDir = STRING_NEW("");
    gMethodCompletions = NULL;

    rl_bind_key('x'-'a'+1, readline_select_file);
}

void readline_final()
{
#if defined(HAVE_MIGEMO_H)
    migemo_final();
#endif
}
