@echo off
setlocal

set DOCUMENT=document
set DISTNAME=reference-ja

set SCRIPTDIR=%~p0
cd %SCRIPTDIR%\..
set DOCDIR=%cd%
cd %DOCDIR%\..\..
set BASEDIR=%cd%
cd %DOCDIR%

set TOOLSDIR=%BASEDIR%\tools
set LINT=%TOOLSDIR%\docbook-lint.bat
set TEXBASE=tex-math-equations
set TEXFILE=%TEXBASE%.tex
set DVIFILE=%TEXBASE%.dvi
set LOGFILE=%TEXBASE%.log
set AUXFILE=%TEXBASE%.log
set DOCUMENTXML=%DOCUMENT%.xml
set DOCUMENTPDF=%DISTNAME%.pdf
set HTMLDIR=%DOCDIR%\%DISTNAME%

set SGML_CATALOG_FILES=%BASEDIR%\docbook\xml\4.4\catalog.xml

set PATH=%TOOLSDIR%\win32;%PATH%

if exist %DOCUMENTXML% goto lintcheck
  echo Error: %DOCUMENTXML% not found.
  pause
  exit /b 1

:lintcheck
rem goto createdir
call %LINT% %DOCUMENTXML%
if %errorlevel%==0 goto deldir
  echo Error: some error occured in docbook lint check.
  pause
  exit /b 1

:deldir
if exist %HTMLDIR% rmdir /s /q %HTMLDIR%

:createdir
mkdir %HTMLDIR%
mkdir %HTMLDIR%\images
copy /y xsl\xhtml\etc\*.css %HTMLDIR%
copy /y xsl\xhtml\etc\*.gif %HTMLDIR%\images

for %%i in (bps builtin constant control dcm declaration gpm ispp math ncs npe operator statistics system utility) do mkdir %HTMLDIR%\%%i
for %%i in (bps builtin constant control dcm declaration gpm ispp math ncs npe operator statistics system utility) do if exist %%i\images copy %%i\images\*.gif %HTMLDIR%\%%i

:runxsltproc
xsltproc.exe --xinclude --catalogs -o %HTMLDIR%/index.html xsl/xhtml/xhtml.xsl %DOCUMENTXML%

if not exist %HTMLDIR%\%TEXFILE% goto endbatchfile
cd %HTMLDIR%
latex %TEXFILE%
if not exist %DVIFILE% goto deltexfile
dvi2bitmap.exe --font-mode=lasf --output-type=gif --magnification=4 --scale=5 --process=transparent,blur --resolution=144 %DVIFILE%
del /f %DVIFILE% %LOGFILE% %AUXFILE%

:deltexfile
del /f %TEXFILE%

:endbatchfile

endlocal
