@echo off
setlocal

rem XSL Formmatter

set DOCUMENT=document
set DISTNAME=reference-ja

set SCRIPTDIR=%~p0
cd %SCRIPTDIR%\..
set DOCDIR=%cd%
cd %DOCDIR%\..\..
set BASEDIR=%cd%
cd %DOCDIR%

set TOOLSDIR=%BASEDIR%\tools
set LINT=%TOOLSDIR%\docbook-lint.bat
set TEXBASE=tex-math-equations
set TEXFILE=%TEXBASE%.tex
set DVIFILE=%TEXBASE%.dvi
set LOGFILE=%TEXBASE%.log
set DOCUMENTXML=%DOCUMENT%.xml
set DOCUMENTPDF=%DISTNAME%.pdf
set HTMLDIR=%DOCDIR%\%DISTNAME%
set PDFDIR=%DOCDIR%\pdf-ja

set SGML_CATALOG_FILES=%BASEDIR%\docbook\xml\4.4\catalog.xml

set PATH=%TOOLSDIR%\win32;%PATH%

if exist %DOCUMENTXML% goto checkhtmldir
  echo Error: %DOCUMENTXML% not found.
  pause
  exit /b 1

:checkhtmldir
if exist %HTMLDIR% goto delpdfdir
  echo Error: %HTMLDIR% directory not found.
  exit /b 1

:delpdfdir
if not exist %PDFDIR% goto createpdfdir
rmdir /s /q %PDFDIR%

:createpdfdir
mkdir %PDFDIR%
mkdir %PDFDIR%\images
copy /y %HTMLDIR%\images\*.gif %PDFDIR%\images
copy /y xsl\fo\etc\*.gif       %PDFDIR%\images
for %%i in (bps builtin constant control dcm declaration gpm ispp math ncs npe operator statistics system utility) do mkdir %PDFDIR%\%%i
for %%i in (bps builtin constant control dcm declaration gpm ispp math ncs npe operator statistics system utility) do copy /y %%i\images\*.svg %PDFDIR%\%%i
for %%i in (bps builtin constant control dcm declaration gpm ispp math ncs npe operator statistics system utility) do copy /y %HTMLDIR%\%%i\*.gif %PDFDIR%\%%i

:convert
xmllint.exe --xinclude --postvalid --nonet --catalogs %DOCUMENTXML% > %PDFDIR%\%DOCUMENTXML%
cd %PDFDIR%
XSLCmd.exe -d %DOCUMENTXML% -s ..\xsl\fo\axf.xsl -o ..\%DOCUMENTPDF%
if %errorlevel%==0 goto cleanup
  echo Error: XSLCmd.exe failed.
  pause
  exit /b 1

:cleanup
del /f %DOCUMENTXML%
cd ..
rmdir /s /q %PDFDIR%

endlocal
