#!/bin/sh

DOCUMENT=document
DISTNAME=usersman-ja

SCRIPTDIR=`dirname $0`
cd $SCRIPTDIR/..
DOCDIR=`pwd`
cd $DOCDIR/../..
BASEDIR=`pwd`
cd $DOCDIR

LINT=$BASEDIR/tools/docbook-lint.sh
TEXBASE=tex-math-equations
TEXFILE=$TEXBASE.tex
DVIFILE=$TEXBASE.dvi
LOGFILE=$TEXBASE.log
DOCUMENTXML=$DOCUMENT.xml
DOCUMENTPDF=$DISTNAME.pdf
HTMLDIR=$DOCDIR/$DISTNAME

SGML_CATALOG_FILES=$BASEDIR/docbook/xml/4.4/catalog.xml
export SGML_CATALOG_FILES
DVI2BITMAP_PK_PATH=`kpsewhich pk cmr10.110pk | sed 's+/[^/]*$+/%f.%dpk+'`
export DVI2BITMAP_PK_PATH

# xmllint
$LINT $DOCUMENTXML
if [ $? -ne 0 ]; then
  echo "Error: some error occured in docbook lint check."
  exit 1;
fi

if [ -d $HTMLDIR ]; then
  rm -rf $HTMLDIR
fi

mkdir $HTMLDIR
mkdir $HTMLDIR/images
mkdir $HTMLDIR/images/etc
cp xsl/xhtml/etc/*.css  $HTMLDIR
cp xsl/xhtml/etc/*.gif  $HTMLDIR/images/etc
cp images/*.gif         $HTMLDIR/images


xsltproc --xinclude --nonet --catalogs -o $HTMLDIR/index.html xsl/xhtml/xhtml.xsl $DOCUMENTXML

if [ -f $HTMLDIR/tex-math-equations.tex ]; then
  cd $HTMLDIR
  latex $TEXFILE
  if [ -f $DVIFILE ]; then
    dvi2bitmap --font-mode=lasf --output-type=gif --magnification=4 --scale=5 --process=blur,transparent --resolution=144 $DVIFILE
  fi
  rm -f *.dvi *.log *.tex *.aux
fi
