@echo off
setlocal

set DOCUMENT=document
set DISTNAME=usersman-ja
set DOCUMENTXML=%DOCUMENT%.xml
set DOCUMENTPDF=%DISTNAME%.pdf

rem XSL Formmatter

set SCRIPTPATH=%~p0
cd %SCRIPTPATH%\..\..\..
set BASEDIR=%cd%
set TOOLSDIR=%BASEDIR%\tools

set PATH=%TOOLSDIR%\win32;%PATH%
set SGML_CATALOG_FILES=%BASEDIR%\docbook\xml\4.4\catalog.xml

cd %SCRIPTPATH%\..
set HTMLDIR=%DISTNAME%
set PDFDIR=pdf-ja

if exist %DOCUMENTXML% goto lintcheck
  echo Error: %DOCUMENTXML% not found.
  pause
  exit /b 1

:lintcheck
call %TOOLSDIR%/docbook-lint.bat %DOCUMENTXML%
if %errorlevel%==0 goto deldir
  echo Error: some error occured in docbook lint check.
  pause
  exit /b 1

:deldir
if exist %HTMLDIR% goto createpdfdir
  echo Error: %HTMLDIR% directory not found.
  pause
  exit /b 1

:createpdfdir
if exist pdf-ja rmdir /s /q %PDFDIR%
mkdir %PDFDIR%
mkdir %PDFDIR%\images
copy  /y %HTMLDIR%\images\*eq*.gif %PDFDIR%\images

:convert
xmllint.exe --xinclude --catalogs --nonet --postvalid %DOCUMENTXML% > %DOCUMENTXML%.tmp
XSLCmd.exe -d %DOCUMENTXML%.tmp -s xsl\fo\axf.xsl -o %DOCUMENTPDF%
if %errorlevel%==0 goto cleanup
  echo Error: XSLCmd.exe failed.
  pause
  exit /b 1

:cleanup
del /f %DOCUMENTXML%.tmp
rmdir /s /q %PDFDIR%

endlocal
