/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: Base_Buffer.cpp,v 1.3 2004/08/24 07:04:11 orrisroot Exp $ */
#define  LIBSATELLITE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "SL_header.h"

#include "libsatellite.h"

#define  __EXPORTSYMBOL__
#include "SL_Index.h"
#include "Base_Buffer.h"
#undef   __EXPORTSYMBOL__

using namespace std;

#define emalloc(x) malloc(x)
#define efree(x)   free(x)

static int bufcnt=0;

// ------------------------------
//    Base_Buffer  class Method
// ------------------------------
DLLEXPORT void print_buffer_num(){
  printf("Base_Buffer res:%d\n",bufcnt);
}

Base_Buffer::Base_Buffer() : ref(0) { 
  init(); bufcnt++; 
}

Base_Buffer::~Base_Buffer(){ 
  if(ref!=0){
#ifndef WIN32
    printf("error: buffer ref count is not zero\n");
#endif
    abort();
  }
  bufcnt--;
}

void Base_Buffer::buf_unref(){
  if(ref==0){
#ifndef WIN32
    printf("error: buffer ref count already zero\n");
#endif
    abort();
  }else{
    ref--;
  } 
  //if(ref==0){ FreeBuffer(); init(); }
}

// get index
Index Base_Buffer::GetBufferIndex(){
  Index ret;
  int i;
  for(i=0;i<MAX_INDEX;i++) ret.SetIndex(i,index[i]);
  ret.SetDim(dim);
  return ret;
}
