/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: Base_Buffer.h,v 1.1.1.1 2004/03/31 08:15:07 orrisroot Exp $ */
#ifndef __BASE_BUFFER_H__
#define __BASE_BUFFER_H__
#include "declspec.h"

class DECLSPEC Base_Buffer : public Index {
public:
  enum BUFTYPE { BASE_B, SERIES_B, SCALAR_B, STRING_B, BUILTIN_B };
protected:
  BUFTYPE type;
  int  data_size;
  void *data;
  int  ref;
  void init(){ type = BASE_B; data_size=0; data=0; }
public:
  Base_Buffer();
  void buf_ref(){ ref++; }
  void buf_unref();
  bool empty(){ if(ref==0) return true; return false; }
  BUFTYPE GetType(){return type;}
  virtual ~Base_Buffer();
  virtual Base_Buffer *duplicate()=0;
  virtual bool FreeBuffer()=0;
  virtual bool CopyBuffer(Base_Buffer *from)=0;
  virtual bool InitBuffer()=0;
  virtual bool AllocBuffer(unsigned size)=0;
  virtual bool ClAllocBuffer(unsigned size)=0;
  virtual bool ReAllocBuffer(unsigned size)=0;
  void *GetDataPointer(){return data;}
  Index GetBufferIndex();
};

#endif
