/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SL_Tool.cpp,v 1.2 2004/07/29 18:07:53 orrisroot Exp $ */
#define  LIBSATELLITE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "SL_header.h"
#include <csignal>

#define  __EXPORTSYMBOL__
#include "SL_exception.h"
#include "SL_Tool.h"
#undef   __EXPORTSYMBOL__

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*sigfunc_t)(int);

bool interupt=false;

DECLSPEC void setsigint_win32(){
  interupt=true;
}

DECLSPEC void intcatch(int i){
  // i is dummy ?
  signal(SIGINT,SIG_IGN);
  interupt=true;
}

DECLSPEC void setsigint(){
  signal(SIGINT,intcatch);
}

DECLSPEC bool isintcatch(){
  return interupt;
}

DECLSPEC void unsetsigint(){
  signal(SIGINT,SIG_IGN);
  interupt=false;
}

DECLSPEC void sigintblock(bool t){
  static bool save=false;
  static sigfunc_t istat;
  if(t){
    if(save){
      return;
    }
    save=true;
    istat=(sigfunc_t)signal(SIGINT,SIG_IGN);
  }else{
    if(!save){
      return;
    }
    signal(SIGINT,istat);
    save=false;
  }
}

#ifdef __cplusplus
}
#endif
