/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: Scalar_Buffer.cpp,v 1.2 2004/07/29 18:07:53 orrisroot Exp $ */
#define  LIBSATELLITE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "SL_header.h"

#include "libsatellite.h"

#define  __EXPORTSYMBOL__
#include "SL_exception.h"
#include "SL_Index.h"
#include "Base_Buffer.h"
#include "Scalar_Buffer.h"
#undef   __EXPORTSYMBOL__

using namespace std;

// static int sb_cnt=0;

// DLLEXPORT void print_scalar_buffer_num(){
//   printf("Scalar_Buffer res:%d\n",sb_cnt);
// }

Scalar_Buffer::Scalar_Buffer(){
//   sb_cnt++;
  index[0]=1;dim=0;type=SCALAR_B;
}

Scalar_Buffer::~Scalar_Buffer(){
//   sb_cnt--;
  FreeBuffer();
}

Base_Buffer *Scalar_Buffer::duplicate(){
  Base_Buffer *ret;
  try{
    ret = new Scalar_Buffer;
  }catch(bad_alloc){
    return 0;
  }
  ret->CopyBuffer(this);
  return ret;
}

bool Scalar_Buffer::InitBuffer(){
  index[0]=1;dim=0;
  FreeBuffer();
  data=new double;
  ((double *)data)[0]=0.0;
  data_size=1;
  return true;
}

bool Scalar_Buffer::FreeBuffer(){
  bool stat;
  if(data!=0){
    delete (double*)data;
    data=0;
    stat=true;
  }else{
    stat=false;
  }
  data_size=0;
  return stat;
}

bool Scalar_Buffer::CopyBuffer(Base_Buffer *from){
  double *i;
  InitBuffer();
  if(from->GetType()!=SCALAR_B)
    if(from->GetType()!=SERIES_B && from->IndexSize()!=1)
      throw bad_type();
  i=(double *)from->GetDataPointer();
  SetScalar(*i);
  return true;
}

double Scalar_Buffer::GetScalar(){
  if(data==0)throw bsize_mis();
  return ((double *)data)[0];
}
