/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: String_Buffer.cpp,v 1.2 2004/07/29 18:07:53 orrisroot Exp $ */
#define  LIBSATELLITE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "SL_header.h"

#include "libsatellite.h"

#define  __EXPORTSYMBOL__
#include "SL_exception.h"
#include "SL_Index.h"
#include "Base_Buffer.h"
#include "String_Buffer.h"
#undef   __EXPORTSYMBOL__

using namespace std;

// static int sb_cnt=0;

// DLLEXPORT void print_string_buffer_num(){
//   printf("String_Buffer res:%d\n",sb_cnt);
// }

// ------------------------------------
//   String_Buffer class  Method
// ------------------------------------
String_Buffer::String_Buffer(){
  type=STRING_B;
//   sb_cnt++;
}

String_Buffer::String_Buffer(string& str){
  type=STRING_B;
  index[0]=1; dim=1;
  AllocBuffer(1);
  ((string*)data)[0]=str;
//   sb_cnt++;
}

String_Buffer::String_Buffer(list<string>& str){
  unsigned int i;
  list<string>::iterator it;
  type=STRING_B;
  dim=1;index[0]=(int)str.size(); /* TODO: remove cast */
  AllocBuffer(index[0]);
  for(i=0,it=str.begin();it!=str.end();i++,it++)
    ((string*)data)[i]=(*it);
//   sb_cnt++;
}

String_Buffer::~String_Buffer(){
  FreeBuffer();
//   sb_cnt--;
}

Base_Buffer *String_Buffer::duplicate(){
  Base_Buffer *ret;
  try{
    ret = new String_Buffer();
  }catch(bad_alloc){
    return 0;
  }
  ret->CopyBuffer(this);
  return ret;
}

// resize buffer
bool String_Buffer::ReSize(int length){
  int size;
  size=length*SubIndexSize();
  if(dim==0)throw ill_dim();
  if(data==0){
    index[0]=length;
    dim=1;
    return InitBuffer();
  }
  if(index[0]==length) return true; // success
  ReAllocBuffer(size);
  index[0]=length;
  return true;
}

// initialize buffer memory by Index array
bool String_Buffer::InitBuffer(){
  int size;
  FreeBuffer();
  size=IndexSize();
  if(size==0)throw ill_index();
  AllocBuffer(size);
  return true;
}

bool String_Buffer::AllocBuffer(unsigned size){
  FreeBuffer();
  data=new string[size];
  data_size=size;
  return true;
}

bool String_Buffer::ClAllocBuffer(unsigned size){
  return AllocBuffer(size);
}

bool String_Buffer::ReAllocBuffer(unsigned size){
  string *tmp;
  int i,old_size;
  tmp=(string*)data;
  old_size=data_size;
  data_size=size;
  try {
    data=new string[size];
  }catch(bad_alloc){
    data=tmp;
    data_size=old_size;
    throw;
  }
  if(old_size!=0){
    for(i=0;i<old_size;i++)
      ((string*)data)[i]=tmp[i];
    delete [] tmp;
  }
  return true;
}

// copy buffer
bool String_Buffer::CopyBuffer(Base_Buffer *from){
  int i,size;
  string *from_data;
  if(from->GetType()!=STRING_B)throw bad_type();
  FreeBuffer();
  CopyIndex(from->GetBufferIndex());
  InitBuffer();
  size=IndexSize();
  from_data=(string*)from->GetDataPointer();
  for(i=0;i<size;i++){
    ((string*)data)[i]=from_data[i];
  }
  return true;
}

// set string to point index
bool String_Buffer::SetString(Index point,const char *from){
  Index idx;
  int pt;
  string str(from);
  // initialized check of buffer
  if(data==0) if(InitBuffer()==false) return false;
  idx=GetBufferIndex();
  if(from==0){return false;}
  pt=DataPoint(point);
  if(!RegularIndex(point)){
    // if current position is index[0]+1 then allow adding
    if(SubIndex().RegularIndex(point.SubIndex()) 
       && point.GetIndex(0)==index[0]){
      ReAllocBuffer(IndexSize()+SubIndexSize());
      ((string *)data)[pt]=str;
      index[0]++;
    } else {
      throw ill_index();
    }
  }
  ((string *)data)[pt]=str;
  return true;
}

// get string from point index
const char *String_Buffer::GetString(Index point){
  int pt;
  if(!RegularIndex(point))throw ill_index();
  pt=DataPoint(point);
  return ((string*)data)[pt].c_str();
}

const char *String_Buffer::GetString(){
  if(IndexSize()==0)throw ill_index();
  if(((string*)data)[0].size()==0)return 0;
  return ((string*)data)[0].c_str();
}

// free string array data in variable 'data'
bool String_Buffer::FreeBuffer(){
  bool stat;
  if(data==0){
    stat=false;
  }else{
    delete [] (string*)data;
    data=0;
    stat=true;
  }
  return stat;
}

