/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: strutil.c,v 1.6 2005/10/18 16:22:00 orrisroot Exp $ */
#define LIBSATELLITE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libsatellite.h"

#define TRIM_MODE_RIGHT 0x01
#define TRIM_MODE_LEFT  0x02
#define TRIM_MODE_ALL   0x03

/*  c:/test/hoge\ files    */
/*  "c:/test/hoge files"   */
/*  c:\\test\\hoge\ files  */
DLLEXPORT size_t strutil_check_quote(const char *str, char stop, int *status){
  int in_squote  = 0;
  int in_dquote  = 0;
  int in_escape = 0;
  size_t total, i;
  total = strlen(str);
  for(i=0;i<total;i++){
    if((in_dquote || in_squote) && in_escape){
      /* inside of 'quote' and previous char is 'back slash' - "\ */
      in_escape = 0;
    }else if(in_dquote){
      /* inside of 'quote' " */
      if(str[i] == '"'){
        in_dquote = 0;
      }else if(str[i] == '\\'){
        in_escape = 1;
      }
    }else if(in_squote){
      if(str[i] == '\''){
        in_squote = 0;
      }else if(str[i] == '\\'){
        in_escape = 1;
      }
    }else if(in_escape){
      /* outside of 'quote' and previous char is 'back slash' - \ */
      in_escape = 0;
    }else{
      /* normal condition */
      if(str[i] == '\\'){
        in_escape = 1;
      }else if(str[i] == '\''){
        in_squote = 1;
      }else if(str[i] == '"'){
        in_dquote = 1;
      }else{
        if(str[i] == stop) break;
      }
    }
  }
  if(status != NULL){
    *status = 0x00;
    if(i==0)       *status += 0x08;
    if(in_escape)  *status += 0x04;
    if(in_dquote)  *status += 0x02;
    if(in_squote)  *status += 0x01;
  }
  return i;
}

DLLEXPORT char *strutil_strtok_r(char *s, const char *delim, char **last){
  char *spanp;
  int c, sc;
  char *tok;

  if(s == NULL && (s = *last) == NULL){ return NULL; }
  /*
   * Skip (span) leading delimiters (s += strspn(s, delim), sort of).
   */
 cont:
  c = *s++;
  for(spanp = (char *)delim; (sc = *spanp++) != 0;){
    if(c == sc){ goto cont; }
  }
  if(c == 0){         /* no non-delimiter characters */
    *last = NULL;
    return NULL;
  }
  tok = s - 1;
  /*
   * Scan token (scan for delimiters: s += strcspn(s, delim), sort of).
   * Note that delim must have one NUL; we stop if we see that, too.
   */
  for(;;){
    c = *s++;
    spanp = (char *)delim;
    do{
      if((sc = *spanp++) == c){
        if(c == 0){
          s = NULL;
        }else{
          char *w = s - 1;
          *w = '\0';
        }
        *last = s;
        return tok;
      }
    }while(sc != 0);
  }
  /* NOTREACHED */
  return NULL;
}

