/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: Builtin.h,v 1.1.1.1 2004/03/31 08:15:07 orrisroot Exp $ */
#ifndef __BUILTINFUNCTIONS_H__
#define __BUILTINFUNCTIONS_H__

class tty_console;
class StackMachine;
class BuiltinFunctions;
typedef SL_Object* (BuiltinFunctions::*BFUNC)(int, SL_Object**);
class BuiltinFunctions {
private:
  StackMachine *stackmachine;
  tty_console  *console;
  int _symbols(const char *sym, size_t columns);
public:
  BuiltinFunctions(StackMachine *s, tty_console *con) : 
    stackmachine(s), console(con) {}
  SL_Object *execute(BFUNC func,int argc,SL_Object *obj[]){
    return (this->*func)(argc,obj);
  }
  SL_Object *alias(int argc,SL_Object *obj[]);
  SL_Object *symbols(int argc,SL_Object *obj[]);
  SL_Object *history(int argc,SL_Object *obj[]);
  SL_Object *WriteType(int argc,SL_Object *obj[]);
  SL_Object *lengthof(int argc,SL_Object *obj[]);
  SL_Object *indexof(int argc,SL_Object *obj[]);
  SL_Object *Typeof(int argc,SL_Object *obj[]);
  SL_Object *Printf(int argc,SL_Object *obj[]);
  SL_Object *Abort(int argc,SL_Object *obj[]);
  SL_Object *eval_program(int argc,SL_Object *obj[]);
  SL_Object *welcome(int argc,SL_Object *obj[]);
  SL_Object *goodbye(int argc,SL_Object *obj[]);
  SL_Object *Strlen(int argc,SL_Object *obj[]);
  SL_Object *strict_grammar(int argc,SL_Object *obj[]);
  SL_Object *sl4vars(int argc,SL_Object *obj[]);
#ifdef WIN32
  SL_Object *Pwd(int argc,SL_Object *obj[]);
#endif
};  


#endif
