/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: Builtin_Buffer.h,v 1.1.1.1 2004/03/31 08:15:07 orrisroot Exp $ */
// Builtin class
#ifndef __BUILTIN_BUFFER_H__
#define __BUILTIN_BUFFER_H__

#define BLTINBUF_TYPE_UNDEF   0
#define BLTINBUF_TYPE_CLASS   1
#define BLTINBUF_TYPE_BFUNC   2
#define BLTINBUF_TYPE_OFUNC   3
#define BLTINBUF_TYPE_SPROG   4
#define BLTINBUF_TYPE_MODULE  5
#define BLTINBUF_TYPE_SATCOM  6

#define CLASS_TYPE_SERIES    0
#define CLASS_TYPE_SNAPSHOT  1
#define CLASS_TYPE_SCALAR    2
#define CLASS_TYPE_STRING    3

class Builtin_Buffer : public Base_Buffer {
private:
  int bbtype;
  union {
    BFUNC       bfunc;
    int         ofunc;
    SubProgram *sub;
    int         klass;
    module_t         *module;
    module_command_t *satcom;
  } funcs;
public:
  Builtin_Buffer();
  ~Builtin_Buffer();
  Base_Buffer *duplicate();
  bool FreeBuffer();
  bool AllocBuffer(unsigned int i){return false;}
  bool ClAllocBuffer(unsigned int i){return false;}
  bool ReAllocBuffer(unsigned int i){return false;}
  bool CopyBuffer(Base_Buffer *from){
    if(from==NULL){ return false; }
    funcs=((Builtin_Buffer*)from)->funcs;
    dim=from->GetDim();
    return true;
  }
  bool InitBuffer(){ return true; }
  int  bltin_type(){ return bbtype; }
  void SetClassType(int kl){ bbtype=BLTINBUF_TYPE_CLASS; funcs.klass=kl; }
  void SetBFunction(BFUNC  dptr){ bbtype=BLTINBUF_TYPE_BFUNC; funcs.bfunc=dptr; }
  void SetSubProgram(SubProgram* s){ bbtype=BLTINBUF_TYPE_SPROG; data=s; }
  void SetOFunction(int op_n){ bbtype=BLTINBUF_TYPE_OFUNC; funcs.ofunc=op_n; }
  void SetModule(module_t *mod){ bbtype=BLTINBUF_TYPE_MODULE; funcs.module=mod; }
  void SetSatCom(module_command_t *com){ 
    bbtype=BLTINBUF_TYPE_SATCOM; funcs.satcom=com; 
  }
  BFUNC  GetBFunction(){ return funcs.bfunc; }
  SubProgram* GetSubProgram(){ return (SubProgram*)data; }
  int  GetOFunction(){ return funcs.ofunc; }
  int  GetClassType(){ return funcs.klass; }
  module_t *GetModule(){ return funcs.module; }
  module_command_t *GetSatCom(){ return funcs.satcom; }

};
#endif
