/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: Program.cpp,v 1.6 2004/09/24 15:59:07 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "SL_header.h"

#include <libsatellite.h>

#define  __IMPORTSYMBOL__
#include "SL_exception.h"
#include "history.h"
#include "module.h"
#include "tty_console.h"
#include "SL_Index.h"
#include "Base_Buffer.h"
#include "Series_Buffer.h"
#include "Snapshot_Buffer.h"
#include "String_Buffer.h"
#include "Scalar_Buffer.h"
#include "SL_Tool.h"
#include "SL_Object.h"
#include "SymbolList.h"
#include "SystemCommon.h"
#undef   __IMPORTSYMBOL__
#include "parse.h"
#include "Program.h"

#include "acc.h"

using namespace std;

static void _symbol_table_dump_syms_func(void *void_sym, void *void_arg);
static void _symbol_table_restore_syms_func(void *void_sym, void *void_arg);

Program::~Program(){
  if(type==PROG_TYPE_OBJ && dat.obj!=0){
    dat.obj->obj_unref();
    if(dat.obj->empty()){
      acc_del(dat.obj);
      delete_SL_Object(dat.obj);
    }
  }
}

void Program_List::Program_Init(){
  for(pc=top;pc!=0;pc=top){
    top=pc->GetNext();
    delete pc;
  }
  top=0;
  pc=0;
}

bool Program_List::Program_Set(int p,STACKFUNC func){
  Program *tmp;
  int i;
  tmp=pc;
  if(p>0)for(i=0;i<p;i++){tmp=tmp->GetNext();if(tmp==0)return false;}
  else   for(i=p;i<0;i++){tmp=tmp->GetPrev();if(tmp==0)return false;}
  tmp->SetProgram(func);
  return true;
}

Program *Program_List::Symbol_Add(symbol_t *add){
  Program *ret;
  ret=new Program;
  ret->SetSymbol(add);
  if(top==0){
    top=ret;
    pc=ret;
  } else {
    pc->SetNext(ret);
    ret->SetPrev(pc);
    pc=ret;
  }
  return ret;
}

Program *Program_List::Data_Add(int add){
  Program *ret;
  ret=new Program;
  ret->SetData(add);
  if(top==0){
    top=ret;
    pc=ret;
  } else {
    pc->SetNext(ret);
    ret->SetPrev(pc);
    pc=ret;
  }
  return ret;
}

Program *Program_List::Obj_Add(SL_Object *add){
  Program *ret;
  ret=new Program;
  ret->SetObj(add);
  if(add){ add->obj_ref(); }
  if(top==0){
    top=ret;
    pc=ret;
  } else {
    pc->SetNext(ret);
    ret->SetPrev(pc);
    pc=ret;
  }
  return ret;
}

Program *Program_List::Program_Add(STACKFUNC add){
  Program *ret;
  ret=new Program;
  ret->SetProgram(add);
  if(top==0){
    top=ret;
    pc=ret;
  } else {
    pc->SetNext(ret);
    ret->SetPrev(pc);
    pc=ret;
  }
  return ret;
}

Program *Program::operator+(int p){
  int i;
  Program *ret;
  ret=this;
  for(i=0;i<p;i++){
    if(ret==0)return 0;
    ret=ret->GetNext();
  }
  return ret;
}

Program *Program::operator-(int p){
  int i;
  Program *ret;
  ret=this;
  for(i=0;i<p;i++){
    if(ret==0)return 0;
    ret=ret->GetPrev();
  }
  return ret;
}

/* sub program */

SubProgram::SubProgram(symbol_t *sym) : narg(0), my_sym(sym), 
                                        arg_symbols(0){
  lo_symtab = symbol_table_new();
}
    
SubProgram::~SubProgram(){
  /* delete symbols */
  if(lo_symtab) symbol_table_delete(lo_symtab);
  if(narg)      free(arg_symbols);
}

int SubProgram::pickup_args(symbol_t *sym){
  symbol_t **args;
  if(narg == 0){
    args = (symbol_t**)malloc(sizeof(symbol_t*));
  }else{
    args = (symbol_t**)realloc(arg_symbols,sizeof(symbol_t*)*(narg+1));
  }
  if(args == NULL) return -1;
  arg_symbols       = args;
  arg_symbols[narg] = sym;
  narg++;
  return 0;
}

typedef struct _table_dump_restore_syms_arg_t {
  SL_Object    **objs;
  symbol_t     **syms;
  unsigned int   target;
} table_dump_restore_syms_arg_t;

static void _symbol_table_dump_syms_func(void *void_sym, void *void_arg){
  symbol_t            *sym;
  table_dump_restore_syms_arg_t *args;
  sym = (symbol_t*) void_sym;
  args = (table_dump_restore_syms_arg_t*)void_arg;
  if(sym->dep == NULL){
    if(sym->object) sym->object->obj_ref(); /* for undef(sym) */
    args->objs[args->target] = sym->object;
    args->syms[args->target] = NULL;
  }else{
    args->objs[args->target] = NULL;
    args->syms[args->target] = sym->dep;
  }
  symbol_undef(sym);
  args->target++;
}

static void _symbol_table_restore_syms_func(void *void_sym, void *void_arg){
  symbol_t            *sym;
  table_dump_restore_syms_arg_t *args;
  SL_Object *tmp;
  sym = (symbol_t*) void_sym;
  args = (table_dump_restore_syms_arg_t*)void_arg;
  if(sym->object){
    sym->object->obj_unref();
    if(sym->object->empty())
      acc_del(sym->object);
    sym->object->obj_ref();
  }
  symbol_undef(sym);
  if(args->syms[args->target] == NULL){
    /* object */
    tmp = args->objs[args->target];
    if(tmp){
      symbol_set_object(sym, tmp, sym->type);
      tmp->obj_unref();
    }
  }else{
    symbol_set_depend(sym, args->syms[args->target]);
  }
  args->target++;
}

int SubProgram::push_syms(){
  SL_Object **objs = NULL;
  symbol_t  **syms = NULL;
  table_dump_restore_syms_arg_t args;
  if(lo_symtab->table->nkeys != 0){
    objs = (SL_Object**)malloc(sizeof(SL_Object*) * lo_symtab->table->nkeys);
    syms = (symbol_t**)malloc(sizeof(symbol_t*) * lo_symtab->table->nkeys);
    if(objs != NULL && syms != NULL){
      args.objs   = objs;
      args.syms   = syms;
      args.target = 0;
      hash_table_foreach(lo_symtab->table, _symbol_table_dump_syms_func, 
                         &args);
    }
  }
  symtab_objs_stack.push(objs);
  symtab_syms_stack.push(syms);
  return 0;
}

int SubProgram::pop_syms(){
  table_dump_restore_syms_arg_t args;
  SL_Object **objs;
  symbol_t  **syms;
  objs = symtab_objs_stack.top();
  syms = symtab_syms_stack.top();
  symtab_objs_stack.pop();
  symtab_syms_stack.pop();
  if(objs && syms){
    args.objs   = objs;
    args.syms   = syms;
    args.target = 0;
    hash_table_foreach(lo_symtab->table, _symbol_table_restore_syms_func,
                       &args);
    free(objs);
    free(syms);
  }
  return 0;
}
