/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: StackMachine.h,v 1.4 2005/06/29 15:24:32 orrisroot Exp $ */
#ifndef __STACKMACHINE_H__
#define __STACKMACHINE_H__
#include "declspec.h"

#define VMCODE_MODULE_DEFINE_DLL 0
#define VMCODE_MODULE_DEFINE_INI 1
#define VMCODE_MODULE_DEFINE_SCR 2

// debugging symbols (all symbols required "#define _DEBUG")
//   _DEBUG_STACK  - check satellite VM stack
//   _DEBUG_ERRPOS - check satellite VM error position
//   _DEBUG_CODE   - check satellite VM code
class DECLSPEC StackMachine {
  friend int yyparse(void *);
private:
  std::stack<Program_List*> eval_stack;
  std::stack<Datum*> data_stack;
  //  std::list<module_t*> module_list;
  std::string err_msg;
  bool in_eval, do_print;
#if defined(_DEBUG) && defined(_DEBUG_STACK)
  int data_stack_depth;
#endif
  BuiltinFunctions builtin;
  PipeStream pipe_stream;
  int call_stack_depth;
  bool returning,breaking,continuing;
  SL_Object *increment(symbol_t *sym);
  void ret();
  SL_Object *pop_obj();           // pop object from stack
  symbol_t *pop_sym();              // pop symbol from stack
  double pop_val();               // pop value from stack
  void push_obj(SL_Object *obj);  // push object to stack
  void push_sym(symbol_t *sym);     // push symbol to stack
  SL_Object *symbol_to_quoted_object(symbol_t *sym);
  void endSub(); // sub function for "func" and "proc"
  int  get_index(); // sub function for load() store()
public:
  tty_console *console;
  STACKFUNC STOP;
  LexicalAnalizer lex;
  StackMachine(tty_console *con);
  ~StackMachine();
  vm_stat_t vmstat;
  bool GetDoPrint(){ return do_print; }
  void SetDoPrint(bool flag){ do_print = flag; }
  void MainLoop();
  void initcode();
  void recovery();
  Program *GetProgram(){return vmstat.prog->Get_PC();}
  Program *code(STACKFUNC f);
  Program *code(symbol_t *f);
  Program *code(int f);
  Program *code(SL_Object *obj);
  // basic code
  void constpush();
  void varpush();
  void eval();
  void assign();
  void selfasgn();
  void varread();
  void auto_print();
  void print();
  void postfix();
  void prefix();
  void basic1();
  void basic2();
  void bltin();
  void dispatch();
  void array();
  void array_asgn();
  void snapshot();
  void snapshot_asgn();
  void newobj();
  void ramp();
  void combin();
  void undef_var();
  void undef_all();
  void isdef_var();
  void load();
  void store();
  void ifcode();
  void forcode();
  void whilecode();
  void dowhilecode();
  void breaker(){breaking=true;}
  void continuer(){continuing=true;}
  void constant();
  void call();
  void begin_inline();
  void end_inline();
  void procret();
  void funcret();
  void external();
  void POP();
  void module_define_begin();
  void module_define_end();
  void module_setfile();
  void module_install();
  void module_print();
  void module_exec();
  void make_pipe();
  void close_pipe();
  void external_cmd();
  void internal_cmd();
  void system();
  // sub functions
  SL_Object *eval_program(const char *str);
  void Program_Run(Program *p);
  void Program_Init(){vmstat.prog->Program_Init();}
  // parse error
  void yyerror(char *s);
};

#endif
