#ifndef __COMMAND_ALIAS_H__
#define __COMMAND_ALIAS_H__

#ifdef DLLEXPORT
# undef DLLEXPORT
#endif
#ifdef DLLIMPORT
# undef DLLIMPORT
#endif
#ifdef DECLSPEC
# undef DECLSPEC
#endif

#if defined(WIN32) || defined(__CYGWIN__)
#  define DLLEXPORT __declspec(dllexport)
#  define DLLIMPORT __declspec(dllimport)
# ifdef LIBSLSHELL_EXPORTS
#  define DECLSPEC DLLEXPORT
# else
#  define DECLSPEC DLLIMPORT
# endif
#else
# define DLLEXPORT
# define DLLIMPORT
# define DECLSPEC
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _sl4_alias_t {
  sl4_list_t          *aliases;
} sl4_alias_t;

DECLSPEC sl4_alias_t *sl4_alias_new();
DECLSPEC void         sl4_alias_delete(sl4_alias_t *al);
DECLSPEC int          sl4_alias_install(sl4_alias_t *al, const char *n, const char *r);
DECLSPEC void         sl4_alias_delete(sl4_alias_t *al, const char *n);
DECLSPEC const char  *sl4_alias_lookup(sl4_alias_t *al, const char *n);
DECLSPEC void         sl4_alias_listup(sl4_alias_t *al);

#ifdef __cplusplus
}
#endif

#endif /* __COMMAND_ALIAS_H__ */
