# Configure paths for termcap lib
# Yoshihiro OKUMURA
#

dnl AM_PATH_TERMCAP()
dnl test for termcap, and define TERMCAP_LIBS
dnl
AC_DEFUN([AM_PATH_TERMCAP],
[dnl
  TERMCAP_LIBS=""

# checking headers
  AC_CHECK_HEADERS([ncurses.h termcap.h curses.h term.h])
  if test $ac_cv_header_ncurses_h = no && test $ac_cv_header_termcap_h = no && test $ac_cv_header_curses_h = no && test $ac_cv_header_term_h = no ; then
    AC_MSG_ERROR([*** curses or termcap header not installed - please install first ***])
  fi

# checking libs
  AC_CHECK_LIB(ncurses, tgetent, have_ncurses=yes, have_ncurses=no)
  AC_CHECK_LIB(curses, tgetent, have_curses=yes, have_curses=no)
  AC_CHECK_LIB(termcap, tgetent, have_termcap=yes, have_termcap=no)

  if test x$have_ncurses = xyes; then
    TERMCAP_LIBS="-lncurses"
  elif test x$have_curses = xyes; then
    TERMCAP_LIBS="-lcurses"
  elif test x$have_termcap = xyes; then
    TERMCAP_LIBS="-ltermcap"
  else
    AC_MSG_ERROR([*** curses or termcap lib not installed - please install first ***])
  fi

  AC_SUBST(TERMCAP_LIBS)
])
