# Configure paths for Athena Widget
# Yoshihiro OKUMURA
#

dnl AM_PATH_XTOOLKIT()
dnl test for X11R6 Toolkit libraries
dnl
AC_DEFUN([AM_PATH_XTOOLKIT],
[dnl

# Change these status
# require_xpm="no"
# check_motif="no"
# check_motif_error="no"
# check_xaw3d="no"
# check_xaw3d_error="no"
# check_xaw="no"
# check_xaw_error="no"

require_xpm="yes"
check_motif="no"
check_motif_error="no"
check_xaw="yes"
check_xaw_error="no"
check_xaw3d="yes"
check_xaw3d_error="no"

# end of status

# don't edit under lines
XTOOLKIT_CFLAGS=""
XTOOLKIT_LIBS=""
XM_CFLAGS=""
XM_LIBS=""
XAW_CFLAGS=""
XAW_LIBS=""
XAW3D_CFLAGS=""
XAW3D_LIBS=""
XPM_CFLAGS=""
XPM_LIBS=""

have_xpm="no"
have_motif="no"
have_xaw3d="no"
have_xaw="no"

##
## checking x11 libraries
##
AC_PATH_XTRA

## arguments
if test "x$check_xaw3d" = xyes; then
AC_ARG_WITH(xaw3d,
            [  --with-xaw3d[[=prefix]]   use Xaw3d for X widget set],
            with_xaw3d=yes && xaw3d_prefix="$withval", 
            with_xaw3d=no  && xaw3d_prefix="")
  if test "x$with_xaw3d" = xyes; then
    check_xaw="no"
    check_xaw3d_error="yes"
  fi
  if test "x$xaw3d_prefix" = x ; then
    XAW3D_INCLUDES=""
    XAW3D_LFLAGS=""
  else
    XAW3D_INCLUDES="-I$xaw3d_prefix/include"
    XAW3D_LFLAGS="-L$xaw3d_prefix/lib"
  fi
fi

##
## checking X Extensions library routines
##

#
# checking X Extensions library
#  * libXext : -lXext -lX11
#
save_cflags="$CFLAGS"
save_libs="$LIBS"
CFLAGS="$save_cflags $X_CFLAGS"
LIBS="$X_LIBS $X_PRE_LIBS -lX11 $X_EXTRA_LIBS $save_libs"
AC_CHECK_LIB(Xext, main, XEXTLIB="-lXext", XEXTLIB="", $LIBS)
CFLAGS="$save_cflags"
LIBS="$save_libs"


##
## checking X Tool Kit libraries
##

#
# checking X Tool kit library
#  * libXt : -lXt -lSM -lICE -lX11
#
save_cflags="$CFLAGS"
save_libs="$LIBS"
CFLAGS="$save_cflags $X_CFLAGS"
LIBS="$X_LIBS $X_PRE_LIBS -lX11 $X_EXTRA_LIBS $save_libs"
AC_CHECK_LIB(Xt, XtAppInitialize, XTLIB="-lXt", XTLIB="", $LIBS)
CFLAGS="$save_cflags"
LIBS="$save_libs"

#
# error check for libXt
#
if test "x$XTLIB" = x; then
  AC_MSG_ERROR([The X Toolkit Library '-lXt' could not be found])
fi

#
# checking X Miscellaneous utilities library
#  * libXmu : -lXmu -lXt -lXext -lSM -lICE -lX11
#
save_cflags="$CFLAGS"
save_libs="$LIBS"
CFLAGS="$save_cflags $X_CFLAGS"
LIBS="$X_LIBS -lXt $XEXTLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS $save_libs"
AC_CHECK_LIB(Xmu, main, XMULIB="-lXmu", XMULIB="", $LIBS)
CFLAGS="$save_cflags"
LIBS="$save_libs"

##
## checking X Pixmap library
##  * libXpm : -lXpm -lXext -lX11
##
save_cflags="$CFLAGS"
save_libs="$LIBS"
CFLAGS="$save_cflags $X_CFLAGS"
LIBS="$X_LIBS $XEXTLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS $save_libs"
# check header - xpm.h
AC_CHECK_HEADER(X11/xpm.h)
AC_CHECK_LIB(Xpm, XpmCreatePixmapFromBuffer, XPMLIB="-lXpm", XPMLIB="")
CFLAGS="$save_cflags"
LIBS="$save_libs"
AC_MSG_CHECKING(for XPM Library)
if test $ac_cv_header_X11_xpm_h = yes && test "x$XPMLIB" != "x"; then
  AC_MSG_RESULT([yes])
  have_xpm="yes"
  XPM_CFLAGS="$X_CFLAGS"
  XPM_LIBS="$X_LIBS $XEXTLIB $XPMLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS"
else
  AC_MSG_RESULT([no])
  if test $require_xpm = yes; then
    AC_MSG_ERROR([The XPM library '-lXpm' could not be found])
  fi
fi
AC_SUBST(XPM_CFLAGS)
AC_SUBST(XPM_LIBS)

##
## checking Motif libraries
##
if test "x$check_motif" = xyes; then

#
# checking X authority database library
#  * libXau : -lXau -lXext -lX11
#
  save_cflags="$CFLAGS"
  save_libs="$LIBS"
  CFLAGS="$save_cflags $X_CFLAGS"
  LIBS="$X_LIBS $XEXTLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS $save_libs"
  AC_CHECK_LIB(Xau, XauReadAuth, XAULIB="-lXau", XAULIB="", $LIBS)
  CFLAGS="$save_cflags"
  LIBS="$save_libs"

#
# checking X print server library
#  * libXp : -lXp -lXau -lXext -lX11
#
  save_cflags="$CFLAGS"
  save_libs="$LIBS"
  CFLAGS="$save_cflags $X_CFLAGS"
  LIBS="$X_LIBS $XAULIB $XEXTLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS $save_libs"
  AC_CHECK_LIB(Xp, XpCreateContext, XPLIB="-lXp", XPLIB="", $LIBS)
  CFLAGS="$save_cflags"
  LIBS="$save_libs"

#
# checking Motif library
#  * libXm : -lXm -lXp -lXau -lXt -lXext -lSM -lICE -lX11
#
  save_cflags="$CFLAGS"
  save_libs="$LIBS"
  CFLAGS="$save_cflags $X_CFLAGS"
  LIBS="$X_LIBS $XPLIB $XAULIB $XTLIB $XEXTLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS $save_libs"
  AC_CHECK_LIB(Xm, main, XMLIB="-lXm", XMLIB="", $LIBS)
  CFLAGS="$save_cflags"
  LIBS="$save_libs"

# set XM_CFLAGS and XM_LIBS variables
  if test "x$XMLIB" = x; then
    if test "x$check_motif_error" = "xyes"; then
      AC_MSG_ERROR([The Motif Library '-lXm' could not be found])
    fi
  else
    have_motif="yes"
    XM_CFLAGS="-DHAVE_MOTIF $X_CFLAGS"
    XM_LIBS="$X_LIBS $XMLIB $XPLIB $XAULIB $XTLIB $XEXTLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS"
  fi
fi
# end of check_motif


##
## checking Athena Widget library
##
if test "x$check_xaw" = xyes; then

#
# checking X11 Athena Widget library
#  * libXaw : -lXaw -lXmu -lXt -lXext -lSM -lICE -lX11
#
  save_cflags="$CFLAGS"
  save_libs="$LIBS"
  CFLAGS="$save_cflags $X_CFLAGS"
  LIBS="$X_LIBS $XMULIB $XTLIB $XEXTLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS $save_libs"
  AC_CHECK_LIB(Xaw, main, XAWLIB="-lXaw", XAWLIB="", $LIBS)
  CFLAGS="$save_cflags"
  LIBS="$save_libs"

# set XAW_CFLAGS and XAW_LIBS variables
  if test "x$XAWLIB" = x; then
    if test "x$check_xaw_error" = "xyes"; then
      AC_MSG_ERROR([The X11 Athena Widget Library '-lXaw' could not be found])
    fi
  else
    have_xaw="yes"
    XAW_CFLAGS="$X_CFLAGS"
    XAW_LIBS="$X_LIBS $XAWLIB $XMULIB $XTLIB $XEXTLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS"
  fi
fi
# end of check_xaw


##
## checking Athena Widget 3D library
##
if test "x$check_xaw3d" = xyes; then

#
# checking Athena Widget 3D library
#  * libXaw3d : -lXaw3d -lXpm -lXmu -lXt -lXext -lSM -lICE -lX11
#
  save_cflags="$CFLAGS"
  save_libs="$LIBS"
  CFLAGS="$save_cflags $X_CFLAGS $XAW3D_INCLUDES"
  LIBS="$X_LIBS  $XAW3D_LFLAGS $XPMLIB $XMULIB $XTLIB $XEXTLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS $save_libs"
  AC_CHECK_LIB(Xaw3d, main, XAW3DLIB="-lXaw3d", XAW3DLIB="", $LIBS)
  CFLAGS="$save_cflags"
  LIBS="$save_libs"

# set XAW_CFLAGS and XAW_LIBS variables
  if test "x$XAW3DLIB" = x; then
    if test "x$check_xaw3d_error" = "xyes"; then
      AC_MSG_ERROR([The X11 Athena Widget 3D Library '-lXaw3d' could not be found])
    fi
  else
    have_xaw3d="yes"
    XAW3D_CFLAGS="-DHAVE_XAW3D $X_CFLAGS $XAW3D_INCLUDES"
    XAW3D_LIBS="$X_LIBS $XAW3D_LFLAGS $XAW3DLIB $XPMLIB $XMULIB $XTLIB $XEXTLIB $X_PRE_LIBS -lX11 $X_EXTRA_LIBS"
  fi
fi
# end of check_xaw3d



##
## output variables
##

# set XTOOLKIT_CFLAGS and XTOOLKIT_LIBS variables
AC_MSG_CHECKING(for X Toolkit)
if test "x$have_motif" = xyes; then
  XTOOLKIT_CFLAGS="$XM_CFLAGS"
  XTOOLKIT_LIBS="$XM_LIBS"
  AC_MSG_RESULT([Motif : libraries $XTOOLKIT_LIBS, cflags $XTOOLKIT_CFLAGS])
elif test "x$have_xaw3d" = xyes; then
  XTOOLKIT_CFLAGS="$XAW3D_CFLAGS"
  XTOOLKIT_LIBS="$XAW3D_LIBS"
  AC_MSG_RESULT([Xaw3d : libraries $XTOOLKIT_LIBS, cflags $XTOOLKIT_CFLAGS])
elif test "x$have_xaw" = xyes; then
  XTOOLKIT_CFLAGS="$XAW_CFLAGS"
  XTOOLKIT_LIBS="$XAW_LIBS"
  AC_MSG_RESULT([Xaw : libraries $XTOOLKIT_LIBS, cflags $XTOOLKIT_CFLAGS])
else
  AC_MSG_RESULT([no])
  AC_MSG_ERROR([suitable Widget set could not be found])
fi
AC_SUBST(XTOOLKIT_CFLAGS)
AC_SUBST(XTOOLKIT_LIBS)
])
