/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)

 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/lib/bpsmalloc.c,v 1.3 2005/02/09 02:50:44
orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "libbps.h"

/*************************************************
 *                                               *
 *  Back Propergation Simurator(BPS)             *
 *        subroutine package                     *
 *      Version                                  *
 *        coded    in Jul.29 1989                *
 *    coded by   Y.Okamura                       *
 *    last modified  in Nov.15 1990              *
 *    modified by  K.Kuroda                      *
 *                                               *
 *************************************************
 *                                               *
 *       filename charfunc.c                     *
 *            characteristic functions           *
 *                                               *
 *************************************************/

#ifdef __cplusplus
extern "C" {
#endif

static double d_sig(double x);
/* static double Linear(double x); */
/* static double d_lin(double x); */


/************************************************
  calculate sigmoid function
  input :  
      x : argument of sigmoid function
  ************************************************/
double Sigmoid(double x)
{
  double  y;

  if ( x > 300.0 )
    y = 1.0;
  else 
    y = ( x < -300.0 ) ? 0.0 : 1.0/(1.0+exp(-x));

  return y;
}


/************************************************
  calculate sigmoid's differential
  input :
  x : argument of sigmoid diff.
  ************************************************/
static double d_sig(double x)
{
  double  y, z;

  z = Sigmoid(x);
  y = z*(1.0-z);

  return y;
}


/************************************************
  calculate linear function
  input :
  x : argument of linear func.
  ************************************************/
/*
static double Linear(double x)
{
  return x;
}
*/


/************************************************
  calculate linear differential
  input :
  x : argument of liner diff.
  ************************************************/
/*
static double d_lin(double x)
{
  return (double)1.0;
}
*/


/************************************************
  character function selector
  iputs:
  function : character function
  S : sigmoid
  L : linear
  in_data  : argument of character function
  return:
  result of character funciton
  ************************************************/
double FuncSelect(int function, double in_data)
{
  double   result;

  switch(function){
  case BPS_BIAS_SIGMOID:  result = Sigmoid(in_data); break;
  case BPS_BIAS_LINEAR:   result = in_data; /* Linear(in_data); */ break;
  default:       
		return 110; /* Unknown Function */
  }
  return result;
}


/************************************************
  differential of character function selector
  iputs:
  function : character function
  S : sigmoid
  L : linear
  in_data  : argument of character function
  return:
  result of character funciton
  ************************************************/
double DiffSelect(int function, double in_data)
{
  double  result;

  switch(function){
  case BPS_BIAS_SIGMOID:   result = d_sig( in_data );    break;
  case BPS_BIAS_LINEAR:    result = 1.0; /* d_lin( in_data ); */  break;
  default:
		return 110; /* Unknown Function */
  }
  return result;
}

#ifdef __cplusplus
}
#endif
