/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/errload.cpp,v 1.7 2005/02/22 07:39:14 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
 *						*
 *	Back Propergation Simurator(BPS)	*
 *	      subroutine package		*
 *	  coded		in Aug.27 1990		*
 *	  coded by	K.Kuroda		*
 *						*
 *************************************************
 *						*
 *	filename errload.c			*
 * 	   BPS ERRLOAD command			*
 *						*
 ************************************************/

#ifdef __cplusplus
extern "C" {
#endif

static int  idx[MAX_INDEX];

/***********************************************
  load data from error file
  ***********************************************/
DLLEXPORT int mod_bps_errload()
{
  int      i, j, unum, hist_num, num_rec;
  char     iteration, unit_num;
	char    *str1, *str2;
  int      p_unum, p_hist_num;
  Header   header;
  Buffer  *Data;
  float   *dum;
  int      bufsiz;

  rebps();

  /* Get Arguments from SATELLITE Language */
  p_hist_num = (int)GetScalar(0);
  p_unum     = (int)GetScalar(1);

	str1 = GetString(0);
  if(str1 == NULL)
		return 2; /* illegal parameter */
  iteration = *str1;
	str2 = GetString(1);
  if(str2 == NULL)
		return 2; /* illegal parameter */
  unit_num  = *str2;

  strcpy(bps_cont.bps_sp.FileName, GetString(2));

  GetStructureParameters();
  GetLearningParameters();

  if (bps_cont.ErrStorDirection == BPS_STOREDIR_DATAPOINT) {
    if ((iteration == 'x') || (iteration == 'X')) {
      if ((unit_num != 's') && (unit_num != 'S'))
	      return 130; /* Illigal Unit No. */
      if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
				return 11; /* Illigal File No. */

      dum = (float*)_ReadFile(bps_cont.bps_sp.FileName, &header);
      printf("header.index[0] = %d\n",header.index[0]);
      printf("header.index[1] = %d\n",header.index[1]);
      if(header.index[0] != 1)
				return 130; /* Illigal Unit No. */
      Data = (Buffer*)AllocBuffer(header.index[1]);
	    
      for(i=0; i<header.index[1]; i++)
	      Data[i] = (double)dum[i];
		
      message_1d_after("ERROR");

      idx[0] = header.index[1];
      ReturnSnapshot(Data, 1, idx);
      efree(dum);
      efree(Data);
    } else {
      hist_num = p_hist_num;
      if ((unit_num != 's') && (unit_num != 'S'))
	      return 130; /* Illigal Unit No. */
      if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
				return 11; /* Illigal File No. */

      dum = (float*)_ReadFile(bps_cont.bps_sp.FileName, &header);
      Data = AllocBuffer(1);
      Data[0] = (double)dum[hist_num - 1];
	    
      idx[0] = 1;
      ReturnSnapshot(Data, 1, idx);
      message_1d_after("ERROR");
      efree(dum);
      efree(Data);
    }
  } 

  else {			/*  ErrStorDirection ==>  Record    */
    if (bps_cont.ErrStorMode == BPS_STOREMODE_APPEND) {
      if ((iteration == 'x') || (iteration == 'X')) {
	      if ((unit_num == 'y') || (unit_num == 'Y')) {
	        if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
						return 11; /* Illigal File No. */

	        idx[0] = header.index[1];
	        idx[1] = header.index[0];

	        message_2d_before(idx);
	        dum = (float*)_ReadFile(bps_cont.bps_sp.FileName, &header);
	        Data = AllocBuffer(IndexSize(2, idx));

	        for(i=0; i<idx[0]; i++){
	          for(j=0; j<idx[1]; j++){
	            *(Data+i*idx[1]+j) = (double)*(dum+j*idx[0]+i);
	          }
	          message_2d_after(i, "ERROR");
	        }
	        ReturnSnapshot(Data, 2, idx);
	        efree(dum);
	        efree(Data);
	        printf("\n");
	      } 

	      else {			/* Record APPEND   iteration == X   */

	        if ((unit_num == 's') || (unit_num == 'S')) {
	          unum = bps_cont.NumOfCell[bps_cont.NumOfLayer - 1] + 1;
	          printf("unit_num = s\n");
				  } else {
	          unum = p_unum;
	          if ((unum < 0) || (unum > bps_cont.NumOfCell[bps_cont.NumOfLayer - 1]))
	            return 130; /* Illigal Unit No. */
	        }

	        if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
						return 11; /* Illigal File No. */
	        dum = (float*)_ReadFile(bps_cont.bps_sp.FileName, &header);
	        idx[0] = header.index[0];
	        Data = AllocBuffer(IndexSize(1, idx));

	        for(i=0; i<header.index[0]; i++){
	          *(Data+i) = *(dum+i*header.index[1]+unum-1);
	        }
	        message_1d_after("ERROR");
	        ReturnSnapshot(Data, 1, idx);
	        efree(dum);
	        efree(Data);
	      }

      } else {			/* APPEND */
	      if ((iteration == 'y') || (iteration == 'Y')) {
	        if ((unit_num != 'x') && (unit_num != 'X'))
	          return 130; /* Illigal Unit No. */
	        if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
						return 11; /* Illigal File No. */

	        idx[0] = header.index[0];
	        idx[1] = header.index[1];

      	  message_2d_before(idx);
	        dum = (float*)_ReadFile(bps_cont.bps_sp.FileName, &header);
	        Data = AllocBuffer(IndexSize(2, idx));

	        bufsiz = IndexSize(2, idx);
	        for(i=0; i<bufsiz; i++){
	          Data[i] = (double)dum[i];
	        }
	        message_2d_after(idx[0], "ERROR");
	        printf("\n");
	        ReturnSnapshot(Data, 2, idx);
	        efree(dum);
	        efree(Data);
	      } 
	      else {			/* iteration != X or Y */ 
	        hist_num = p_hist_num;
	        if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
						return 11; /* Illigal File No. */
	        num_rec = header.index[0];

      	  if ((hist_num < 1) || (hist_num > num_rec))
      	    return 130; /* Illigal Unit No. */
	        if ((unit_num == 'x') || (unit_num == 'X')) {
      	    idx[0] = header.index[0];
      	    dum = (float*)LoadData(bps_cont.bps_sp.FileName, hist_num - 1, &header);
      	    Data = AllocBuffer(IndexSize(1, idx));
      	    for(i=0; i<idx[0]; i++){
	            Data[i] = (double)dum[i];
	          }
	          ReturnSnapshot(Data, 1, idx);
	          FreeData(dum);
	          efree(Data);
	          message_1d_after("ERROR");

	        } else {
	          if ((unit_num == 's') || (unit_num == 'S')) {
	            unum = bps_cont.NumOfCell[bps_cont.NumOfLayer - 1] + 1;
	          } else {
	            unum = p_unum;
	            if ((unum < 0) || (unum > bps_cont.NumOfCell[bps_cont.NumOfLayer - 1]))
		            return 130; /* Illigal Unit No. */
	          }
	          idx[0] = 1;
	          if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
							return 11; /* Illigal File No. */
	          dum = (float*)LoadData(bps_cont.bps_sp.FileName, hist_num - 1, &header);
	          Data = AllocBuffer(IndexSize(1, idx));
	          Data[0] = (double)dum[unum - 1];
	          message_1d_after("ERROR");
	          ReturnSnapshot(Data, 1, idx);
	          FreeData(dum);
	          efree(Data);
	        }
	      }
      }
    } else {
      if (bps_cont.ErrStorMode == BPS_STOREMODE_OVERWRITE) {
	      hist_num = p_hist_num;
	      if (hist_num != 1)
	        return 131; /* Illigal History No. */
	      if ((unit_num == 'x') || (unit_num == 'X')) {
	        if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
						return 11; /* Illigal File No. */

	        idx[0] = header.index[1];
	        dum = (float*)LoadData(bps_cont.bps_sp.FileName, 0, &header);
	        Data = AllocBuffer(IndexSize(1, idx));

      	  for(i=0; i<idx[0]; i++){
	          Data[i] = (double)dum[i];
	        }
	        message_1d_after("ERROR");
	        ReturnSnapshot(Data, 1, idx);
	        FreeData(dum);
	        efree(Data);

	      } else {
	        if ((unit_num == 's') || (unit_num == 'S')) {
	          unum = bps_cont.NumOfCell[bps_cont.NumOfLayer - 1] + 1;
	        } else {
	          unum = p_unum;
	          if ((unum < 0) || (unum > bps_cont.NumOfCell[bps_cont.NumOfLayer - 1]))
	            return 130; /* Illigal Unit No. */
	        }
	        if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
						return 11; /* Illigal File No. */

	        idx[0] = 1;
	        dum = (float*)LoadData(bps_cont.bps_sp.FileName, 0, &header);
	        Data = AllocBuffer(IndexSize(1, idx));
	        Data[0] = (double)dum[unum - 1];
	        message_1d_after("ERROR");
	        ReturnSnapshot(Data, 1, idx);
	        FreeData(dum);
	        efree(Data);
	      }
      } else
	      return 202; /* Unknown Store Mode */
    }
  }

  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif