/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/lalgo.cpp,v 1.4 2005/02/21 11:53:13 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version                         *
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.2  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename lalgo.c                        *
*           BPS LALGO command                   *
*                                               *
************************************************/


/***********************************************
        get learning algorithm and
            learning rate parameters 
***********************************************/

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_bps_lalgo()
{
  int    nargs;
	int    anum;
  char  *str1;
  char   rem[100];
  char   learn_mode;

  rebps();

  nargs = GetArgNum();
  str1  = GetString(0);
  anum  = (int)GetScalar(1);

  if(str1 == NULL)
		return 2; /* illegal parameter */
	learn_mode = toupper(str1[0]);
  if ((learn_mode != BPS_LEARNMODE_SET) && 
      (learn_mode != BPS_LEARNMODE_PATTERN))
    return 202; /* Unknown Store Mode */
  bps_cont.bps_sp.LearnMode = learn_mode;

  if ((anum < BPS_LEARNALGO_STEEP) || (anum > BPS_LEARNALGO_OCHI))
    return 210; /* Unknown Algorithm */
  bps_cont.bps_sp.LearnAlgo = anum;

  bps_cont.bps_sp.LearnRate = GetScalar(2);

  if ((bps_cont.bps_sp.LearnAlgo >= BPS_LEARNALGO_MOMENTUM) &&
      (bps_cont.bps_sp.LearnAlgo <= BPS_LEARNALGO_OCHI)) {
    if (nargs < 4) {
      printf("\tmonentum = %g\t", bps_cont.bps_sp.Momentum);
      if (fgets(rem, 100, stdin) != NULL)
        sscanf(rem, "%lf", &bps_cont.bps_sp.Momentum);
    } else
      bps_cont.bps_sp.Momentum = GetScalar(3);
  }
  /* modified by higashi */
  if (nargs >= 4 && bps_cont.bps_sp.LearnAlgo == BPS_LEARNALGO_MOMENTUM){
    bps_cont.bps_sp.StrLrnMode = (int)GetScalar(4);
    if (nargs < 6 && bps_cont.bps_sp.StrLrnMode !=0){
      printf("\tRamuda(for Struct Learning Param) = %f\t",
             bps_cont.bps_sp.Ramuda);
      if (fgets(rem, 100, stdin) != NULL)
        sscanf(rem, "%lf", &bps_cont.bps_sp.Ramuda);
    }else
      bps_cont.bps_sp.Ramuda = GetScalar(5);
  }
  /* end of modified */
  if (bps_cont.bps_sp.LearnAlgo == BPS_LEARNALGO_VOGL  ||
      bps_cont.bps_sp.LearnAlgo == BPS_LEARNALGO_JACOB ||
      bps_cont.bps_sp.LearnAlgo == BPS_LEARNALGO_OCHI) {

    if (nargs < 5) {
      printf("\tincreasing factor = %g\t", bps_cont.bps_sp.IncreaseFact);
      if (fgets(rem, 100, stdin) != NULL)
        sscanf(rem, "%lf", &bps_cont.bps_sp.IncreaseFact);
    } else
      bps_cont.bps_sp.IncreaseFact = GetScalar(4);

    if (nargs < 6) {
      printf("\treduction factor = %g\t", bps_cont.bps_sp.ReductFact);
      if (fgets(rem, 100, stdin) != NULL)
        sscanf(rem, "%lf", &bps_cont.bps_sp.ReductFact);
    } else /* nargs > 5 */
      bps_cont.bps_sp.ReductFact = GetScalar(5);
  }

  switch (bps_cont.bps_sp.LearnAlgo) {
  case BPS_LEARNALGO_VOGL:
    if (nargs < 7) {
      printf("\tthreshold for Vogl method = %f\t", bps_cont.bps_sp.VoglThresh);
      if (fgets(rem, 100, stdin) != NULL)
        sscanf(rem, "%lf", &bps_cont.bps_sp.VoglThresh);
    } else
      bps_cont.bps_sp.VoglThresh = GetScalar(6);
    break;

  case BPS_LEARNALGO_OCHI:
    if (nargs < 7) {
      printf("\tTheta(for Ochiai's method) = %f\t", bps_cont.bps_sp.Theta);
      if (fgets(rem, 100, stdin) != NULL)
        sscanf(rem, "%lf", &bps_cont.bps_sp.Theta);
    } else
      bps_cont.bps_sp.Theta = GetScalar(6);
    /* modified by higashi             */
    if (nargs > 7){
      bps_cont.bps_sp.StrLrnMode = (int)GetScalar(7);
      if (nargs == 8 && bps_cont.bps_sp.StrLrnMode !=0){
        printf("\tRamuda(for Struct Learning Param) = %f\t",
               bps_cont.bps_sp.Ramuda);
        if (fgets(rem, 100, stdin) != NULL)
          sscanf(rem, "%lf", &bps_cont.bps_sp.Ramuda);
      }else
        bps_cont.bps_sp.Ramuda = GetScalar(8);
      break;
    }
  }
/* ----------- end of modified ------------ */
  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif
