/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/libbps.h,v 1.15 2005/04/04 08:37:37 orrisroot Exp $ */

#ifndef _LIBBPS_H_
#define _LIBBPS_H_

#ifdef  LIBPS_EXTERN
# undef LIBPS_EXTERN
#endif

#ifdef _LIBBPS_GLOBAL_VARS_
# define LIBBPS_EXTERN
#else
# define LIBBPS_EXTERN  extern 
#endif

#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

#define BPS_CONTEXT_FILE       "BPS"

#define BPS_MAX_LAYER     10
#define	BPS_LAST           0
#define	HBUFSIZE        4096

/* bias function */
#define BPS_BIAS_SIGMOID        'S'
#define BPS_BIAS_LINEAR         'L'
/* initialize algorism */
#define BPS_INITALGO_RANDUM     'R'
#define BPS_INITALGO_JIA        'J'
/* data store mode */
#define BPS_STOREMODE_APPEND    'A'
#define	BPS_STOREMODE_NO_APPEND	'N'
#define BPS_STOREMODE_OVERWRITE 'O'
/* data store direction */
#define BPS_STOREDIR_RECORD     'R'
#define BPS_STOREDIR_DATAPOINT  'D'
/* learn mode */
#define BPS_LEARNMODE_SET       'S'
#define BPS_LEARNMODE_PATTERN   'P'
/* learn algorism */
#define BPS_LEARNALGO_STEEP      1
#define BPS_LEARNALGO_MOMENTUM   2
#define BPS_LEARNALGO_VOGL       3
#define BPS_LEARNALGO_JACOB      4
#define BPS_LEARNALGO_MOMENTUM2  5
#define BPS_LEARNALGO_OCHI       6

/* trace */
#define BPS_TRACEMODE_COLOR             1
#define BPS_TRACEMODE_SIZE              2
#define BPS_TRACEMODE_NETWORK_FUNCTION  3
#define BPS_TRACEMODE_NETWORK_ONLY      4

/* To structure learning */
#define BPS_STRLRNMODE_PLAUT            1
#define BPS_STRLRNMODE_ISHIKAWA         2
#define BPS_STRLRNMODE_YASUI            3

#define Getintoplist(point)   ((point)->InTopList)
#define Getinfwdlist(point)   ((point)->InFwdList)
#define Getinbwdlist(point)   ((point)->InBwdList)
#define Getouttoplist(point)  ((point)->OutTopList)
#define Getoutfwdlist(point)  ((point)->OutFwdList)
#define Getoutbwdlist(point)  ((point)->OutBwdList)
#define Getouttolist(point)   ((point)->OutToList)
#define CheckBias(lno)  (bps_cont.FuncBias[(lno)][1] == BPS_STOREMODE_APPEND)

/* System Parameter */
typedef struct  _bps_pr_t {
  int    NumOfLayer;                  /* number of layer */
  int    NumOfCell[BPS_MAX_LAYER];    /* number of each layer's cell */
  char   FuncBias[BPS_MAX_LAYER][5];  /* status of char.func and bias */
  char   InitAlgo;                    /* initialize algorithm */
  char   InitWgtFile[FILE_LENGTH];    /* initialize data file name made
                                         by init. command */
  int    Seed;                        /* seed */
  double MaxInitWgt;                  /* maximum of initialize data */
  double MinInitWgt;                  /* minimum of initialize data */
  char   LearnMode;                   /* learning mode */
  int    LearnAlgo;                   /* learning algorithm */
  char   LrnInitWgtFile[FILE_LENGTH]; /* initialize weight for learn command */
  char   WgtHistoryFile[FILE_LENGTH]; /* weight history file name */
  int    WgtStorInterval;             /* weight store interval */
  char   WgtStorMode;                 /* weight history store mode */
  char   ErrHistoryFile[FILE_LENGTH]; /* error history file name */
  int    ErrStorInterval;             /* error store interval */
  char   ErrStorDirection;            /* store direction for error */
  char   ErrStorMode;                 /* store mode for error */
  char   InputFile[FILE_LENGTH];      /* input data file name for learning */
  char   TeachFile[FILE_LENGTH];      /* teach data file name for learning */
  int    LrnFirstPtrn;                /* first pattern number of learning */
  int    LrnLastPtrn;                 /* last pattern number of learning */
  double LearnRate;                   /* learning rate */
  double Momentum;                    /* momentum */
  double IncreaseFact;                /* increasing factor for learn. rate */
  double ReductFact;                  /* reduction factor for learn. rate */
  double VoglThresh;                  /* threshold for Vogl method */
  double Theta;                       /* for Ochiai's method */
  double MinError;                    /* min. error for end */
  int    MaxLearnCount;               /* max. learn count for end */
  int    DisplayInterval;             /* display interval (console) */
  char   Comment[FILE_LENGTH];        /* comment */
  char   TestWgtFile[FILE_LENGTH];    /* weight file name for test */
  int    WgtHistoryNo;                /* weight history number */
  char   TestFile[FILE_LENGTH];       /* test data file name */
  int    TestFirstPtrn;               /* first pattern number of test */
  int    TestLastPtrn;                /* last pattern number of test */
  int    InputLayer;                  /* input layer No. */
  int    OutputLayer;                 /* output layer No. */
  char   ActFile[FILE_LENGTH];        /* result file name */
	char   FileName[FILE_LENGTH];
  /* structure learing Parameters     */
  /* modified by higashi */
  int    StrLrnMode;                  /* structure learning mode */
  double Ramuda;                      /* Structure Learning Param */
  /* end of modified */
} bps_pr_t;

/* NETWORK STRUCTURE */
typedef struct  _bps_cel_t {          /* cell node */
  struct _bps_ilin_t  *InTopList;     /* pointer to inp. link list */
  struct _bps_olin_t  *OutTopList;    /* pointer to outp. link list */
  char           CharFunc;            /* characteristic function */
  double         Active;              /* cell activation */
  double         Delta;               /* work for weight adjust(delta)*/
  double         Net;                 /* sum of all inputs */
  int            SelFlg;              /* for BPTRC */
} bps_cel_t;

typedef struct _bps_ilin_t {          /* node of cell inputs list */
  struct _bps_ilin_t  *InFwdList;     /* pointer to foward link list */
  struct _bps_ilin_t  *InBwdList;     /* pointer to backward link list */
  struct _bps_cel_t    *InputCell;    /* input from */
  struct _bps_cel_t    *NodeCell;     /* top of this list */
  double         Weight;              /* weight for link */
  double         AdjWgt;              /* work for weight adjust */
  double         WgtWork;             /* work for weight adjust */
  double         CoefLearn;           /* learning factor(eta) */
  double         dltold;              /**************************************/
  double         dltwgtold;           /*                                    */
  double         wgtworkold;          /*      for Ochiai's method           */
  double         dltwork;             /*                                    */
  double         dltworkold;          /**************************************/
} bps_ilin_t;

typedef struct _bps_olin_t {         /* node of cell outputs list */
  struct _bps_olin_t  *OutFwdList;   /* pointer to forward list */
  struct _bps_olin_t  *OutBwdList;   /* pointer to backward list */
  struct _bps_ilin_t  *OutToList;    /* output to */
} bps_olin_t;

typedef struct _bps_lay_t {           /* layer information for BP model*/
  int            CellNo;              /* cell number */
  struct _bps_cel_t    *CellNode;     /* pointer to cell node */
} bps_lay_t;

typedef struct _bps_context_t {
  bps_pr_t    bps_sp;
  bps_lay_t  *BPNet[BPS_MAX_LAYER];
  /* GLOBAL VARIABLES */
  int        NumOfLayer;                  /* number of layer */
  int        NumOfCell[BPS_MAX_LAYER];    /* number of each layer's cell    */
  char       FuncBias[BPS_MAX_LAYER][5];  /* status of char.func and bias */
  int        NumOfPtrn;                   /* number of pattern */
  float      MinScale;                    /* minimum scale */
  float      MaxScale;                    /* maximum scale */
  int        DisplayMode;                 /* display mode */
  /* GLOBAL VARIABLES FOR HISTORY FILE HANDLE */
  float     *ErrBuffer;                   /* error history output buffer */
  double    *buff_err;                    /* error history (buffer), used 
                                             only in learn and learn lib */
  float    **InputData;                   /* input data for learning */
  float    **TeachData;                   /* teach data for learning */
  int        NumOfLink;                   /* num. of all link */
  /* GLOBAL VARIABLES FOR INITIALIZE */
  char       InitAlgo;                    /* initialize algorithm */
  char       InitWgtFile[FILE_LENGTH];    /* initialize weight file name
                                              for initialize */
  int        Seed;                        /* seed */
  double     MaxInitWgt;                  /* maximum of initialize data */
  double     MinInitWgt;                  /* minimum of initialize data */
  /* GLOBAL VARIABLES FOR LEARN */
  char       LrnInitWgtFile[FILE_LENGTH]; /* initialize weight for 
                                                 learning */
  char       WgtHistoryFile[FILE_LENGTH]; /* weight history file name */
  int        WgtStorInterval;             /* weight store interval */
  char       WgtStorMode;                 /* store mode for weight */
  char       ErrHistoryFile[FILE_LENGTH]; /* error histoy file name */
  int        ErrStorInterval;             /* error store interval */
  char       ErrStorDirection;            /* store direction for error */
  char       ErrStorMode;                 /* store mode for error */
  char       InputFile[FILE_LENGTH];      /* input data file name for 
                                             learning */
  char       TeachFile[FILE_LENGTH];      /* teach data file name for
                                             learning */
  int        LrnFirstPtrn;                /* first pattern number of learning
                                             (0:all) */
  int        LrnLastPtrn;                 /* last pattern */
  char       LearnMode;                   /* learning mode */
  char       LearnAlgo;                   /* learning algorithm */
  double     LearnRate;                   /* learning rate */
  double     Momentum;                    /* momentum */
  double     ReductFact;                  /* reduction factor for learn.
                                             rate */
  double     IncreaseFact;                /* increasing factor for learn. 
                                             rate */
  int        VglCoef[FILE_LENGTH];        /* Vogl coefficient for moment2 */ 
  double     InitMoment;                  /* initial momentum */
  double     VoglThresh;                  /* threshold for Vogl method */
  double     Theta;                       /* for Ochiai's method */
  double     SumOfErr;                    /* sum of learning error */
  double    *OutCellErr;                  /* error for output cell */
  double     MinError;                    /* min. error for end */
  int        MaxLearnCount;               /* max. learn count for end */
  int        DisplayInterval;             /* display interval (console) */
  char       Comment[FILE_LENGTH];        /* comment */
  /* GLOBAL VARIABLES FOR TEST */
  char       TestWgtFile[FILE_LENGTH];    /* weight file name for test */
  int        WgtHistoryNo;                /* weight history number */
  char       TestFile[FILE_LENGTH];       /* test data file name */
  int        TestFirstPtrn;               /* first pattern number of test */
  int        TestLastPtrn;                /* last pattern number of test */
  int        InputLayer;                  /* input layer No. */
  int        OutputLayer;                 /* output layer No. */
  char       ActFile[FILE_LENGTH];        /* result file name */
  float     *act_buf;                     /* activation buffer */
} bps_context_t;

LIBBPS_EXTERN bps_context_t bps_cont;

/* context.c */
int bps_context_init();
int bps_context_clean();

/* bpsmalloc.c */
char **bps_malloc2D(int n, int m, size_t sz);
void   bps_free2D(char **data);

/* rwbps.c */
int rebps();
int wrbps();

/* charfunc.c */
double  Sigmoid(double x); /* sigmoid.cpp */
double  FuncSelect(int function, double in_data);
double  DiffSelect(int function, double in_data);

/* getparam.c */
void GetStructureParameters();
int  PrintStructureParameters();
void GetInitializeParameters();
int  PrintInitializeParameters();
int  GetLearningParameters();
int  PrintLearningParameters();
int  GetTestingParameters();
int  PrintTestingParameters();

/* filehndl.c */
void SetNumOfLink();
int  GetNumOfRecord(const char *filename);
int  LastWgtHistory(const char *filename);
int  NextWgtHistory(const char *filename);
int  NextErrHistory(const char *filename);
void CleanHistArray(float *hist_arry);
int  ReadData(const char *filename, float **data, int first_ptrn,
                         int last_ptrn, int num_cell);
void WriteWeight2(const char *filename, int hist_no,  double *data);
int  StoreWeight2(const char *filename, int wgt_stor_cnt);
void WriteErrDataPoint(const char *filename, int hist_no, int position,
                       double data);
void WriteErrRecord(const char *filename, int hist_no);
void StoreErrRecord(const char *filename, int err_stor_cnt);
void WriteActivation(int hist_no);
int  StoreOldError(const char *filename, int hist_no);
int  CreateFile1(const char *filename, const char *temp);
int  CreateFile2(const char *filename, const char *temp, int stor_mode);
void CreateFile3(const char *filename, const char *temp, int stor_mode);

/* nethndl.c */
bps_ilin_t *inter_ilin(bps_cel_t *from_cell, bps_cel_t *to_cell);
bps_olin_t *inter_olin(bps_cel_t *from_cell, bps_cel_t *to_cell);
int        SetWeight(bps_cel_t *from_cell, bps_cel_t *to_cell, double weight);
int        SetDeltaWgt(bps_cel_t *from_cell, bps_cel_t *to_cell, 
                        double deltaw);
/* double      GetWeight(bps_cel_t *from_cell, bps_cel_t *to_cell); */
bps_cel_t  *make_cell();
int        Connect(bps_cel_t *from_cell, bps_cel_t *to_cell);
int        MakeNetwork();
void       BreakNetwork();
int        ReadWeight2(const char *filename, int hist_no);
void       netdump();
/* int        cut(bps_cel_t *from_cell, bps_cel_t *to_cell); */

/* learnlib.c */
void   workspace_initialize();
int    system_initialize();
void   system_end();
double forward_learn(float *inputdata, float *teachdata);
void   backward_learn();
double set_learn(int lrn_mode);

/* reclib.c */
int    rec_system_initialize();
void   rec_system_end();
void   test_network(float in_data[]);

/* in wgtrenew.c */
void    steep();
void    momentum1();
void    vogl();
void    jacobs();
void    vgl2_coe();
void    momentum2();
void    Ochi();

/* loadlib.c */
void  message_2d_before(int *idx);
void  message_2d_after(int i, char obj[]);
void  message_1d_after(char obj[]);

#ifdef __cplusplus
}
#endif

#endif /* _LIBBPS_H_ */

