/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/loadlib.cpp,v 1.5 2005/02/22 04:32:19 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
 *						*
 *	Back Propergation Simulator(BPS)	*
 *	      subroutine package		*
 *	  coded 	in Oct.8 1990		*
 *	  coded by	K.Kuroda		*
 *						*
 *************************************************
 *						*
 *	filename tracelib.c			*
 *						*
 ************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* char  FileName[FILE_LENGTH]; */

#if 0
/************************************************
  check of buffer number, file number
  and file type
  ************************************************/
int
check(int buff_dim)
{
  Header head;

  if (LoadHeader(bps_cont.bps_sp.FileName, &head) == -1)
    return 11; /* Illigal File No. */

	return 0;
}
#endif


/************************************************
  message 2dim ( before )
  ************************************************/
void
message_2d_before(int *idx)
{
  int  i;

  printf("  ### Snapshot : %d-Dimension ", 2);
  for (i = 0; i < 2; i++)
    printf("[%d]", idx[i]);
  printf(" ###\n");

  printf("  ### FILE NAME [ %s ] ==> 2D Snapshot ###\n", bps_cont.bps_sp.FileName);
}


/************************************************
  message 2dim ( after )
  ************************************************/
void
message_2d_after(int i, char obj[])
{
  printf("      %s ==> INDEX [ %d ] \r", obj, i+1);
  fflush(stdout);
}


/************************************************
  message 1dim ( after )
  ************************************************/
void
message_1d_after(char obj[])
{
  printf("  ### FILE NAME [ %s ] : %s ==> Snapshot ###\n", bps_cont.bps_sp.FileName, obj);
}

#ifdef __cplusplus
}
#endif