/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/rvmap.cpp,v 1.8 2005/02/22 04:32:19 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_IO_H
# include <io.h>
#endif

#include "libbps.h"

/************************************************
* 						*
*	Back Propergation Simurator(BPS)	*
*	      subroutine package		*
*	        Version	        	 	*
*	  coded		in Oct.11 1989		*
*	  coded by 	K.Kuroda	 	*
*						*
*************************************************
*						*
*	filename rvmap.c			*
*	   reverce mapping			*
*						*
************************************************/

#ifdef __cplusplus
extern "C" {
#endif

static int     outlay_num, inlay_num, hist_num, buff_num;


/***********************************************
 * set parameters
 ***********************************************/
int
set_param_rvmap()
{
  outlay_num = (int)GetScalar(0);
  inlay_num  = (int)GetScalar(1);
  hist_num   = (int)GetScalar(2);
  buff_num   = (int)GetScalar(3);

  if (outlay_num <= inlay_num)
		return 21; /* Illigal Unit No. */
  if ((outlay_num >= bps_cont.NumOfLayer) || (outlay_num < 0))
		return 22; /* Unknown Mode */
  if ((inlay_num < 0) || (inlay_num >= bps_cont.NumOfLayer))
		return 23; /* Can't Allocate To Array */

	return 0;
}


/***********************************************
 * calculate weight block size
 ***********************************************/
void
cal_blk_siz()
{
  SetNumOfLink();

  /*  WgtBlockSize = NumOfLink / HBUFSIZE;
      if ((NumOfLink % HBUFSIZE) != 0)
      WgtBlockSize++; */
}


/************************************************
 * main routine
 ************************************************/
DLLEXPORT int mod_bps_rvmap()
{
  int      i, j, k, m;
  float   *wdata, sum_wgt;
  float  **rvdata1 = NULL, **rvdata2 = NULL, **rvdata3 = NULL;
  bps_cel_t   *cell_pt;
  bps_ilin_t  *cur_ilin;
  Header   header;
  double  *dum;
  int      idx[10];
  
  /* GET PARAMETERS */
  rebps();

  GetStructureParameters();
  GetLearningParameters();
  set_param_rvmap();
  
  if (access(bps_cont.WgtHistoryFile, 0) == -1) {
    printf("\nERROR. File [ %s ] is not exist.\n", bps_cont.WgtHistoryFile);
    return -1;
  }
  cal_blk_siz();
  
  if (LoadHeader(bps_cont.WgtHistoryFile, &header) == -1)
    return 11; /* Illigal File No. */
  
  if ((hist_num < 0) || (hist_num > header.index[0])) {
    printf("ERROR : weight history number error.\n");
    return -1;
  }
  if (hist_num == 0)
    hist_num = LastWgtHistory(bps_cont.WgtHistoryFile) + 1;
  
  /* set weight data in BPNet */
  MakeNetwork();
  
  wdata = (float*)LoadData(bps_cont.WgtHistoryFile, hist_num - 1, &header);
  if (wdata == NULL)
		return 730;
  
  printf("hist_num   = %d\n", hist_num);
  printf("bps_cont.NumOfLayer = %d\n", bps_cont.NumOfLayer);
  
  k = 0;
  for (i = 1; i < bps_cont.NumOfLayer; i++) {
    for (j = 1; j <= bps_cont.NumOfCell[i]; j++) {
      if (CheckBias(i))
        SetWeight(bps_cont.BPNet[i][0].CellNode, bps_cont.BPNet[i][j].CellNode,
		          (double)wdata[k++]);
      for (m = 1; m <= bps_cont.NumOfCell[i - 1]; m++)
        SetWeight(bps_cont.BPNet[i - 1][m].CellNode, bps_cont.BPNet[i][j].CellNode,
		          (double)wdata[k++]);
    }
  }

  /* set rvdata1 */
  rvdata1 = (float**)bps_malloc2D(bps_cont.NumOfCell[outlay_num],
			      bps_cont.NumOfCell[outlay_num-1]+1, sizeof(float));
  if (rvdata1 == NULL) {
    printf("ERROR: Can't allcate to rvdata1.\n");
		return 1; /* Command Not Found */
  }

  k = (CheckBias(outlay_num)) ? 0 : 1;

  for (i = 0; i < bps_cont.NumOfCell[outlay_num]; i++) {
    cur_ilin = Getintoplist(bps_cont.BPNet[outlay_num][i+1].CellNode);

    m = k;
    while (cur_ilin != NULL) {
      cell_pt       = cur_ilin->InputCell;
      rvdata1[i][m] = (float)(cur_ilin->Weight);
      m++;
      /*
       * printf("rvdata1[%d][%d] = %f ",i,m-1,rvdata1[i][m-1]);
       */
      cur_ilin = Getinfwdlist(cur_ilin);
    }
  }
  
  /* calculate reverse mapping */
  for (i = outlay_num - 1; i > inlay_num; i--) {
    k = (CheckBias(i)) ? 0 : 1;

    /* set rvdata2 */
    if ( rvdata2 != NULL ) bps_free2D((char**)rvdata2);
    rvdata2 = (float**)bps_malloc2D(bps_cont.NumOfCell[i], bps_cont.NumOfCell[i-1]+1, sizeof(float));
    if (rvdata2 == NULL) {
      printf("ERROR: Can't allcate to rvdata2.\n");
			return 1; /* Command Not Found */
    }

    for (j = 0; j < bps_cont.NumOfCell[i]; j++) {
      m = k;
      cur_ilin = Getintoplist(bps_cont.BPNet[i][j + 1].CellNode);
      
      while (cur_ilin != NULL) {
	cell_pt       = cur_ilin->InputCell;
	rvdata2[j][m] = (float)(cur_ilin->Weight);
	m++;
	/*
	 * printf("rvdata2[%d][%d] = %f ",j,m-1,rvdata2[j][m-1]);
	 */
	cur_ilin = Getinfwdlist(cur_ilin);
      }
    }
    
    /* calculate rvdata3 = rvdata1 * rvdata2 */
    if ( rvdata3 != NULL ) bps_free2D((char**)rvdata3);
    rvdata3 = (float**)bps_malloc2D(bps_cont.NumOfCell[outlay_num],
				bps_cont.NumOfCell[i-1]+1, sizeof(float));
    if (rvdata3 == NULL) {
      printf("ERROR: Can't allcate to rvdata3.\n");
			return 1; /* Command Not Found */
    }


    for (j = 0; j < bps_cont.NumOfCell[outlay_num]; j++) {
      for (k = 0; k < bps_cont.NumOfCell[i-1]; k++) {
	sum_wgt = 0.0;
	for (m = 0; m < bps_cont.NumOfCell[i]; m++)
	  sum_wgt += rvdata1[j][m+1] * rvdata2[m][k+1];

	rvdata3[j][k+1] = sum_wgt;

	/*
	 * printf("rvdata3[%d][%d] = %f ",j,k+1,rvdata3[j][k+1]);
	 */
      }
    }

    /* copy rvdata3 -> rvdata1 */
    if ( rvdata1 != NULL ) bps_free2D((char**)rvdata1);
    rvdata1 = (float**) bps_malloc2D(bps_cont.NumOfCell[bps_cont.NumOfLayer-1],
				 bps_cont.NumOfCell[i-1]+1, sizeof(float));
    if (rvdata1 == NULL) {
      printf("ERROR: Can't allcate to rvdata1.\n");
      return 1; /* Command Not Found */
    }

    for (j = 0; j < bps_cont.NumOfCell[outlay_num]; j++)
      for (k = 0; k < bps_cont.NumOfCell[i-1]; k++)
	rvdata1[j][k+1] = rvdata3[j][k+1];
  }
  /* output buffer */
  
  dum    = AllocBuffer(bps_cont.NumOfCell[outlay_num]*bps_cont.NumOfCell[inlay_num]);
  idx[0] = bps_cont.NumOfCell[outlay_num];
  idx[1] = bps_cont.NumOfCell[inlay_num];
  
  for (i = 0; i < bps_cont.NumOfCell[outlay_num]; i++) {
    for (j = 0; j < bps_cont.NumOfCell[inlay_num]; j++){
      /* 䤷 by take
       dum[(j+i*NumOfCell[outlay_num])] = rvdata1[i][j + 1];
       */
      /* ֤󡤤E by take */
      dum[(j+i*bps_cont.NumOfCell[inlay_num])] = rvdata1[i][j + 1];
    }
    printf("  ### REVERCE MAPPING DATA ==> Series:[%d] ###\r", i);
    fflush(stdout);
  }

  ReturnSnapshot(dum, 2, idx);
  printf("\n");
  
  FreeData(wdata);
  efree(dum);
  bps_free2D((char**)rvdata1);
  bps_free2D((char**)rvdata2);
  bps_free2D((char**)rvdata3);
  BreakNetwork();
  return 0;
}

#ifdef __cplusplus
}
#endif
