/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/wgtset.cpp,v 1.4 2005/02/22 04:32:19 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/*************************************************
 *                                               *
 *       Back Propergation Simurator(BPS)        *
 *             subroutine package                *
 *         	Version            		 * 
 *	  coded		in Oct.10 1990		 *
 *         coded by 	K.Kuroda                 *
 *                                               *
 *************************************************
 *                                               *
 *       filename wgtset.c                       *
 *               initialize data set             *
 *               main routine                    *
 *                                               *
 ************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/************************************************
  main program
  ************************************************/

DLLEXPORT int mod_bps_wgtset()
{
  int     lay_no, unit_from, unit_to;
  float   weight;

  rebps();
  GetStructureParameters();
  GetInitializeParameters();

  /* get parameters */
  lay_no    =   (int)GetScalar(0);
  unit_from =   (int)GetScalar(1);
  unit_to   =   (int)GetScalar(2);
  weight    = (float)GetScalar(3);

  /* WgtMaxDataPoint = 0; no use */
  /* CleanHistArray(WgtOutData); no use*/

  SetNumOfLink();
  /* WgtBlockSize = NumOfLink / HBUFSIZE;
  if ((NumOfLink % HBUFSIZE) != 0)
    WgtBlockSize++; */

  MakeNetwork();
	
  ReadWeight2(bps_cont.InitWgtFile, 1);

  SetWeight(bps_cont.BPNet[lay_no][unit_from].CellNode,
	    bps_cont.BPNet[lay_no+1][unit_to].CellNode, weight);
  SetDeltaWgt(bps_cont.BPNet[lay_no][unit_from].CellNode,
	      bps_cont.BPNet[lay_no+1][unit_to].CellNode, 0.0);

  StoreWeight2(bps_cont.InitWgtFile, 1);

  BreakNetwork();
  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif