/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: buffer2avs.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#undef fprintf

#ifdef __cplusplus
extern "C" {
#endif

int MakeHeader(char *fname, int dim, int *index)
{
  int i;
  FILE *fp;
  char *headerfile;

  /* Header File Open */
  headerfile = (char *)malloc(strlen(fname)+5);
  sprintf(headerfile,"%s.fld",fname);
  fp=fopen(headerfile,"w");
  if(fp==NULL) return (2);

  /* Header Write */
  fprintf(fp,"# AVS field file\n");
  fprintf(fp,"#        genarated by SATELLITE\n");
  fprintf(fp,"#\n");
  fprintf(fp,"ndim = %d\n",dim);
  for ( i = 1 ; i <= dim ; i++ ){
    fprintf(fp,"dim%d = %d\n",i,index[i-1]);
  }
  fprintf(fp,"nspace = %d\n",dim);
  fprintf(fp,"veclen = 1\n");
  fprintf(fp,"data = double\n");
  fprintf(fp,"field = uniform\n");
  fprintf(fp,"variable 1 file=%s.data filetype=binary\n",fname);

  /* Header File Close */
  fclose(fp);
  free(headerfile);
  return 0;
}

DLLEXPORT int mod_dcm_buffer2avs(void)
{
  register int i,j,k;
  int dim,index[10],length;
  Buffer *data;
  char *fname,*datafile;
  FILE *fp;
  int stat;

  /* Get File name */
  fname=GetString(0);
  if(fname==NULL)
    return (1);

  /* Get Series Buffer */
  data=GetSeries(1,&dim,index);
  if(data==NULL)
    return (1);

  if(dim>4)
    return (6);

  length=IndexSize(dim,index);

  /* Genarate Header File */
  stat = MakeHeader(fname,dim,index);
  if(stat != 0) return stat;

  /* Data File Open */
  datafile  = (char *)malloc(strlen(fname)+6);
  sprintf(datafile, "%s.data",fname);

  fp=fopen(datafile,"w");
  if(fp==NULL) return (2);
  switch (dim) {
  case 1:
    for ( i = 0 ; i < index[0] ; i ++ ){
      fwrite(&data[i],sizeof(double),1,fp);
    }
    break;
  case 2:
    for ( j = 0 ; j < index[1] ; j ++ ) {
      for ( i = 0 ; i < index[0] ; i ++ ) {
	fwrite(&data[index[1]*i+j],sizeof(double),1,fp);
      }
    }
    break;
  case 3:
    for ( k = 0 ; k < index[2] ; k ++ ) {
      for ( j = 0 ; j < index[1] ; j ++ ) {
	for ( i = 0 ; i < index[0] ; i ++ ) {
	  fwrite(&data[index[2]*index[1]*k+index[1]*i+j],
		 sizeof(double),1,fp);
	}
      }
    }
    break;
  default:
    break;
  }

  /* Output File Close */
  fclose(fp);

  FreeBuffer(data);

  return 0;
}

#ifdef __cplusplus
}
#endif
