/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: buffer2gnuplot.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#undef fprintf
#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  int dim;
  int index[10];
  int length;
  Buffer *data;
} Buffer_Struct;

DLLEXPORT int mod_dcm_buffer2gnuplot()
{
  int i,j;
  Buffer_Struct *bs;
  char *fname;
  FILE *fp;

  /* Get Output File Name */
  fname=GetString(0);
  if(fname==NULL)
    return (1);

  /* Get Series Buffer */
  bs=(Buffer_Struct *)malloc(sizeof(Buffer_Struct));
  bs->data=GetSeries(1,&bs->dim,bs->index);
  if(bs->data==NULL){
    free(bs);
    return (1);
  } else {
    bs->length=IndexSize(bs->dim,bs->index);
    /* Data Dimension Chack */
    if(bs->dim<3)
      return (3);
  }

  /* Output File Open */
  fp=fopen(fname,"w");
  if(fp==NULL)
    return (2);

  /* Data Output */
  for(i=0;i<bs->index[0];i++){
    if(bs->dim==2){
      for(j=0;j<bs->index[1];j++){
	fprintf(fp,"%d %d %f\n",j,i,bs->data[i*bs->index[1]+j]);
      }
      fprintf(fp,"\n");
    } else {
      fprintf(fp,"%d %f\n",i,bs->data[i]);
    }
  }
    
  /* Output File Close */
  fclose(fp);

  /* Buffer Memory Free */
  FreeBuffer(bs->data);
  free(bs);

  return 0;
}

#ifdef __cplusplus
}
#endif
