/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: dcm_fifo.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdlib.h>
#include "dcm_fifo.h"

DCM_FIFO_CELL *DCM_FIFO_CELL_New(){
  DCM_FIFO_CELL *ret;
  ret=(DCM_FIFO_CELL*)malloc(sizeof(DCM_FIFO_CELL));
  if(ret==NULL) return NULL; /* Out of Memory */
  ret->data=0.0;
  ret->next=NULL;
  return ret;
}

DCM_FIFO *DCM_FIFO_New(){
  DCM_FIFO *ret;
  ret=(DCM_FIFO*)malloc(sizeof(DCM_FIFO));
  if(ret==NULL) return NULL; /* out of memory */
  ret->top=NULL;
  ret->last=NULL;
  ret->size=0;
  return ret;
}

void DCM_FIFO_Init(DCM_FIFO *fifo){
  DCM_FIFO_CELL *it;
  for(it=fifo->top;fifo->top!=NULL;it=fifo->top){
    fifo->top=it->next;
    free(it);
  }
  fifo->top=NULL;
  fifo->last=NULL;
  fifo->size=0;
}

void DCM_FIFO_Delete(DCM_FIFO *fifo){
  DCM_FIFO_Init(fifo);
  free(fifo);
}

void DCM_FIFO_push(DCM_FIFO *fifo, double d){
  DCM_FIFO_CELL *it;
  it=DCM_FIFO_CELL_New();
  if(fifo->size==0) fifo->top=it;
  else fifo->last->next=it;
  fifo->last=it;
  it->data=d;
  fifo->size++;
}

double DCM_FIFO_pop(DCM_FIFO *fifo, int *ret){
  double d;
  DCM_FIFO_CELL *it;
  it=fifo->top;
  if(fifo->size==0) return *ret = 9; /* illegal memory access */
  d=it->data;
  fifo->top=it->next;
  free(it);
  fifo->size--;
  *ret = 0;
  return d;
}

DCM_FIFO_LIST *DCM_FIFO_LIST_New(){
  DCM_FIFO_LIST *ret;
  ret=(DCM_FIFO_LIST*)malloc(sizeof(DCM_FIFO_LIST));
  if(ret==NULL) return NULL; /* out of memory */
  ret->top=NULL;
  ret->last=NULL;
  ret->size=0;
  return ret;
}

int DCM_FIFO_LIST_Add(DCM_FIFO_LIST *fifo_list, DCM_FIFO *add){
  DCM_FIFO_LIST_CELL *cell;
  cell=(DCM_FIFO_LIST_CELL*)malloc(sizeof(DCM_FIFO_LIST_CELL));
  if(cell==NULL) return 8; /* out of memory */
  cell->fifo=add;
  if(fifo_list->size==0){
    fifo_list->top=cell;
  }else{
    fifo_list->last->next=cell;
  }
  fifo_list->last=cell;
  cell->next=NULL;
  fifo_list->size++;
  return 0;
}

void DCM_FIFO_LIST_Delete(DCM_FIFO_LIST *fifo_list){
  unsigned long i;
  DCM_FIFO_LIST_CELL *it;
  for(i=0;i<fifo_list->size;i++){
    it=fifo_list->top;
    fifo_list->top=it->next;
    DCM_FIFO_Delete(it->fifo);
    free(it);
  }
  free(fifo_list);
}

DCM_FIFO *DCM_FIFO_LIST_Get(DCM_FIFO_LIST *fifo_list, unsigned long pos){
  unsigned long i;
  DCM_FIFO_LIST_CELL *it;
  if(pos>=fifo_list->size) NULL; /* illegal memory access */
  it=fifo_list->top;
  for(i=0;i<pos;i++){ it=it->next; }
  return it->fifo;
}

unsigned long DCM_FIFO_LIST_TotalSize(DCM_FIFO_LIST *fifo_list){
  unsigned long total;
  DCM_FIFO_LIST_CELL *it;
  total=0;
  for(it=fifo_list->top;it!=NULL;it=it->next){ total+=it->fifo->size; }
  return total;
}
  
