/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: genesis2buffer.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  float x,y,z;
} XYZCoord;

typedef struct {
  FILE *fp;
  char label[100];
  float start;
  float step;
  int  nx;
  int  ny;
  int  nz;
  int  ndata;
  int  datatype;
  int  header_size;
  XYZCoord *table;
} DiskOut_Header;


typedef struct {
  int id;
  int dim;
  int index[10];
  Buffer *data;
} Buffer_Struct;


int Read_FMT1_Header(DiskOut_Header *diskout){
  int i;
  XYZCoord temp;

  /* read in the file header */
  fread(diskout->label,sizeof(char),80,diskout->fp);

  /* check the label */
  if(strncmp("FMT1",diskout->label,4)){
    return(4);
  }

  /* starting time */
  fread(&diskout->start,sizeof(float),1,diskout->fp);
  printf("start time   : %e\n",diskout->start);

  /* time step */
  fread(&diskout->step,sizeof(float),1,diskout->fp);
  printf("step time    : %e\n",diskout->step);

  /* number of data points */
  fread(&diskout->ndata,sizeof(int),1,diskout->fp);
#ifdef _DEBUG_DCM
  printf("data points  : %d\n",diskout->ndata);
#endif
  /* data type */
  fread(&diskout->datatype,sizeof(int),1,diskout->fp);
#ifdef _DEBUG_DCM
  printf("data type    : %d\n",diskout->datatype);
#endif
  /* header size */
  diskout->header_size=2*sizeof(int)+2*sizeof(float)+80+
    diskout->ndata*sizeof(XYZCoord);
#ifdef _DEBUG_DCM
  printf("header size  : %d\n",diskout->header_size);
#endif
  diskout->table=(XYZCoord *)malloc(diskout->ndata*sizeof(XYZCoord));
  if(fseek(diskout->fp,(long)2*sizeof(int)+2*sizeof(float)+80,0) == -1){
    return 4;
  }
  if(fread(diskout->table,diskout->ndata*sizeof(XYZCoord),1,diskout->fp) == 0){
    return 4;
  }

  /* dimension check */
  diskout->nx=1;
  diskout->ny=1;
  diskout->nz=1;
  temp.x=diskout->table[0].x;
  temp.y=diskout->table[0].y;
  temp.z=diskout->table[0].z;
  for(i=1;i<diskout->ndata;i++){
    if(temp.x!=diskout->table[i].x){
      diskout->nx++;
      temp.x=diskout->table[i].x;
    }
    if(temp.y!=diskout->table[i].y){
      diskout->ny++;
      temp.y=diskout->table[i].y;
    }
      if(temp.z!=diskout->table[i].z){
      diskout->nz++;
      temp.x=diskout->table[i].z;
    }
  }
  if(diskout->ndata!=(diskout->nx * diskout->ny * diskout->nz)){
    return 4;
  }
#ifdef _DEBUG_DCM
  printf("(x y z) : (%d %d %d)\n"
	  ,diskout->nx,diskout->ny,diskout->nz);
#endif
  return 0;
}

DLLEXPORT int mod_dcm_genesis2buffer()
{
  int ret,datasize;
  int i,j;
  union {
    short  s;
    float  f;
    int    i;
    double d;
  }tmp;

  char *fname;
  Buffer_Struct buffer;
  DiskOut_Header diskout;
  symbol_t      *sym;
  SL_Object     *obj;
  double        *buf;

  /* Get Input File Name*/
  fname=GetString(0);
  if(fname==NULL)
    return (1);

  diskout.fp=fopen(fname,"r");
  if(diskout.fp==NULL)
    return (2);

  ret=Read_FMT1_Header(&diskout);
  if(ret!=0){
    fclose(diskout.fp);
    return (ret);
  }

  if ( GetArgNum() > 1){
    sym = syscom->get_symbol(1);
    if(sym != NULL && (obj=symbol_get_object(sym)) != NULL){
      Index idx;
      idx.SetDim(1); idx.SetIndex(0,1);
      try{
        obj->Init(SL_OBJ::SERIES_O,idx);
      }catch(std::bad_alloc){
        return 8; /* out of memory */
      }
      buf = (double*)obj->GetBufferPointer()->GetDataPointer();
      *buf = (double)diskout.start;
    }
  }

  if ( GetArgNum() > 2){
    sym = syscom->get_symbol(2);
    if(sym != NULL && (obj=symbol_get_object(sym)) != NULL){
      Index idx;
      idx.SetDim(1); idx.SetIndex(0,1);
      try{
        obj->Init(SL_OBJ::SERIES_O,idx);
      }catch(std::bad_alloc){
        return 8; /* out of memory */
      }
      buf = (double*)obj->GetBufferPointer()->GetDataPointer();
      *buf = (double)diskout.step;
    }
  }

  /* check data size */
  switch(diskout.datatype) {
  case 2 :
    datasize = sizeof(short);
    break;
  case 3 :
    datasize = sizeof(int);
    break;
  case 4 :
    datasize = sizeof(float);
    break;
  case 5 :
    datasize = sizeof(double);
    break;
  default :
    fclose(diskout.fp);
    return (6);
    break;
  }

  if(fseek(diskout.fp,diskout.header_size,0) == -1){
    fclose(diskout.fp);
    return (7);
  }

  for(i=0;fread(&tmp,datasize,1,diskout.fp)!=0;i++){
    if(i==0){
      buffer.data=AllocBuffer(diskout.ndata);
    } else {
      buffer.data=(Buffer *)realloc(buffer.data,
           sizeof(Buffer)*(diskout.ndata)*(i+1));
    }
    for(j=0;j<diskout.ndata;j++){
      if(j!=0){
	if(fread(&tmp,datasize,1,diskout.fp)==0){
	  fclose(diskout.fp);
	  return (6);
	}
      }
      switch(diskout.datatype) {
      case 2 :
	buffer.data[i*diskout.ndata+j]=(double)tmp.s;
	break;
      case 3 :
	buffer.data[i*diskout.ndata+j]=(double)tmp.i;
	break;
      case 4 :
	buffer.data[i*diskout.ndata+j]=(double)tmp.f;
	break;
      case 5 :
	buffer.data[i*diskout.ndata+j]=(double)tmp.d;
	break;
      }
    }
  }

  if(diskout.nz==1){
    if(diskout.ny==1){
      if(diskout.nx==1){
	buffer.dim=1;
	buffer.index[0]=i;
      } else {
	buffer.dim=2;
	buffer.index[0]=diskout.nx;
	buffer.index[1]=i;
      }
    } else {
      buffer.dim=3;
      buffer.index[0]=diskout.nx;
      buffer.index[1]=diskout.ny;
      buffer.index[2]=i;
    }
  } else {
    buffer.dim=4;
    buffer.index[0]=diskout.nx;
    buffer.index[1]=diskout.ny;
    buffer.index[2]=diskout.nz;
    buffer.index[3]=i;
  }
  fclose(diskout.fp);
  free(diskout.table);
  ReturnSeries(buffer.data,buffer.dim,buffer.index);
  FreeBuffer(buffer.data);
  return 0;
}

#ifdef __cplusplus
}
#endif
