/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: neuron2satellite.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

#undef fscanf
#undef fgets

typedef struct {
  FILE *fp;
  char fname[64];
  int dim,index[10],length;
  Buffer *data;
} Satellite_Data;

DLLEXPORT int mod_dcm_neuron2satellite()
{
  int i,j;
  int num,size;
  FILE *nrn_fp;
  char *nrn_fname;
  char dumy[128],temp[64];
  double dat1,dat2;
  Satellite_Data *sd;

  /* Get File Name */
  nrn_fname=GetString(0);
  if(nrn_fname==NULL)
    return (1);

  /* Input File Open */
  nrn_fp=fopen(nrn_fname,"r");
  if(nrn_fp==NULL)
    return (1);

  while(1){
    fscanf(nrn_fp,"%s",dumy);
    if(feof(nrn_fp)){
      break;
    }
    if(strcmp("Graph",dumy)){
      return (4);
    }
    fgets(dumy,512,nrn_fp);
    fscanf(nrn_fp,"%d %d",&num,&size);

    sd=(Satellite_Data *)malloc(sizeof(Satellite_Data)*num);

    /* Satellite Data Init */
    for(i=0;i<num;i++){
      sd[i].dim=2;
      sd[i].length=size*2;
      sd[i].data=AllocBuffer(size*2);
      sd[i].index[0]=size;
      sd[i].index[1]=2;
      for(j=2;j<10;j++)
	sd[i].index[j]=0;
    }

    /* Set File Name */
    fscanf(nrn_fp,"%s",dumy);
    for(i=0;i<num;i++){
      fscanf(nrn_fp,"%s",dumy);
      if(dumy[strlen(dumy)-1]=='('){
	dumy[strlen(dumy)-1]=0;
	strcpy(sd[i].fname,dumy);
	fscanf(nrn_fp,"%s",temp);
	fscanf(nrn_fp,"%s",temp);
	if(temp[0]!=')'){
	  return (4);
	}
      } else {
	strcpy(sd[i].fname,dumy);
      }
    }

    /* Data Set */
    for(i=0;i<size;i++){
      fscanf(nrn_fp,"%lf",&dat1);
      for(j=0;j<num;j++){
	fscanf(nrn_fp,"%lf",&dat2);
	sd[j].data[i*2]=dat1;
	sd[j].data[i*2+1]=dat2;
      }
    }

    /* Satellite File Object Data Output */
    for(i=0;i<num;i++){
      ChangeDataSize(8);
      sprintf(sd[i].fname,"%s.dat",sd[i].fname);
      printf("Output Satellite File Object : \"%s\"\n",sd[i].fname);
      _WriteFile(sd[i].fname, sd[i].dim, sd[i].index, (char *) sd[i].data);
      FreeBuffer(sd[i].data);
    }
    free(sd);
  }
  return 0;
}
#ifdef __cplusplus
}
#endif
