/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: GpmOp.cpp,v 1.2 2004/05/18 07:34:48 orrisroot Exp $ */

#define MYSELF
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef WIN32
#include <windows.h>
#include <process.h>
#else
#include <unistd.h>
#include <pthread.h>
#endif
#include <stdio.h>
#include <gtk/gtk.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
#include "GpmOp.h"
#include "GpmWindow.h"
#include "GpmThread.h"
#define  __IMPORTSYMBOL__
#include "SystemCommon.h"
#undef   __IMPORTSYMBOL__

/* global */
GpmWindow *pGpmWindow[MAX_WIN];
#ifdef WIN32
BOOL	ConfigureEvent;
extern COLORREF rgbColor;
HANDLE hThread = NULL;
#else
bool ConfigureEvent;
extern GdkColor  rgbColor;
int	hThread;
pthread_t gtkThread;
#endif
unsigned int	currentWindow;		/* current window */
extern int GPM_bgcolor(char *colname);

/* command parameters */
struct wopen_param	WopenParam;
struct wclose_param	WcloseParam;
struct axis_param AxisParam;
struct color_param ColorParam;
struct draw_param DrawParam;
struct factor_param FactorParam;
struct font_param FontParam;
struct graph_param GraphParam;
struct label_param LabelParam;
struct line_param LineParam;
struct ltype_param LtypeParam;
struct lwidth_param LwidthParam;
struct origin_param OriginParam;
struct size_param SizeParam;
struct scale_param ScaleParam;
struct title_param TitleParam;
struct gsolm_param GsolmParam;
struct egraph_param EgraphParam;
struct prev_param PrevParam;
struct cont_param ContParam;
struct map_param MapParam;
struct image_param ImageParam;
struct noise_param NoiseParam;
struct xlabel_param XlabelParam;

/* interface */
#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT const char *SetupCommand(){
  static char *setup_command="setup";
  return setup_command;
}

DLLEXPORT const char *CleanCommand(){
  static char *clean_command="gpmclean";
  return clean_command;
}

#ifdef WIN32
static void setgpmcolor(DWORD rgb)
#else
static void setgpmcolor(GdkColor rgb)
#endif
{
	rgbColor = rgb;
}

#ifdef WIN32
DWORD getgpmcolor()
#else
GdkColor getgpmcolor()
#endif
{
  return rgbColor;
}

#ifdef WIN32
void __cdecl GtkMainLoop()
#else
void *GtkMainLoop(void *dmy)
#endif
{
  gtk_main();
#ifndef WIN32
  return NULL;
#endif
}

/* initialized command */
int DLLEXPORT setup()
{
  int	i;

  // GpmWindow object is cleared
  for(i = 0; i < MAX_WIN; i++) {
    pGpmWindow[i] = NULL;
  }
  // set current
  currentWindow = 0;
#ifdef WIN32
  // check if GTK1.3 is installed
  //DWORD pathBuf[MAX_PATH + 1];
  //DWORD size = MAX_PATH + 1;
  //long lRetCode;
  //HKEY hkey;
  //const char *REG_INSTALL_KEY_GTK = "SOFTWARE\\GTK\\1.3";

  //lRetCode = RegOpenKeyEx(HKEY_LOCAL_MACHINE, REG_INSTALL_KEY_GTK, 0, KEY_READ, &hkey);
  //if (lRetCode != ERROR_SUCCESS) {
  //	printf("Not installed GTK 1.3\n");
  //	return 1;
  //}
  //RegCloseKey (hkey);

  // create thread
  COLORREF cl;
  DWORD threadID;
  HANDLE tmpThread;
  int rtval;
  char reg[_MAX_PATH];
  
  if (!g_thread_supported())
    g_thread_init (NULL);
  tmpThread = CreateThread( 0, 0, (LPTHREAD_START_ROUTINE)GtkMainLoop, 
                            NULL, 0, &threadID);
  rtval = GetThreadPriority( tmpThread );
  if(rtval == THREAD_PRIORITY_ERROR_RETURN) {
    MessageBox(NULL,"GetThreadPriority error","GPM",MB_OK);
  }
  if(!SetThreadPriority(tmpThread, THREAD_PRIORITY_BELOW_NORMAL)) {
    MessageBox(NULL,"SetThreadPriority error","GPM",MB_OK);
  }
  // set thread
  hThread = (HANDLE)TRUE;
  // setgpmcolor
  sprintf(reg,"SATELLITE %s", VERSION);
  if(ReadRegistInt(reg,"GpmColor",(long *)&cl) != 0)
    cl = RGB(255,255,255); /* white */
  setgpmcolor((DWORD)cl);
#else
  GdkColor cl;
  long cld;
  char reg[256];
  
  if (!g_thread_supported()) g_thread_init (NULL);
  gdk_threads_enter();
  gtk_init_check(NULL, NULL);
  gdk_threads_leave();  
  //g_thread_init(NULL);
  //gtk_init(NULL, NULL);
  
  pthread_create(&gtkThread, NULL, GtkMainLoop, 0);
  // set thread
  hThread = 1;
  // setgpmcolor
  sprintf(reg,"SATELLITE %s", VERSION);
  if(ReadRegistInt(reg,"GpmColor",&cld) != 0)
    cld = 0xffffff; /* white */
  cl.red = cld & 0xff;
  cl.green = (cld & 0xff00) >> 8;
  cl.blue = (cld & 0xff0000) >> 16;
  setgpmcolor(cl);
  
#endif
  
  return 0;
}

// exit command
int DLLEXPORT gpmclean()
{
  int win;

  // close all window
  for(win = 0; win < MAX_WIN; win++) {
    if(pGpmWindow[win])
      pGpmWindow[win]->Close(win);
  }
#ifdef WIN32
  COLORREF cl;
  char reg[_MAX_PATH];
  cl = getgpmcolor();
  sprintf(reg, "SATELLITE %s", VERSION);
  WriteRegistInt(reg,"GpmColor",cl);
	if(FindWindow(NULL, PACKAGE_STRING) == NULL) {
gdk_threads_enter();
		gtk_exit(0);
gdk_threads_leave();
	}
	else {
gdk_threads_enter();
	gtk_main_quit();
gdk_threads_leave();
TerminateThread(hThread, 0);
	}

#else
  GdkColor cl;
  long cld;
  char reg[256];
  cl = getgpmcolor();
  sprintf(reg, "SATELLITE %s", VERSION);
  cld = (cl.blue & 0xff) << 16;
  cld += (cl.green & 0xff) << 8;
  cld += (cl.red & 0xff);
  WriteRegistInt(reg,"GpmColor",cld);
  
  //  gtk_main_quit();
  //  gtk_main_iteration_do(FALSE);
  gdk_threads_enter();
  gtk_exit(0);
  gdk_threads_leave();
  pthread_join(gtkThread, NULL);
#endif
  return 0;
}

/* ginit command */
int DLLEXPORT SL_ginit()
{
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    //return (24);		/*Window does't exist.*/
    return 0;
  pGpmWindow[currentWindow]->GPM_werase();
  pGpmWindow[currentWindow]->set_default_param();
#ifdef WIN32
	if(is_compat2x_mode() == 1)
    rgbColor = 0x0;
  else
    rgbColor = getgpmcolor();
  pGpmWindow[currentWindow]->BkColorChange( pGpmWindow[currentWindow]->m_drawing_area );
#endif
  return 0;
}

/* wopen command */
int DLLEXPORT SL_wopen()
{
  int windowNo,errcode,paperNo;
  
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  
  /* Get paramters */
  WopenParam.argnum = GetArgNum();
  WopenParam.wnum = (int)GetScalar(0);
  WopenParam.size = GetString(1);
  WopenParam.orientation = (int)GetScalar(2);
  WopenParam.device = (int)GetScalar(3);
  if(WopenParam.argnum == 5)
    WopenParam.xbuf = GetString(4);
  if(WopenParam.argnum == 6) {
    WopenParam.x = (float)GetScalar(4);
    WopenParam.y = (float)GetScalar(5);
  }
  
  windowNo  = WopenParam.wnum - 1;
  
  /* analysis parameter */
  /* Check window No*/
  if ((windowNo < 0) || (windowNo > MAX_WIN-1))
    return (35);
  /* Check paper */
  if (!WopenParam.size)
    return (2);
  
  /* check gtk_init_check if X server is available */
  if((WopenParam.device==0||WopenParam.device==1)
     &&!gtk_init_check(NULL,NULL)){
    return (1);
  }
  
  /* argnum == 5*/
  if(WopenParam.argnum == 5) {
    if(!WopenParam.xbuf)
      return (2);
  }
  
  /* if window exsist */
  if(pGpmWindow[windowNo]) {
    //check paper size
    if ( !strcmp(WopenParam.size,"A4") || !strcmp(WopenParam.size,"a4") )
      paperNo = 0;
    else if ( !strcmp(WopenParam.size,"B4") || !strcmp(WopenParam.size,"b4") )
      paperNo = 1;
    else
      paperNo = 2;
    if(pGpmWindow[windowNo]->GpmCont.paper == paperNo) {
      if(pGpmWindow[windowNo]->GpmCont.device == 2 && WopenParam.device != 2) {
        pGpmWindow[windowNo]->Close(windowNo);
      }
      else {
        pGpmWindow[windowNo]->GPM_werase();
        pGpmWindow[windowNo]->set_default_param();
        //pGpmWindow[windowNo]->GPM_ginit();
		//set current
		currentWindow = windowNo;
        return (0);
      }
    }
    else
      pGpmWindow[windowNo]->Close(windowNo);
    
    
  }
  
  /* create window */
  currentWindow = windowNo;
  pGpmWindow[windowNo] = new GpmWindow();
  pGpmWindow[windowNo]->GPM_ginit();
  pGpmWindow[windowNo]->ConfigureEvent = FALSE;
  errcode = pGpmWindow[windowNo]->GPM_wopen( windowNo );
  if(!errcode) {
    if(WopenParam.device < 2) {// check window open
      for(;;) {
        if(pGpmWindow[windowNo]->ConfigureEvent == TRUE){
          break;
        }else{
#ifdef WIN32
          Sleep(1000);
#else
          usleep(1000);
#endif
        }
      }
    }
  }
  
  return(errcode);
}

/* wclose command */
int DLLEXPORT SL_wclose()
{
  int windowNo,win;
  char args[16];
  
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  /*Get paramters*/
  if(strcmp(GetArgType(0), "string") == 0) {
    strcpy(args, GetString(0));
    if(strcmp(args, "all") == 0 ||
       strcmp(args, "ALL") == 0) {
      // delete
      for(win = 0; win < MAX_WIN; win++) {
        if(pGpmWindow[win])
          pGpmWindow[win]->Close(win);
      }
      return 0;
    }
    else
      return (2);
  }
  
  WcloseParam.wnum = (int)GetScalar(0);
  windowNo = WcloseParam.wnum - 1;
  if ((windowNo < 0) || (windowNo > MAX_WIN-1))
    return (35);
  if(pGpmWindow[windowNo] == NULL)
    return (24);		/*Window does't exist.*/
  pGpmWindow[windowNo]->Close(windowNo);
  return 0;
}

int SL_sin(int windowNo)
{
  pGpmWindow[windowNo]->sin_curve(windowNo);
  return 0;
}

/* axis command */
int DLLEXPORT SL_axis()
{
  int argnum,errcode;
  
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  if((argnum = GetArgNum()) != 10)
    errcode = 2;	//Illegal parameter.
  else {
    AxisParam.tbuf = (int)GetScalar(0);
    AxisParam.typ = (char)GetScalar(1);
	if(GetString(2) == NULL)
		return (2);
    strcpy(AxisParam.flg1, GetString(2));
	if(GetString(3) == NULL)
		return (2);
    strcpy(AxisParam.flg2, GetString(3));
    AxisParam.size = (float)GetScalar(4);
    AxisParam.grid = (int)  GetScalar(5);
    AxisParam.form = (int)  GetScalar(6);
    AxisParam.xscl = (float)GetScalar(7);
    AxisParam.yscl = (float)GetScalar(8);
    AxisParam.index = (int)  GetScalar(9);
    pGpmWindow[currentWindow]->m_now_drawing = 1;
    errcode = pGpmWindow[currentWindow]->GPM_axis();
    pGpmWindow[currentWindow]->m_now_drawing = 0;
  }
  
  return errcode;
}

/* color command */
int DLLEXPORT SL_color()
{
  int errcode;
  
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  if(GetString(0) != NULL) {
    strcpy(ColorParam.name1, GetString(0));
    ColorParam.number1 = -1;
  }
  else {
    strcpy(ColorParam.name1, "");
    ColorParam.number1 = (int)GetScalar(0);
  }
  if(GetString(1) != NULL) {
    strcpy(ColorParam.name2, GetString(1));
    ColorParam.number2 = -1;
  }
  else {
    strcpy(ColorParam.name2, "");
    ColorParam.number2 = (int)GetScalar(1);
  }
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_color();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return 0;
}

/* draw command */
int DLLEXPORT SL_draw()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  if(GetString(0) == NULL)
    strcpy(DrawParam.axs, "X");
  else
	strcpy(DrawParam.axs, GetString(0));
  DrawParam.val = (float)GetScalar(1);
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_draw();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

/* factor command */
int DLLEXPORT SL_factor()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  FactorParam.x = GetScalar(0);
  
  errcode = pGpmWindow[currentWindow]->GPM_factor();
  return errcode;
}

/* font command */
int	DLLEXPORT SL_font()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  FontParam.type = (int)GetScalar(0);
  
  errcode = pGpmWindow[currentWindow]->GPM_font();
  return errcode;
}

/* frame command */
int	DLLEXPORT SL_frame()
{
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  pGpmWindow[currentWindow]->GPM_frame();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return 0;
}

/* gstat command */
int	DLLEXPORT SL_gstat()
{
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  pGpmWindow[currentWindow]->GPM_gstat();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return 0;
}

/* label command */
int DLLEXPORT SL_label()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  if(GetString(0) == NULL)
	  return (2);
  strcpy(LabelParam.ctyp, GetString(0));
  LabelParam.xorg = GetScalar(1);
  LabelParam.yorg = GetScalar(2);
  LabelParam.high = GetScalar(3);
  LabelParam.th = GetScalar(4);
  if(GetString(5) == NULL)
	  return (2);
  strcpy(LabelParam.str, GetString(5));
  LabelParam.mode = (int)GetScalar(6);
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_label();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

/* line command */
int DLLEXPORT SL_line()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get Parameters */
  int argnum;
  char atype[16];
  argnum = GetArgNum();
  strcpy(atype, GetArgType(0));
  LineParam.xorg = (float)GetScalar(0);
  strcpy(atype, GetArgType(1));
  LineParam.yorg = (float)GetScalar(1);
  strcpy(atype, GetArgType(2));
  LineParam.xend = (float)GetScalar(2);
  strcpy(atype, GetArgType(3));
  LineParam.yend = (float)GetScalar(3);
  if(argnum == 5) {
    if(GetString(4) != NULL)
      strcpy(LineParam.mode, GetString(4));
    else
      strcpy(LineParam.mode, "");
  }
  else
    strcpy(LineParam.mode, "");
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_line();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

/* ltype command */
int DLLEXPORT SL_ltype()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  LtypeParam.ilt1 = (int)GetScalar(0);
  if(LtypeParam.ilt1 == 0)
	  LtypeParam.ilt1 = 1;
  LtypeParam.ilt2 = (int)GetScalar(1);
  if(LtypeParam.ilt2 == 0)
	  LtypeParam.ilt2 = 1;
  
  errcode = pGpmWindow[currentWindow]->GPM_ltype();
  return errcode;
}

/* lwidth command */
int DLLEXPORT SL_lwidth()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  LwidthParam.ilt1 = (int)GetScalar(0);
  if(LwidthParam.ilt1 == 0)
  	  LwidthParam.ilt1 = 1;
  LwidthParam.ilt2 = (int)GetScalar(1);
  if(LwidthParam.ilt2 == 0)
  	  LwidthParam.ilt2 = 1;
  
  errcode = pGpmWindow[currentWindow]->GPM_lwidth();
  return errcode;
}

/* origin command */
int DLLEXPORT SL_origin()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  OriginParam.xorg = GetScalar(0);
  OriginParam.yorg = GetScalar(1);
  
  errcode = pGpmWindow[currentWindow]->GPM_origin();
  return errcode;
}

/* size command */
int DLLEXPORT SL_size()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  
  /* Get parameters */
  SizeParam.len1 = (float)GetScalar(0);
  SizeParam.len2 = (float)GetScalar(1);
  
  errcode = pGpmWindow[currentWindow]->GPM_size();
  return errcode;
}

/* title command */
int DLLEXPORT SL_title()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /*Get parameters*/
  int i;
  
  TitleParam.argnum = GetArgNum();
  TitleParam.tbuf = (int)GetScalar(0);
  for ( i = 1; i < TitleParam.argnum; i++ ) {
    strcpy(TitleParam.atype[i], GetArgType(i));
    if(strcmp(TitleParam.atype[i], "string") == 0)
      if(GetString(i)!=NULL){
        strcpy(TitleParam.ialpha[i], GetString(i));
      }else{
        strcpy(TitleParam.ialpha[i], "");
      }
    else
      strcpy(TitleParam.ialpha[i], "");
  }
  
  errcode = pGpmWindow[currentWindow]->GPM_title();
  return errcode;
}

/* graph command */
int DLLEXPORT SL_graph()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  strcpy(GraphParam.y, "");
  if(GetString(0) != NULL)
    strcpy(GraphParam.y, GetString(0));
  strcpy(GraphParam.x, "");
  if(GetString(1) != NULL)
    strcpy(GraphParam.x, GetString(1));
  GraphParam.axs = (int)GetScalar(2);
  GraphParam.lne = (int)GetScalar(3);
  GraphParam.step = (int)GetScalar(4);
  GraphParam.sym1 = (int)GetScalar(5);
  GraphParam.sym2 = (float) GetScalar(6);
  /*y*/
  GraphParam.bufy = (Buffer *)GetSeries(0, &GraphParam.dimy, 
                                        GraphParam.indexy);
  /*x*/
  GraphParam.bufx = (Buffer *)GetSeries(1, &GraphParam.dimx, 
                                        GraphParam.indexx);
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_graph();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

/* egraph command */
int DLLEXPORT SL_egraph()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  strcpy(EgraphParam.y, "");
  if(GetString(0) != NULL)
    strcpy(EgraphParam.y, GetString(0));
  strcpy(EgraphParam.x, "");
  if(GetString(1) != NULL)
    strcpy(EgraphParam.x, GetString(1));
  EgraphParam.axs = (int)GetScalar(2);
  EgraphParam.lne = (int)GetScalar(3);
  EgraphParam.step = (int)GetScalar(4);
  EgraphParam.sym1 = (int)GetScalar(5);
  EgraphParam.sym2 = (float) GetScalar(6);
  /*y*/
  EgraphParam.bufy = (Buffer *)GetSeries(0, &EgraphParam.dimy, 
                                         EgraphParam.indexy);
  /*x*/
  EgraphParam.bufx = (Buffer *)GetSeries(1, &EgraphParam.dimx, 
                                         EgraphParam.indexx);

  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_egraph();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

/* werase command */
int DLLEXPORT SL_werase()
{
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  pGpmWindow[currentWindow]->GPM_werase();
  return 0;
}

/* scale command */
int DLLEXPORT SL_scale()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  int i, zflag;
  ScaleParam.argnum = GetArgNum();
  for ( i = 0; i < ScaleParam.argnum && i < 6; i++ ) {
    strcpy(ScaleParam.atype[i], GetArgType(i));
    if(strcmp(ScaleParam.atype[i],"string") == 0)
      strcpy(ScaleParam.ialpha[i], GetString(i));
  } 
  zflag = (ScaleParam.argnum >= 6) ? 
    (!strcmp(ScaleParam.atype[4],"string")) : 0;
  if ( !zflag ) {
    if (ScaleParam.argnum >= 6 ) {
      ScaleParam.scl1 = (float)GetScalar(4);
      ScaleParam.scl2 = (float)GetScalar(5);
      if ( ScaleParam.argnum > 6 ) {
        ScaleParam.scl3 = (float)GetScalar(6);
        ScaleParam.scl4 = (float)GetScalar(7);
      }
    }
  } else {
    if ( ScaleParam.argnum >= 8 ) {
      ScaleParam.scl1 = (float)GetScalar(6);
      ScaleParam.scl2 = (float)GetScalar(7);
      if ( ScaleParam.argnum >= 10 ) {
        ScaleParam.scl3 = (float)GetScalar(8);
        ScaleParam.scl4 = (float)GetScalar(9);
        if ( ScaleParam.argnum > 10 ) {
          ScaleParam.scl5 = (float)GetScalar(10);
          ScaleParam.scl6 = (float)GetScalar(11);
        }
      }
    }
  }
  
  errcode = pGpmWindow[currentWindow]->GPM_scale();
  return errcode;
}

/* cont command */
int DLLEXPORT SL_cont()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  ContParam.bufno     = GetBufferID(0);
  if(ContParam.bufno < 0)
	  return(2);
  if ( GetBufferInfo(ContParam.bufno, ContParam.index) != 2) {
    return (16);	/*  Data dimension mismatch. */
  }
  ContParam.step      = GetScalar(1);	/* step */
  if(ContParam.step == 0.0)
	  return (2);
  if(GetString(2) == NULL)
	strcpy(ContParam.dirc, "X");
  else	  
    strcpy(ContParam.dirc, GetString(2));
  ContParam.view = (int)GetScalar(3);
  ContParam.mode = (int)GetScalar(4);
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_cont();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

/* gsolm command */
int DLLEXPORT SL_gsolm()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  GsolmParam.bufno = GetBufferID(0);
  if ( GetBufferInfo(GsolmParam.bufno, GsolmParam.index) != 2) {
    return (16);	/*  Data dimension mismatch. */
  }
  GsolmParam.rh1    = (float)GetScalar(1);
  GsolmParam.rh2    = (float)GetScalar(2);
  GsolmParam.f1  = (int)  GetScalar(3); /* hide line */
  GsolmParam.f2  = (int)  GetScalar(4);
  GsolmParam.f3  = (int)  GetScalar(5);
  GsolmParam.f4  = (int)  GetScalar(6);
  GsolmParam.col      = (int)  GetScalar(7);
  GsolmParam.div1      = (int)  GetScalar(8);
  GsolmParam.div2      = (int)  GetScalar(9);
  if(GetString(10) == NULL)
	  return (2);
  strcpy(GsolmParam.dirc, GetString(10));
  GsolmParam.view = (int) GetScalar(11);
  GsolmParam.mode = (int) GetScalar(12);
  GsolmParam.size  = (float)GetScalar(13);
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_gsolm();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

int DLLEXPORT SL_map()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  MapParam.argnum = GetArgNum();
  MapParam.indat     = (Buffer*)GetSeries(0,&MapParam.dim,MapParam.index);
  if ( MapParam.indat == NULL || MapParam.dim < 2 || MapParam.dim > 3 )
    return (16);	/*  Data dimension mismatch. */
  if(GetString(1) == NULL)
	  return (2);
  strcpy(MapParam.dirc, GetString(1));
  MapParam.style     = (int)  GetScalar(2);
  MapParam.psize     = (int)  GetScalar(3);
  MapParam.view = (int) GetScalar(4);
  
  if (MapParam.argnum > 5) {
    MapParam.time =	(int)GetScalar(5);
    MapParam.start = (int)GetScalar(6);
    MapParam.end = (int)GetScalar(7);
    MapParam.step = (int)GetScalar(8);
  }
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_map();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

/* chwin command */
int DLLEXPORT SL_chwin()
{
  int windowNo,errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  windowNo = (int)GetScalar(0);
  windowNo--;
  if ((windowNo < 0) || (windowNo > MAX_WIN-1))
    return (35);
  errcode = pGpmWindow[windowNo]->GPM_chwin(windowNo);
  return(errcode);
}

/* prev command */
int DLLEXPORT SL_prev()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /*Get parameters*/
  PrevParam.argnum = GetArgNum();
  if(PrevParam.argnum == 1) {
	if(GetString(0) == NULL)
		return (2);
    strcpy(PrevParam.filename, GetString(0));
  }
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_prev();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

int DLLEXPORT SL_image()
{
  int argnum;
  int errcode;
  char *fname;
  if(!hThread)
    return 43; /* GPM isn't initialized. */
  if(!pGpmWindow[currentWindow])
    return 24; /* Window does't exist. */
  /* Get parameters */
  argnum = GetArgNum();
  if(argnum != 3 && argnum != 4)
    return 2; /* illegal parameter */
  ImageParam.image = GetString(0);
  if(ImageParam.image == NULL)
    return 2; /* illegal parameter */
  ImageParam.dx = GetScalar(1);
  ImageParam.dy = GetScalar(2);
  if(argnum == 4){
    ImageParam.number = (int) GetScalar(3);
  }else{
    ImageParam.number = 0;
  }
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_image();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

// int DLLEXPORT SL_image()
// {
//   int errcode;
//   if(!hThread)
//     return (43);		/*GPM isn't initialized.*/
//   if(!pGpmWindow[currentWindow])
//     return (24);		/*Window does't exist.*/
//   /* Get parameters */
//   if(GetString(0) == NULL)
//     return (2);
//   strcpy(ImageParam.ialpha, GetString(0));
//   ImageParam.dx      = GetScalar(1);
//   ImageParam.dy      = GetScalar(2);
//   ImageParam.numer   = (int) GetScalar(3);
//   pGpmWindow[currentWindow]->m_now_drawing = 1;
//   errcode = pGpmWindow[currentWindow]->GPM_image();
//   pGpmWindow[currentWindow]->m_now_drawing = 0;
//   return errcode;
// }


int DLLEXPORT SL_noise()
{
  int errcode;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  NoiseParam.xnum = (int)GetScalar(0);
  NoiseParam.ynum = (int)GetScalar(1);
  NoiseParam.size = (int)GetScalar(2);
  NoiseParam.loop = (int)GetScalar(3);
  NoiseParam.wnum = (int)GetScalar(4);
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_noise();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

int DLLEXPORT SL_xlabel()
{
  int errcode;
  char *arg;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  /* Get parameters */
  XlabelParam.argnum = GetArgNum();
  XlabelParam.rnumer[0] = (float) GetScalar(0);
  XlabelParam.rnumer[1] = (float) GetScalar(1);
  arg = GetString(2);
  if(arg)  
	strcpy(XlabelParam.ialpha[0], arg);
  else
	return (2);		/*Illegal parameter*/
  arg = GetString(3);
  if(arg)  
    strcpy(XlabelParam.ialpha[1], arg);
  else
	return (2);		/*Illegal parameter*/
  arg = GetString(4);
  if(arg)  
    strcpy(XlabelParam.ialpha[2], arg);
  else
	return (2);		/*Illegal parameter*/
  arg = GetString(5);
  if(arg)  
    strcpy(XlabelParam.ialpha[3], arg);
  else
	return (2);		/*Illegal parameter*/
  XlabelParam.numer     = (int)   GetScalar(6);
  if ( XlabelParam.argnum > 7) 
    XlabelParam.orient    = (int)   GetScalar(7); /* string orientation */
  if ( XlabelParam.argnum > 8) 
    XlabelParam.hpos      = (int)   GetScalar(8); /* h-alignment */
  if ( XlabelParam.argnum > 9) 
    XlabelParam.vpos      = (int)   GetScalar(9); /* v-alignment */
  
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_xlabel();
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  return errcode;
}

/* raise command */
int DLLEXPORT SL_raise()
{
  int windowNo;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  windowNo = (int)GetScalar(0);
  
  windowNo--;
  if ((windowNo < 0) || (windowNo > MAX_WIN-1))
    return (35);
  //errcode = pGpmWindow[windowNo]->GPM_raise(windowNo);
  gdk_window_raise( pGpmWindow[windowNo]->m_window->window );
  return 0;
}

/* werase command */
int DLLEXPORT SL_roll()
{
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  pGpmWindow[currentWindow]->GPM_roll();
  return 0;
}

int DLLEXPORT SL_ge()
{
  int win;
  
  for(win = 0; win < MAX_WIN; win++) {
    if(pGpmWindow[win])
      pGpmWindow[win]->Close(win);
  }
  
  return 0;
}

/* bgcolor command */
int DLLEXPORT SL_bgcolor()
{
  int errcode;
  char	*color;
  
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  color = GetString(0);
  if(!color)
    return (2);
  if(!pGpmWindow[currentWindow]) {
    /*Window does't exist.*/
    errcode = GPM_bgcolor(color);
    return errcode;
  }
  pGpmWindow[currentWindow]->m_now_drawing = 1;
  errcode = pGpmWindow[currentWindow]->GPM_bgcolor(color);
  pGpmWindow[currentWindow]->m_now_drawing = 0;
  if(errcode) return errcode;

  // GpmWindow.cpp
  pGpmWindow[currentWindow]->BkColorChange(pGpmWindow[currentWindow]->
                                           m_drawing_area );
  return 0;
}

/* gpm2file command */
int DLLEXPORT SL_gpm2file()
{
  int errcode;
  int winno;
  if(!hThread)
    return (43);		/*GPM isn't initialized.*/
  winno = (int)GetScalar(0);
  if(winno < 1 || winno > 10)
	return 35;
  currentWindow = winno-1; 
  if(!pGpmWindow[currentWindow])
    return (24);		/*Window does't exist.*/
  errcode = pGpmWindow[currentWindow]->GPM_gpm2file();
  return errcode;
}

#ifdef __cplusplus
}
#endif

