/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: GpmThread.h,v 1.2 2004/05/18 07:34:48 orrisroot Exp $ */

/*wopen parameter*/
struct wopen_param {
	int		argnum;
	int		wnum;
	char*	size;
	int		orientation;
	int		device;
	char*	xbuf;
	float	x;
	float	y;
	int		windowNo;
	char	title[128];
	int		windowX;
	int		windowY;
};
/* wclose parameter */
struct wclose_param {
	int		wnum;
	int		windowNo;
};
/* axis paramater */
struct axis_param {
	int		tbuf;
	char	typ;
	char	flg1[16];
	char	flg2[16];
	float	size;
	int		grid;
	int		form;
	float	xscl;
	float	yscl;
	int		index;
};
/* color parameter */
struct color_param {
	char	name1[16];
	char	name2[16];
	int		number1;
	int		number2;
};
/* draw paraneter */
struct draw_param {
	char	axs[16];
	float	val;
};
/* factor parameter */
struct factor_param {
	double	x;
};
/* font parameter */
struct font_param {
	int		type;
};
/* graph parameter */
struct graph_param {
	char	y[16];
	char	x[16];
	int		axs;
	int		lne;
	int		step;
	int		sym1;
	float	sym2;
	int		dimx;
	int		indexx[MAX_INDEX];
	int		dimy;
	int		indexy[MAX_INDEX];
	Buffer	*bufx;
	Buffer	*bufy;
};

/* egraph parameter */
struct egraph_param {
	char	y[16];
	char	x[16];
	int		axs;
	int		lne;
	int		step;
	int		sym1;
	float	sym2;
	int		dimx;
	int		indexx[MAX_INDEX];
	int		dimy;
	int		indexy[MAX_INDEX];
	Buffer	*bufx;
	Buffer	*bufy;
};

/* label parameter */
struct label_param {
	char	ctyp[16];
	double	xorg;
	double	yorg;
	double	high;
	double	th;
	char	str[1024];
	int		mode;
};
/* line parameter */
struct line_param {
	float	xorg;
	float	yorg;
	float	xend;
	float	yend;
	char	mode[16];
};
/* ltype parameter */
struct ltype_param {
	int		ilt1;
	int		ilt2;
};

/* lwidth parameter */
struct lwidth_param {
	int		ilt1;
	int		ilt2;
};
/* origin parameter */
struct origin_param {
	double		xorg;
	double		yorg;
};
/* size parameter */
struct size_param {
	float		len1;
	float		len2;
};
/* scale parameter */
struct scale_param {
	int		argnum;
	char	atype[6][16];
	char	ialpha[6][16];
	float	scl1;
	float	scl2;
	float	scl3;
	float	scl4;
	float	scl5;
	float	scl6;
};

/* title parameter */
struct title_param {
	int		argnum;
	int		tbuf;
	char	atype[4][16];
	char	ialpha[4][16];
};
/* gsolm parameter */
struct gsolm_param {
  int	bufno;
  int   index[MAX_INDEX];
  float rh1;
  float rh2;
  int	f1;
  int	f2;
  int	f3;
  int	f4;
  int	col;
  int	div1;
  int	div2;
  char	dirc[16];
  int	view;
  int	mode;
  float	size;
};
/* prev parameter */
struct prev_param {
	int		argnum;
	char	filename[16];
};

/* cont parameter */
struct cont_param {
  int	bufno;
  int   index[MAX_INDEX];
  double step;
  char dirc[16];
  int view;
  int mode;
};

/* cont parameter */
struct map_param {
  int argnum;
  Buffer *indat;
  int   dim;
  int	index[MAX_INDEX];
  char dirc[16];
  int	style;
  int	psize;
  int	view;
  int	time;
  int	start;
  int	end;
  int	step;
};

/* image parameter */
struct image_param {
  double dx;
  double dy;
  int    number;
  char  *image;
};

/* noise parameter */
struct noise_param {
  int	xnum;
  int	ynum;
  int	size;
  int	loop;
  int	wnum;
};
/* xlabel parameter */
struct xlabel_param {
  int	argnum;
  float	rnumer[2];
  char	ialpha[4][FILE_LENGTH];		// FILE_LENGTH=128
  int	numer;
  int	orient;
  int	hpos;
  int	vpos;
};

