/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: GpmWindow.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <gtk/gtk.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
#include "GpmWindow.h"
#include "GpmThread.h"
#define  __IMPORTSYMBOL__
#include "SystemCommon.h"
#undef   __IMPORTSYMBOL__

#define GDK_Control_L 0xFFE3
#define GDK_Control_R 0xFFE4
#define GDK_c 0x063
#define GDK_C 0x043

/* globals */
extern GpmWindow *pGpmWindow[MAX_WIN];
extern unsigned int currentWindow;
#ifdef WIN32
extern BOOL	ConfigureEvent;
extern COLORREF rgbColor;
#else
extern bool	ConfigureEvent;
extern GdkColor rgbColor;
#endif

/* Command parameter */
extern struct wopen_param	WopenParam;

/* Create a new backing pixmap of the appropriate size */
static gint configure_event( GtkWidget *widget, GdkEventConfigure *event ){
  GdkRectangle update_rect;
  int win;
  GdkColor col;

  for(win = 0; win < 10; win++) {
    if(pGpmWindow[win] != NULL) {
      if(pGpmWindow[win]->m_drawing_area == widget) {
        if (pGpmWindow[win]->m_pixmap) {
          gdk_threads_enter();
          gdk_pixmap_unref(pGpmWindow[win]->m_pixmap);
          gdk_threads_leave();
        }
        gdk_threads_enter();
        pGpmWindow[win]->m_pixmap = gdk_pixmap_new(widget->window,
                                                   widget->allocation.width,
                                                   widget->allocation.height,
                                                   -1);
        gdk_threads_leave();
	/* set color */
	unsigned long clr;
#ifdef WIN32
	clr = GetRValue(rgbColor);
	col.red = clr << 8;
	clr = GetGValue(rgbColor);
	col.green = clr << 8;
	clr = GetBValue(rgbColor);
	col.blue = clr << 8;
#else
	clr = rgbColor.red;
	col.red = clr << 8;
	clr = rgbColor.green;
	col.green = clr << 8;
	clr = rgbColor.blue;
	col.blue = clr << 8;
#endif
        gdk_threads_enter();
	gdk_color_alloc (gdk_colormap_get_system (), &col);
	gdk_gc_set_foreground(widget->style->black_gc, &col);
        // fill background
        gdk_gc_set_foreground(pGpmWindow[win]->m_window->style->black_gc, &col);
        gdk_threads_leave();

	if(!pGpmWindow[win]->m_compat2x) {
          col.red = 0x0;
          col.green = 0x0;
          col.blue = 0x0;
	}
	else {
          col.red = 0xffff;
          col.green = 0xffff;
          col.blue = 0xffff;
	}

	gdk_threads_enter();
	gdk_color_alloc (gdk_colormap_get_system (), &col);
	gdk_gc_set_foreground(widget->style->white_gc, &col);
        
        gdk_draw_rectangle (pGpmWindow[win]->m_pixmap,
                            // set background color
                            //widget->style->white_gc,
                            widget->style->black_gc,
                            TRUE,
                            0, 0,
                            widget->allocation.width,
                            widget->allocation.height);
    gdk_threads_leave();

        update_rect.x = 0;
        update_rect.y = 0;
        update_rect.width = widget->allocation.width;
        update_rect.height = widget->allocation.height;
#ifndef WIN32
	gdk_threads_enter();
#endif
        gtk_widget_draw (pGpmWindow[win]->m_window, &update_rect);
#ifndef WIN32
        gdk_threads_leave();
#endif
        pGpmWindow[win]->ConfigureEvent = TRUE;
        break;
      }
    }
  }
  return TRUE;
}

/* Redraw the screen from the backing pixmap */
static gint expose_event( GtkWidget      *widget,
						  GdkEventExpose *event )
{
	int win;
	for(win = 0; win < 10; win++) {
		if(pGpmWindow[win] != NULL) {
			if(pGpmWindow[win]->m_drawing_area == widget) {
			  //gdk_threads_enter();
			  gdk_draw_pixmap(widget->window,
							  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
							  pGpmWindow[win]->m_pixmap,
							  event->area.x, event->area.y,
							  event->area.x, event->area.y,
							  event->area.width, event->area.height);
			  //gdk_threads_leave();
				break;
			}
		}
	}
	return FALSE;
}

/* focus in */
static gint focus_in_event( GtkWidget      *widget,
						  GdkEventExpose *event )
{
	int win;
	for(win = 0; win < 10; win++) {
		if(pGpmWindow[win] != NULL) {
			if(pGpmWindow[win]->m_window == widget) {
				currentWindow = win;
				break;
			}
		}
	}
	return FALSE;
}

/* delete_event */
static gint delete_event( GtkWidget      *widget,
						  GdkEventExpose *event )
{
	pGpmWindow[currentWindow]->Close(currentWindow);
	return FALSE;
}

#if 0
/* focus_out event */
static gint focus_out_event( GtkWidget      *widget,
						  GdkEventExpose *event )
{
	int win;
	for(win = 0; win < 10; win++) {
		if(pGpmWindow[win] != NULL) {
			if(pGpmWindow[win]->m_window == widget) {
#ifndef WIN32
	gdk_threads_enter();
#endif
				//gtk_grab_remove(widget);
				gdk_keyboard_ungrab(GDK_CURRENT_TIME);
#ifndef WIN32
	gdk_threads_leave();
#endif
				break;
			}
		}
	}
	return FALSE;
}
#endif

#if 1
/* key_press event */
static gint key_press_event( GtkWidget      *widget,
						  GdkEventKey *event )
{
	//GdkEventExpose *gdkevent;
	GdkEventKey *gdkevent;
	int win;
	for(win = 0; win < 10; win++) {
		if(pGpmWindow[win] != NULL) {
			if(pGpmWindow[win]->m_window == widget) {
				gdkevent = event;
				if(event->keyval == GDK_Control_L ||
					event->keyval == GDK_Control_R) {
					pGpmWindow[win]->KeyEvent = 1;
				}
				else if(event->keyval == GDK_c ||
					event->keyval == GDK_C) {
					if(pGpmWindow[win]->KeyEvent) {
						//Ctrl+C
						//register clipboard
					}
				}
				break;
			}
		}
	}
	return FALSE;
}

/* key_press event */
static gint key_release_event( GtkWidget      *widget,
						  GdkEventKey *event )
{
	//GdkEventExpose *gdkevent;
	GdkEventKey *gdkevent;
	int win;
	for(win = 0; win < 10; win++) {
		if(pGpmWindow[win] != NULL) {
			if(pGpmWindow[win]->m_window == widget) {
				gdkevent = event;
				if(event->keyval == GDK_Control_L ||
					event->keyval == GDK_Control_R) {
					// release Ctrl key
					pGpmWindow[win]->KeyEvent = 0;
				}
				break;
			}
		}
	}
	return FALSE;
}
#endif

static void button_quit(GtkWidget *widget, gpointer data)
{
	pGpmWindow[currentWindow]->Close(currentWindow);
}

/*
 * motion_notify
 *
 */
gint motion_notify (GtkWidget *widget, GdkEventMotion *event)
{
  int	x,y;
  GdkModifierType state;
  GdkRectangle update_rect;
  char fontbuf[128];
  GdkFont		*font;
  
  /* if hint is enable*/
  if (event->is_hint) {
    /* set new position */
    gdk_window_get_pointer (event->window, &x, &y, &state);
  }
  else {
    /* set new position */
    x = (int)event->x;
    y = (int)event->y;
    update_rect.x = 0;
    update_rect.y = 0;
    update_rect.width = 120;
    update_rect.height = 15;/* 20; */
    
    int win;
    char str[64];
    float positionX, positionY,ffx,ffy,fff,windowY;
    
    for(win = 0; win < 10; win++) {
      if(pGpmWindow[win] != NULL && pGpmWindow[win]->m_now_drawing != 1) {
        if(pGpmWindow[win]->/*m_window*/m_drawing_area == widget) {
          sprintf(fontbuf,
#ifdef WIN32
                   "-adobe-helvetica-medium-r-normal--*-%d-*-*-*-*-*-*",
                  (int)(60*1.8));
#else
                  "-*-fixed-medium-r-normal--10-*-*-*-*-*-*-*");
#endif
                  //(int)(60*1.8));
          font = gdk_font_load(fontbuf);
          /* drawing */
          ffx     = pGpmWindow[win]->m_datas[0];
          ffy     = pGpmWindow[win]->m_datas[1];
          fff     = pGpmWindow[win]->m_datas[2];
          windowY = pGpmWindow[win]->m_datas[4];
          positionX = x / ffx / fff + 0.4;
          positionY = y / ffy / fff;
          
          if (positionX < 0)
            positionX = 0.0;
          if(pGpmWindow[win]->m_xpointer != x && 
             pGpmWindow[win]->m_ypointer != y) {
            sprintf(str,"(%5.1f, %5.1f)",positionX,windowY-positionY);
            gdk_draw_rectangle(pGpmWindow[win]->m_pixmap,
                               widget->style->black_gc, TRUE, 
                               update_rect.x, update_rect.y,
                               update_rect.width, update_rect.height);
            gdk_draw_string(pGpmWindow[win]->m_pixmap,
                            /*pGpmWindow[win]->gpm_*/font,
                            widget->style->white_gc, 5, 12, str);
            pGpmWindow[win]->m_xpointer = x;
            pGpmWindow[win]->m_ypointer = y;
            gtk_widget_draw(widget, &update_rect);
          }
          break;
        }
      }
    }
  }
  
  return TRUE;
}

/* constructor */
GpmWindow::GpmWindow()
{
	m_window = NULL;
	m_drawing_area = NULL;
	m_vbox = NULL;
	m_button = NULL;
	m_pixmap = NULL;
	m_lineColor = 2;
	m_axisColor = 0;
	m_frameColor = 4;
	m_lineStyle = 0;
	m_axisStyle = 0;
	m_frameStyle = 0;
	m_lineWidth = 1;
	m_axisWidth = 1;
	m_frameWidth = 1;
	gpm_gc = NULL;
	KeyEvent = 0;
	m_xpointer = 0;
	m_ypointer = 0;
	if(is_compat2x_mode() == 1)
          m_compat2x = true;
	else
          m_compat2x = false;
	gpm_display = 0; // NULL;
	m_now_drawing = 0;
	dvi_fd = -1;

}

/* destructor */
GpmWindow::~GpmWindow()
{
}

#ifdef WIN32
void __cdecl GpmWindow::Create()
#else
void GpmWindow::Create()
#endif
{
	char winname[128];
	/*Initialize gtk */
#ifdef WIN32
	gtk_set_locale();
	gtk_init (NULL, NULL);
#endif
	/*Create window*/
	m_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	/* fixed size */
	gtk_window_set_policy(GTK_WINDOW(m_window), FALSE, FALSE, FALSE);
	/*Set title*/
	strcpy(winname, WopenParam.title);
	gtk_window_set_title (GTK_WINDOW(m_window), winname);

	/* Create vbox */
	m_vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (m_window), m_vbox);
	gtk_widget_show (m_vbox);


	/* Create the drawing area */
	m_drawing_area = gtk_drawing_area_new ();
	gtk_drawing_area_size (GTK_DRAWING_AREA (m_drawing_area),
		WopenParam.windowX, WopenParam.windowY);
	gtk_box_pack_start (GTK_BOX (m_vbox), m_drawing_area, TRUE, TRUE, 0);
	gtk_widget_show (m_drawing_area);

	/* Signals used to handle backing pixmap */
	gtk_signal_connect (GTK_OBJECT (m_drawing_area), "expose_event",
		(GtkSignalFunc)expose_event, NULL);
	gtk_signal_connect (GTK_OBJECT(m_drawing_area),"configure_event",
		(GtkSignalFunc) configure_event, NULL);

	/* Focus */
#if 0
	gtk_signal_connect (GTK_OBJECT (m_window), "focus_in_event",
		(GtkSignalFunc)focus_in_event, NULL);
#endif
	/* delete_event */
	gtk_signal_connect (GTK_OBJECT (m_window), "delete_event",
		(GtkSignalFunc)delete_event, NULL);


	/* set mouse signal */
	gtk_signal_connect(GTK_OBJECT (/*m_window*/m_drawing_area), "motion_notify_event",
		(GtkSignalFunc)motion_notify, NULL);
	/* set mouse event */
#ifdef WIN32
	gtk_widget_set_events (/*m_window*/m_drawing_area, GDK_EXPOSURE_MASK
							| GDK_LEAVE_NOTIFY_MASK
							| GDK_BUTTON_PRESS_MASK
			       | GDK_POINTER_MOTION_MASK
			       | GDK_POINTER_MOTION_HINT_MASK);
#else
	gtk_widget_set_events (/*m_window*/m_drawing_area, GDK_EXPOSURE_MASK
							| GDK_LEAVE_NOTIFY_MASK
							| GDK_BUTTON_PRESS_MASK
			       | GDK_POINTER_MOTION_MASK);
#endif


//unused
//	gtk_signal_connect (GTK_OBJECT(m_window),"focus_out_event",
//		(GtkSignalFunc) focus_out_event, NULL);
	/* keyboard */
	gtk_signal_connect (GTK_OBJECT(m_window),"key_press_event",
		(GtkSignalFunc) key_press_event, NULL);
	gtk_signal_connect (GTK_OBJECT(m_window),"key_release_event",
		(GtkSignalFunc) key_release_event, NULL);

#if 0
	/* .. And a quit button */
	m_button = gtk_button_new_with_label ("Quit");
	gtk_box_pack_start (GTK_BOX (m_vbox), m_button, FALSE, FALSE, 0);
	gtk_signal_connect_object (GTK_OBJECT (m_button), "clicked",
                             GTK_SIGNAL_FUNC (button_quit),
                             GTK_OBJECT (m_window));
	gtk_widget_show (m_button);
#endif
	/* Show window */
	gtk_widget_show (m_window);
	//gtk_widget_show_now (m_window);

	gdk_threads_enter();
	gpm_font = gdk_font_load(
//		"-adobe-helvetica-medium-r-normal--*-120-*-*-*-*-*-*");
		"-adobe-helvetica-medium-r-normal--*-110-*-*-*-*-*-*");
//		"-adobe-helvetica-medium-r-normal--*-100-*-*-*-*-*-*");
//		"-adobe-helvetica-medium-r-normal--*-80-*-*-*-*-*-*");
	gdk_threads_leave();
	gdk_threads_enter();
	gdk_flush();
	gdk_threads_leave();
}

void GpmWindow::Close(int windowNo)
{
  if(gtk_init_check(NULL,NULL)){
	if (gpm_display != 0) {
#ifdef WIN32
    gtk_widget_destroy (m_window);
	gtk_idle_remove(m_idle_handle_id);
#else
    gtk_widget_destroy (m_window);
	gtk_idle_remove(m_idle_handle_id);
#endif
	}	//if (gpm_display...
	delete pGpmWindow[windowNo];
	pGpmWindow[windowNo] = NULL;
	if (gpm_display != 0) {
#ifndef WIN32
	gdk_threads_enter();
	gdk_flush();
	gdk_threads_leave();
#endif
	}	//if (gpm_display...
  }
}

// unused
void GpmWindow::Show()
{
}

/* Draw a rectangle on the screen */
void GpmWindow::Line(		int		penKind,
							gint    x1,
							gint    y1,
							gint	x2,
							gint	y2)
{

	GdkGC *penLine = NULL;

	// Create pen
	penLine = GetPen( m_pixmap, penKind );

	GdkRectangle update_rect;
	update_rect.x = 0;
	update_rect.y = 0;
	update_rect.width = m_windowX;
	update_rect.height = m_windowY;
#ifdef WIN32
	gdk_draw_line (m_pixmap,
				   //penLine,
				   gpm_gc,
				   x1, y1, x2, y2);
	gtk_widget_draw (m_window, &update_rect);
#else
	gdk_threads_enter();
	gdk_draw_line (m_pixmap,
				   //penLine,
				   gpm_gc,
				   x1, y1, x2, y2);
	gtk_widget_draw (m_window, &update_rect);
	gdk_threads_leave();
#endif
}

/*
 * GetPen
 * mode = 0  -> Line
 * mode = 1  -> Frame and Axis
 */
GdkGC* GpmWindow::GetPen (GdkDrawable *d, int penKind){
  GdkGC    *gc;
  GdkColor  color;
  int       width,style,pen;
  GdkLineStyle penStyle;

  if(penKind == 0)
    pen = m_lineColor;
  else if(penKind == 1)
    pen = m_axisColor;
  else
    pen = m_frameColor;
  switch(pen) {
  case	0:
    color.red = 0x0,    color.blue = 0x0,    color.green = 0x0;    break;
  case	1:
    color.red = 0x0,    color.blue = 0xffff, color.green = 0x0;    break;
  case	2:
    color.red = 0xffff, color.blue = 0x0,    color.green = 0x0;    break;
  case	3:
    color.red = 0xffff, color.blue = 0x0,    color.green = 0xffff; break;
  case	4:
    color.red = 0x0,    color.blue = 0x0,    color.green = 0xffff; break;
  case	5:
    color.red = 0x0,    color.blue = 0xffff, color.green = 0xffff; break;
  case	6:
    color.red = 0xffff, color.blue = 0xffff, color.green = 0x0;    break;
  case	7:
    color.red = 0xffff, color.blue = 0xffff, color.green = 0xffff; break;
  default:
    color.red = 0x0,    color.blue = 0x0,    color.green = 0x0;    break;
  }
#ifndef WIN32
  gdk_threads_enter();
#endif
  /* color allocation */
  gdk_color_alloc(gdk_colormap_get_system (), &color);
#ifndef WIN32
  gdk_threads_leave();
#endif
  
  //width
  if(penKind == 0)
    width = m_lineWidth;
  else if(penKind == 1)
    width = m_axisWidth;
  else
    width = m_frameWidth;
  if(width < 1)
    width = 1;
  
  //style
  if(penKind == 0)
    style = m_lineStyle;
  else if(penKind == 1)
    style = m_axisStyle;
  else
    style = m_frameStyle;
  if(style == 1)
    penStyle = GDK_LINE_ON_OFF_DASH;
  else if(style == 2)
    penStyle = GDK_LINE_DOUBLE_DASH;
  else
    penStyle = GDK_LINE_SOLID;
  GdkCapStyle cap_style = GDK_CAP_NOT_LAST;
  GdkJoinStyle join_style = GDK_JOIN_MITER;
  
#ifndef WIN32
  gdk_threads_enter();
#endif
  /* create gc */
  gc = gdk_gc_new (d);
  /* set forground color */
  gdk_gc_set_foreground (gc, &color );
  /**/
  gdk_gc_set_line_attributes(gc, width, penStyle, cap_style, join_style);
#ifndef WIN32
  gdk_threads_leave();
#endif
  /**/
  return (gc);
}

/////////////////////////////////////////////////////////////////
//
//		sammple code
//

void GpmWindow::sin_curve(int windowNo)
{
	int	t,ox,oy,width,height,xs,ys,xe,ye,height2;
	int num;
	double y,scale,ymax,ymin;
	int window;
	GpmWindow *pWindow;

	/*window*/
	window = windowNo;
	pWindow = pGpmWindow[window];
	/*Origin*/
	ox = 50;
	oy = 50;
	/*Size*/
	width = 300;
	height = 200;
	height2 = height / 2;
	/*Frame*/
	m_frameWidth = 1;
	m_frameStyle = 0;
	m_frameColor = 3;
	pWindow->Line(2, ox,oy,ox+width,oy);
	pWindow->Line(2, ox+width,oy,ox+width,oy+height);
	pWindow->Line(2, ox+width,oy+height,ox,oy+height);
	pWindow->Line(2, ox,oy+height,ox,oy);
	/*grid*/
	m_axisWidth = 1;
	m_axisStyle = 0;
	m_axisColor = 0;
	pWindow->Line(1,ox, oy+height2, ox+width, oy+height2);

	/*data*/
	m_lineWidth = 1;
	m_lineStyle = 0;
	m_lineColor = 1;
	ymax = 2.0;
	ymin = -2.0;
	num = 1000;
	xs = ox;
	ys = oy;
	scale = (double)height / (ymax - ymin);
	for(t=0;t<num;t++) {
		if(window == 0)
			y = sin(10 * 2*3.1415926/num*t);
		else if(window == 1)
			y = sin(10 * 2*3.1415926/num*t) + sin(15 * 2*3.1415926/num*t);
		else
			y = sin(10 * 2*3.1415926/num*t) +
				sin(15 * 2*3.1415926/num*t) + sin(20 * 2*3.1415926/num*t);
		if(t==0) {
			xe = xs;
			ye = oy + (int)(scale * (ymax-y));
			xs = xe; ys = ye;
		}
		else {
			xe = ox+(int)((double)width * t / num);
			ye = oy + (int)(scale * (ymax-y));
			pWindow->Line(0,xs, ys, xe, ye);
			xs = xe; ys = ye;
		}
	}
}

///////////////////////////////////////////////////////////////
//
//	XWindow
//

int GpmWindow::GdkXAllocNamedColor(char *name, XColor *color1, XColor *color2)
{
	return 0;
}

int GpmWindow::GdkXAllocColorCells()
{
	return 0;
}

void GpmWindow::GdkXStoreNamedColor()
{
}

void GpmWindow::GdkXSetForeground(GdkColor color)
{
#ifdef WIN32
	gdk_gc_set_foreground (gpm_gc, &color );
#else
	gdk_threads_enter();
	gdk_gc_set_foreground (gpm_gc, &color );
	gdk_threads_leave();
#endif
}

void GpmWindow::GdkXSetBackground(GdkColor color)
{
#ifdef WIN32
	gdk_gc_set_background (gpm_gc, &color );
#else
	gdk_threads_enter();
	gdk_gc_set_background (gpm_gc, &color );
	gdk_threads_leave();
#endif
}

GdkColormap * GpmWindow::GdkDefaultColormap()
{
	GdkColormap *map;
#ifdef WIN32
	map = gdk_colormap_get_system();
#else
	gdk_threads_enter();
	map = gdk_colormap_get_system();
	gdk_threads_leave();
#endif
	return map;
}

int GpmWindow::GdkDefaultDepth()
{
	return 1;
}

GdkColor GpmWindow::GdkWhitePixel()
{
	GdkColor c;
#ifdef WIN32
	gdk_color_white(gpm_cmap, &c);
#else
	gdk_threads_enter();
	gdk_color_white(gpm_cmap, &c);
	gdk_threads_leave();
#endif
	return c;
}

GdkColor GpmWindow::GdkBlackPixel()
{
	GdkColor c;
#ifdef WIN32
	gdk_color_black(gpm_cmap, &c);
#else
	gdk_threads_enter();
	gdk_color_black(gpm_cmap, &c);
	gdk_threads_leave();
#endif
	return c;
}

void GpmWindow::BkColorChange(GtkWidget *widget)
{
  //configure_event(widget, NULL);
#ifdef WIN32
	configure_event(widget, NULL);
	gdk_flush();
#else
	configure_event(widget, NULL);
	gdk_threads_enter();
	gdk_flush();
	gdk_threads_leave();
#endif
}

