/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: GpmWindow.h,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#if 0
typedef struct {
  short x, y;
} XPoint;
#endif

#define		XColor		GdkColor
#define		Colormap	GdkColormap

#ifdef GPM_DEBUG
/* unused definitions */
#define			O_RDWR		0
#define			O_RDONLY	1
#define			CoordModeOrigin		2
#define			Complex		3
#define			ArcPieSlice		4
#define			LineSolid		5
#define			LineDoubleDash		6
#define			CapButt			7
#define			JoinMiter		8
#define			GXxor			9
#define			GXclear			10
#define			GXcopy			11
#define			FillSolid		12
#endif

/***************************************************
 *		GpmWindow class
 ***************************************************/
class GpmWindow
{
// constructor
public:
	GpmWindow();
// destractor
	~GpmWindow();

// attribute
public:

// operation
public:
	// GpmWindow.cpp
	//int Create(int windowNo, const char *title, int windowX, int windowY);
#ifdef WIN32
	void __cdecl Create();
#else
	void Create();
#endif
	void Close(int windowNo);
	void Show();
	void Line(int penKind, gint x1, gint y1, gint x2, gint y2);
	GdkGC* GetPen (GdkDrawable *d, int penKind);
	void sin_curve(int windowNo);

	//wopen.cpp
	int	GPM_ginit();
	int GPM_wopen(int windowNo);
	void param_init();
	void set_default_param();
	void erase_win();
	void color_allocation();

	int GPM_axis();	/*axis.cpp*/
	int errorCheck( int a, int b, int c);
	void AxisType(int side, float *x, float *y, int *label_pos, float *theta);
	int LabelFormat(int side, char *axis_label, int label_type);
	int GPM_color();	/* newpen.cpp */
	int GPM_draw();		/*drawl.cpp*/
	int GPM_factor();	/*factor.cpp*/
	int	GPM_font();		/*font.cpp*/
	int GPM_frame();	/*frame.cpp*/
	int GPM_graph();	/*graph.cpp*/
	int zerop(int n_series, float **data);
	int convert_to_log( float **data, int n, int m, int is );
	void SetYscale(float **ydata, int n, int m, int is);
	void SetXscale(float **xdata, int n, int m, int is);
	void SetScale();
	void GetDrawScale( float *xMin, float *xMax, float *yMin, float *yMax );
	void set_data(int type, int dim, int *index, Buffer *buf);
	void btof(int dim, int *index, Buffer *buf, float **data);
	void scale(float **data, float *amin, float *amax, int n, int m);
	void scalg(float **data, float *amin, float *amax, int n, int m, int is);
	void disp_scale_mode(int mode1, int mode2);
	void OpenWindow();
	int  CloseWindow();

	int GPM_label();	/*label.cpp*/
	int GPM_line();		/*line.cpp*/
	int GPM_ltype();	/*ltype.cpp*/
	int GPM_lwidth();	/* lwidth.cpp */
	int GPM_origin();	/* origin.cpp */
	int GPM_size();		/* size.cpp */
	int GPM_title();	/* title.cpp */
	int GPM_egraph();	/* egraph.cpp */
	int GPM_gstat();	/* gstat.cpp */
	int GPM_prev();		/* prev.cpp */
	int GPM_noise();        /* noise.cpp */
	int GPM_image();	/* image.cpp or image_new.cpp */
	int GPM_xlabel();
	int GPM_roll();
	int myDrawString( char *text, int x, int y,
			int orient, int hpos, int vpos, char *fontname );
	/* gpmx1.c */
	int gopen(int paper, int orientation, int device, int win_num);
        int gclose();
	void gflush();
	void createrainbow();
	int createWin();
	GpmWinID getWindow(int win_num);
	void putWindow(int win_num, GpmWinID win);
	void setCols( int n, double r, double g, double b );
/*
	void set_tile_pattern(Display *display, int screen,
					       Drawable window, GC gc,
					       double level);
 */
	void set_tile_pattern ();
	/* gpmx2.c */
	void gplot(double x, double y, int imode);
	void gbox(double x1, double y1, double x2, double y2,
					int imode, double level);
	void glabel(double x, double y, char *ichar,
					double height, double theta, int imode);
	void gfont(int type);
	int groll();
	void gerase();
	void gframe();

	/* gpmx3.c */
	double gpm_aint(double x);
	void graph( float *xdata, float *ydata, int idat_number, int inc,
					int imode, int symbl, float simb_size );
	double gpm_autoscale( double a1, double a2 );
	void gaxis( double, double, double, double,
					double, double, double, int, int,
					char*, double, int, double ); 
	void gaxisl( double, double, double, double,
					double, double, int, int, 
					char*, double, int, double );

	/* gpmx4.c */
	void gcsize(double size);
	void gfactor(double factor);
	void gfsize(double x, double y);
	void glimit(double xmin, double ymin,
					double xmax, double ymax);
	void gnewpen(int color);
	void gorigin(double x, double y);
	void gpen(int ip_size, int ip_type,
					int ip_mode);
	void gscale(double xmin, double ymin,
					double xmax, double ymax);
	void grainbow(double level);

	/* gpmx5.c */
	void plot(double x, double y, int ipen_mode);
	int csymbol(double x, double y);
	int symbol( double x, double y, double rcos, double rsin );
	void label(double x, double y, char *ichar,
					double height, double theta, int mode);
	void box(double x1, double y1,
					double x2, double y2,
					int mode, double level);
	void plot_symbol( double x, double y, double rw, double rh,
				 double rcos, double rsin, int *SymBuf );
	void xy_sub( double x, double y, int iix, int iiy, int *ix, int *iy,
	   double rw, double rh, double rcos, double rsin );
//#ifdef GPM_LIB 
	void roll();
	void GpmSet_color(int color, int rainbow);
	void GpmSet_dash_width_dmode(int itype, int isize, int imode);
//#endif
	/*gpmdvi.cpp*/
	void getlength(int number, float *x, float *y, int rotate);
	double getfontwidth( int c, double height, int font );
	double getstrwidth( char *str, double height, int font );
	double trans_func(double x1, double y1, double x2, double y2, double x);
	int readdvihead();
	int createdvi(char *fname, int number, int irotate, int todvi);
	int checktodvi();
	int opendvi();
	int opendvi_for_read();
	int closedvi();
	void writegpm();
	void writeplot(double x, double y, int ipen_mode);
	void writebox(double x1, double y1, double x2, double y2, int mode, double level);
	void writecsymbol(double x, double y);
	void writelabel(double x, double y, char *ichar, double height, double theta, int imode);
	void writeroll();
	int readgpm();
	int readdvi();
	void readplot();
	void readbox();
	void readcsymbol();
	void readlabel();
	void readroll();
	int cpu_type();
	void reverse(char *s, int siz);
	/* rwgpm.cpp */
	int regpm();
	int wrgpm();
	int	createGpm2();
	int regpm2( int win_num );
	int	wrgpm2( int win_num );
	/* werase.cpp */
	int GPM_werase();
	/* scale.cpp */
	int GPM_scale();
	int set_minmax( char str, int arg, int narg, double mind, double maxd, float *min, float *max );
	int token_s(int *r_code, double *rnum);
	int sc_mode( char *s );
	int sc_type( char *s );
	/* cont.cpp */
	int GPM_cont();
	void contln(float **alt, int **ksw, int nx, int ny, float heit[],
		int nhd, int kh, double hx, double hy, int mode);
	void cont_search(float **alt, int **ksw, int nx, int ny, double hx, double hy,
			double hv, int kv, int ia, int ja, int *it, int *jt, int ks, int *irep);
	void cont_cpen(double data, double amin, double amax);
	/* ldata.cpp */
	float **ldata(int bufno, int nx, int ny, char *timeaxis, int viewpoint);
	void thinout(float **buf, int *nx, int *ny, int xdiv, int ydiv);
	char **_malloc2d(int nx,int ny,int siz);
	void _free2d(char **f, int nx,int ny);
	/*gsolm.cpp*/
	int GPM_gsolm();
	void isort(float **a, int nx, int ny);

	/*gsolm_sub.cpp*/
	void solm0r(float **a2, int **ia2, int nx, int ny,
		int mx, int my, float amxn[], float rhv[], int ifunc[],
		float xypl[2][2], int iipen1, int iipen2, int mode );
	void ting();
	void ting_sub();
	void ting_sub2();
	void point_check();
	int point_check_sub();
	void pre1();
	void pre2();
	void point_draw();
	void sub1();
	void cpen1(double data);
	void cpen2(double data);
	double sign(double val, double flag);
	void CPEN(double val);
	/*map.cpp*/
	int GPM_map();
	double norm(double data, double amin, double amax);
	int draw_box_( int ix, int iy, double size, double hx, double hy,
						 int fillmode, double level );
	void creategradation( int c );
	void setMonoCols( int n, double x, int c );
	void gradation(double level /* 0.0 <= level <= 1.0 */);
	/*interval.cpp*/
	void store_start_time();
	void wait_msec(int waittime);
	void wait_msec2(int waittime);
	/* chwin.cpp */
	int GPM_chwin(int windowNo);
	/* gpm2ps.cpp */
	void ps_origin(double x, double y);
	void ps_color(int color);
	void ps_set_rainbow_color( double level, double *r, double *g, double *b );
	void ps_rainbow(double level);
	void ps_plot(double x, double y, int mode);
	void ps_factor(double factor);
	void ps_box(double x1, double y1, double x2, double y2,
	   int mode, double level, int color);
	void ps_lwidth(int width);
	void ps_ltype(int type);
	void ps_string(double x, double y, char *str, double height, double theta,
		  int centermode, char font);
	void ps_flag(int sw);
	void ps_csymbol(double x, double y, int cdata, double height);
	void ps_open();
	void ps_close();
	int ps_init();
	void ps_roll();
	void ps_end();
	void ps_ginit();
	void ps_initAdobe(int paperSize, int orientation, char *creator, char *infilename);
	void ps_setTray(int paperSize, int orientation);
	void ps_page(int pageNumber);
	void ps_pages(int pageNumber);
	void ps_rainbow_mode(int mode);
	/* bgcolor.cpp*/
	int GPM_bgcolor(char *color);
	void BkColorChange(GtkWidget *widget);
	/* gpm2wmf command */
	void wmf_origin(FILE *fd, double x, double y);
	void wmf_color(FILE *fd, int color);
	void wmf_rainbow(FILE *fd, double level);
	void wmf_plot(FILE *fd, double x, double y, int mode);
	void wmf_factor(FILE *fd, double factor);
	void wmf_box(FILE *fd, double x1, double y1, double x2, double y2,
	   int mode, double level, int color);
	void wmf_lwidth(FILE *fd, int width);
	void wmf_ltype(FILE *fd, int type);
	void wmf_string(FILE *fd, double x, double y, char *str, double height, double theta,
		  int centermode, int font, double wsize);
	void wmf_csymbol(FILE *fd, double x, double y, int cdata, double height);
	void wmf_roll(FILE *fd );
	void wmf_ginit(FILE *fd );
	void wmf_page(FILE *fd, int pageNumber);
	void wmf_area(FILE *fd, double xmin, double ymin, double xmax, double ymax);

	// XWindow
	void GdkXSetForeground(GdkColor color);
	void GdkXSetBackground(GdkColor color);
	GdkColor GdkWhitePixel();
	GdkColor GdkBlackPixel();
	int GdkXAllocNamedColor(char *name, XColor *color1, XColor *color2);
	int GdkXAllocColorCells();
	void GdkXStoreNamedColor();
	GdkColormap* GdkDefaultColormap();
	int	GdkDefaultDepth();

	//gpm2file command implement
	int GPM_gpm2file();
	int create_gpm2wmf(int winno, char* fname);
	int create_gpm2ps(int winno, char* fname);

	//map command
	GdkColor get_rainbow( double level );
	void get_color(int color, double rgb[]);

// implementation
public:

// members
public:
	GtkWidget *m_window;
	GtkWidget *m_drawing_area;
	GtkWidget *m_vbox;
	GtkWidget *m_button;
	GdkPixmap *m_pixmap;
	guint	m_idle_handle_id;
	int	m_windowNo;
	char m_title[128];
	int	m_windowX;
	int	m_windowY;
	/* GPM structure */
	GpmContext  GpmCont;
	GdkGC		*gpm_gc;
	GdkFont		*gpm_font;
	int		ConfigureEvent;
	/* Key state */
	int KeyEvent;
	/* display flag */
	int		gpm_display;
	/* mouse position */
	int		m_xpointer;
	int		m_ypointer;
	float	m_datas[5];
	bool	m_compat2x;
	/* busy */
	int		m_now_drawing;
private:
	Mdev        mdev;
	Mgraph      mgraph;
	Mpen        mpen;
	Mscale      mscale;
	Msymbol     msymbol;
	Mwin        mwin;
	Plot        gpm_plot;
	Box         gpm_box;
	Csymbol     gpm_csymbol;
	Label       gpm_label;
	Param       gpm_param;
	GdkColormap		  *gpm_cmap;
	int               gpm_depth;
	GdkColor		gpm_color[MAX_COLOR];
	GdkColor		gpm_rainbow[RAINBOW_BASECOL * RAINBOW_DIVNUM + 2];
	//SystemCommon  syscom;

	// temporary
	int	m_lineColor;
	int	m_axisColor;
	int	m_frameColor;
	int	m_lineStyle;
	int	m_axisStyle;
	int	m_frameStyle;
	int	m_lineWidth;
	int	m_axisWidth;
	int	m_frameWidth;

	/* gpm2ps command */
	int	gpm_colorps_mode;
	int dvi_fd;
};

