/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: bgcolor.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <gtk/gtk.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
#include "GpmWindow.h"
#include "GpmThread.h"
#define  __IMPORTSYMBOL__
#include "libsatellite.h"
#undef   __IMPORTSYMBOL__

#ifndef True
#define True  1
#define False 0
#endif

typedef struct {
  char *name;
  int  no;
} BkColor;

BkColor           bkcolor[] = {
  {"black"  , 0}, {"red" , 1}, {"green"    , 2}, {"yellow", 3},
  {"blue"  , 4}, {"magenta" , 5}, {"cyan", 6}, {"white" , 7},
  {"BLACK", 0}, {"RED"   , 1}, {"GREEN"    , 2},
  {"YELLOW", 3}, {"BLUE"   , 4}, {"MAGENTA", 5},
  {"CYAN" , 6}, {"WHITE", 7},
  {NULL,    0}
};

#ifdef WIN32
#define CLR_BLACK	RGB(0,0,0)
#define	CLR_RED		RGB(255,0,0)
#define	CLR_GREEN	RGB(0,255,0)
#define	CLR_YELLOW	RGB(255,255,0)
#define	CLR_BLUE	RGB(0,0,255)
#define	CLR_PINK	RGB(255,0,255)
#define	CLR_CYAN	RGB(0,255,255)
#define	CLR_WHITE	RGB(255,255,255)

CHOOSECOLOR chclr;
COLORREF custclr[16] = {
	CLR_WHITE,CLR_WHITE,CLR_WHITE,CLR_WHITE,CLR_WHITE,
	CLR_WHITE,CLR_WHITE,CLR_WHITE,CLR_WHITE,CLR_WHITE,
	CLR_WHITE,CLR_WHITE,CLR_WHITE,CLR_WHITE,CLR_WHITE,
	CLR_WHITE };
COLORREF rgbColor = CLR_BLACK;
#else
GdkColor rgbColor = {0x0, 0xffff, 0xffff, 0xffff};
#endif

#ifdef WIN32
int GPM_bgcolor(char *colname)
{
	int n,number;

	number = -1;
	for (n = 0; bkcolor[n].name != NULL; n++) {
		if ( strcmp(colname, bkcolor[n].name) == 0 ) {
			number = bkcolor[n].no;
			break;
		}
	}
	switch(number){
	case 0: rgbColor = CLR_BLACK;	break;
	case 1: rgbColor = CLR_RED;	break;
	case 2: rgbColor = CLR_GREEN;	break;
	case 3: rgbColor = CLR_YELLOW;	break;
	case 4:	rgbColor = CLR_BLUE;	break;
	case 5: rgbColor = CLR_PINK;	break;
	case 6: rgbColor = CLR_CYAN;	break;
	case 7: rgbColor = CLR_WHITE;	break;
	}
  /*save*/
  char reg[_MAX_PATH];
  sprintf(reg, "SATELLITE %s", VERSION);
  WriteRegistInt(reg,"GpmColor",rgbColor);
	return 0;
}
#else
// Unix command
int GPM_bgcolor(char *colname)
{
	int n,number;
	number = -1;
	for (n = 0; bkcolor[n].name != NULL; n++) {
		if ( strcmp(colname, bkcolor[n].name) == 0 ) {
			number = bkcolor[n].no;
			break;
		}
	}
	switch(number){
	case 0:
	    rgbColor.red=0x0; rgbColor.green=0x0; rgbColor.blue=0x0;
		break;
	case 1:
	    rgbColor.red=0xff; rgbColor.green=0x0; rgbColor.blue=0x0;
		break;
	case 2:
	    rgbColor.red=0x0; rgbColor.green=0xff; rgbColor.blue=0x0;
		break;
	case 3:
	    rgbColor.red=0xff; rgbColor.green=0xff; rgbColor.blue=0x0;
		break;
	case 4:
	    rgbColor.red=0x0; rgbColor.green=0x0; rgbColor.blue=0xff;
		break;
	case 5:
	    rgbColor.red=0xff; rgbColor.green=0x0; rgbColor.blue=0xff;
		break;
	case 6:
	    rgbColor.red=0x0; rgbColor.green=0xff; rgbColor.blue=0xff;
		break;
	case 7:
	    rgbColor.red=0xff; rgbColor.green=0xff; rgbColor.blue=0xff;
		break;
	}
	return 0;
}
#endif

#ifdef WIN32
// Window command
void InitColorComnDlg()
{
	HWND hWnd;
	hWnd = FindWindow(NULL, "SATELLITE Language");

	chclr.lStructSize = sizeof(CHOOSECOLOR);
	if(hWnd)
		chclr.hwndOwner = hWnd;
	else
		chclr.hwndOwner = NULL;
	chclr.hInstance = 0;
	chclr.rgbResult = CLR_BLACK;
	chclr.lpCustColors = custclr;
	chclr.Flags = CC_RGBINIT | CC_FULLOPEN;
	chclr.lCustData = NULL;
	chclr.lpfnHook = NULL;
	chclr.lpTemplateName = NULL;
}


void ColorComnDlg()
{
	chclr.Flags = CC_RGBINIT;
	if( ChooseColor( &chclr ) ) {
		rgbColor = chclr.rgbResult;
	}
}

int GpmWindow::GPM_bgcolor(char *colname)
{
	int n,number;

	if(!colname) {
		InitColorComnDlg();
		ColorComnDlg();
	}
	else {
		number = -1;
		for (n = 0; bkcolor[n].name != NULL; n++) {
			if ( strcmp(colname, bkcolor[n].name) == 0 ) {
				number = bkcolor[n].no;
				break;
			}
		}
		switch(number){
		case 0: rgbColor = CLR_BLACK;	break;
		case 1: rgbColor = CLR_RED;	break;
		case 2: rgbColor = CLR_GREEN;	break;
		case 3: rgbColor = CLR_YELLOW;	break;
		case 4:	rgbColor = CLR_BLUE;	break;
		case 5: rgbColor = CLR_PINK;	break;
		case 6: rgbColor = CLR_CYAN;	break;
		case 7: rgbColor = CLR_WHITE;	break;
		}
	}
  /*save*/
  char reg[_MAX_PATH];
  sprintf(reg, "SATELLITE %s", VERSION);
  WriteRegistInt(reg,"GpmColor",rgbColor);
	return 0;
}
#else
// Unix command
int GpmWindow::GPM_bgcolor(char *colname)
{
	int n,number;
	number = -1;
	for (n = 0; bkcolor[n].name != NULL; n++) {
		if ( strcmp(colname, bkcolor[n].name) == 0 ) {
			number = bkcolor[n].no;
			break;
		}
	}
	switch(number){
	case 0:
	    rgbColor.red=0x0; rgbColor.green=0x0; rgbColor.blue=0x0;
		break;
	case 1:
	    rgbColor.red=0xffff; rgbColor.green=0x0; rgbColor.blue=0x0;
		break;
	case 2:
	    rgbColor.red=0x0; rgbColor.green=0xffff; rgbColor.blue=0x0;
		break;
	case 3:
	    rgbColor.red=0xffff; rgbColor.green=0xffff; rgbColor.blue=0x0;
		break;
	case 4:
	    rgbColor.red=0x0; rgbColor.green=0x0; rgbColor.blue=0xffff;
		break;
	case 5:
	    rgbColor.red=0xffff; rgbColor.green=0x0; rgbColor.blue=0xffff;
		break;
	case 6:
	    rgbColor.red=0x0; rgbColor.green=0xffff; rgbColor.blue=0xffff;
		break;
	case 7:
	    rgbColor.red=0xffff; rgbColor.green=0xffff; rgbColor.blue=0xffff;
		break;
	}
	return 0;
}
#endif
