/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: drawstr.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <math.h>
#include <gtk/gtk.h>

#include "SL_macro.h"
#include "SL_cmd.h"

void gpm_draw_string_with_theta( GdkWindow *window, GdkDrawable *drawable, GdkFont *font, GdkGC *gc,
                                 int x, int y, const char *str, int theta, 
                                 int hpos, int vpos){
  GdkImage  *Image;
  GdkPixmap *pixmap1;
  GdkGC     *tmp_gc;
  GdkColor   tmp_col;
  int    lb, rb, width, height, asc, desc;
  int    drawwidth, drawheight;
  int    posx, posy;
  int    offx,  offy;
  int    i,j;
  double rad, rsin, rcos;

  gdk_threads_enter();
  gdk_string_extents(font, str, &lb, &rb, &width, &asc, &desc);
  gdk_threads_leave();
  height = asc + desc;

  if( width == 0 || height == 0)return;
 
#if 0
  rad = - (double)theta * M_PI / 180.0;
  rcos = cos(rad);
  rsin = sin(rad);
  switch( hpos%3 ){
  default:
  case 0:  /* ALIGN_LEFT */
    offx = 0; 
    break;
  case 1:  /* ALIGN_RIGHT */
    offx = -width;
    break;
  case 2:  /* ALIGN_CENTER */
    offx = -width/2;
    break;
  }

  switch(vpos%3) {
  default:
  case 0: /* ALIGN_TOP */
    offy = 0;
    break;
  case 1: /* ALIGN_MIDDLE */
    offy = -height/2;
    break;
  case 2: /* ALIGN_BOTTOM */
    offy = -height;
    break;
  }
#else
  rad = -(double)theta * M_PI / 180.0;
  rcos = cos(rad);
  rsin = sin(rad);
  offx = /*width*rcos*/ - height * rsin;
  offy = /*width*rsin*/ + height * rcos;
#endif

    gdk_threads_enter();
  pixmap1 = gdk_pixmap_new( window, width, height, -1);
    gdk_threads_leave();
    gdk_threads_enter();
  tmp_gc=gdk_gc_new(pixmap1);
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_gc_set_font(tmp_gc, font);
    gdk_threads_leave();

  /* XSetForeground(gpm_display,tmp_gc,1); */
  /* XFillRectangle(gpm_display,pixmap1,tmp_gc,0,0,width,height); */
  tmp_col.pixel = 0xffffff;
    gdk_threads_enter();
  gdk_gc_set_foreground(tmp_gc, &tmp_col);
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_draw_rectangle(pixmap1, tmp_gc, 1, 0, 0, width, height);
    gdk_threads_leave();

  /* pixel  = AllocColor(gpm_display,gpm_cmap,color,&xcol); */
  /* XSetForeground(gpm_display,tmp_gc,pixel); */
  /* XmbDrawString(gpm_display,pixmap1,font,tmp_gc,0,
                   -desc, str,strlen(str)); */
  tmp_col.pixel = 0x00;
    gdk_threads_enter();
  gdk_gc_set_foreground(tmp_gc, &tmp_col);
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_draw_string(pixmap1, font, tmp_gc, 0, asc, str);
    gdk_threads_leave();
  /* Image = XGetImage(gpm_display, pixmap1,0,0,width,height,
                       AllPlanes,XYPixmap); */

    gdk_threads_enter();
  Image = gdk_image_get(pixmap1, 0, 0, width, height);
    gdk_threads_leave();

  for ( i=0 ; i<width; i++ ) {
    for ( j=0 ; j<height; j++ ) {
  gdk_threads_enter();
#ifndef WIN32
  if(( gdk_image_get_pixel( Image, i, j ) ) != 0x00 ) {
	gdk_threads_leave();
	continue;
  }
#else
  if(( gdk_image_get_pixel( Image, i, j ) ) == 0xffffff ) {
	gdk_threads_leave();
	continue;
  }
#endif
  gdk_threads_leave();
      posx = x - offx + (int)(floor((double)i * rcos - (double)j * rsin));
      posy = y - offy + (int)(floor((double)i * rsin + (double)j * rcos));
  gdk_threads_enter();
      gdk_draw_point(drawable/*window*/, gc, posx, posy);
  gdk_threads_leave();
    }
  }

  gdk_threads_enter();
  gdk_gc_unref(tmp_gc);
  gdk_threads_leave();
  gdk_threads_enter();
  gdk_pixmap_unref(pixmap1);
  gdk_threads_leave();
  /* gdk_image_destroy(Image); */
}

